/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.security;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.support.tools.security.AuthenticationException;
import com.atlassian.support.tools.security.AuthorisationException;
import org.apache.commons.lang.StringUtils;

public class PermissionValidationService {
    private final I18nResolver i18nResolver;
    private final UserManager userManager;

    public PermissionValidationService(I18nResolver i18nResolver, UserManager userManager) {
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
    }

    public void validateIsAdmin() {
        this.validateIsAuthenticated();
        if (!this.userManager.isAdmin(this.userManager.getRemoteUsername())) {
            throw new AuthorisationException(this.i18nResolver.getText("stp.security.admin.required"));
        }
    }

    public void validateIsAuthenticated() {
        if (StringUtils.isBlank((String)this.userManager.getRemoteUsername())) {
            throw new AuthenticationException(this.i18nResolver.getText("stp.security.not.authenticated"));
        }
    }

    public void validateIsSysadmin() {
        this.validateIsAuthenticated();
        if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
            throw new AuthorisationException(this.i18nResolver.getText("stp.security.sysadmin.required"));
        }
    }
}

