/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.scheduler;

import com.atlassian.scheduler.config.Schedule;
import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ScheduleFactory {
    public Schedule createSchedule(long intervalMillis, int startHour, int startMinute) {
        Preconditions.checkArgument((intervalMillis > 0L ? 1 : 0) != 0, (String)"Interval must be positive: %s", (Object[])new Object[]{intervalMillis});
        Preconditions.checkArgument((startHour >= 0 && startHour <= 23 ? 1 : 0) != 0, (String)"Start hour must be between 0 & 23: %s", (Object[])new Object[]{startHour});
        Preconditions.checkArgument((startMinute >= 0 && startMinute <= 60 ? 1 : 0) != 0, (String)"Start minute must be between 0 & 60: %s", (Object[])new Object[]{startMinute});
        GregorianCalendar nextExecutionDate = new GregorianCalendar();
        nextExecutionDate.set(11, startHour);
        nextExecutionDate.set(12, startMinute);
        nextExecutionDate.set(13, 0);
        nextExecutionDate.set(14, 0);
        while (nextExecutionDate.getTime().getTime() < System.currentTimeMillis()) {
            ((Calendar)nextExecutionDate).add(14, (int)intervalMillis);
        }
        return Schedule.forInterval(intervalMillis, nextExecutionDate.getTime());
    }
}

