/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.scheduler;

import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.IntervalScheduleInfo;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;

public class FallbackSchedulerService
implements SchedulerService {
    private static String KEY_JOB_CONFIG = "job-config";
    private static String KEY_JOB_ID = "job-id";
    private static String KEY_SCHEDULER_SERVICE = "scheduler-service";
    private static final Function<JobConfig, JobRunnerKey> TO_RUNNER_KEY = new Function<JobConfig, JobRunnerKey>(){

        public JobRunnerKey apply(JobConfig config) {
            return config.getJobRunnerKey();
        }
    };
    private final Map<JobRunnerKey, JobRunner> jobRunners;
    private final Map<JobId, JobConfig> scheduledJobs;
    private final PluginScheduler scheduler;

    public FallbackSchedulerService(PluginScheduler scheduler) {
        this.scheduler = scheduler;
        this.jobRunners = Maps.newConcurrentMap();
        this.scheduledJobs = Maps.newConcurrentMap();
    }

    @Override
    public void registerJobRunner(@Nonnull JobRunnerKey jobRunnerKey, @Nonnull JobRunner jobRunner) {
        this.jobRunners.put(jobRunnerKey, jobRunner);
    }

    @Override
    public void unregisterJobRunner(@Nonnull JobRunnerKey jobRunnerKey) {
        this.jobRunners.remove(jobRunnerKey);
    }

    @Override
    @Nonnull
    public Set<JobRunnerKey> getRegisteredJobRunnerKeys() {
        return ImmutableSet.copyOf(this.jobRunners.keySet());
    }

    @Override
    @Nonnull
    public Set<JobRunnerKey> getJobRunnerKeysForAllScheduledJobs() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.scheduledJobs.values(), TO_RUNNER_KEY));
    }

    @Override
    public void scheduleJob(@Nonnull JobId jobId, @Nonnull JobConfig jobConfig) throws SchedulerServiceException {
        if (jobConfig.getSchedule().getType() == Schedule.Type.CRON_EXPRESSION) {
            throw new IllegalArgumentException("The fallback scheduler does not support CRON expressions");
        }
        this.unscheduleJob(jobId);
        this.scheduledJobs.put(jobId, jobConfig);
        IntervalScheduleInfo interval = jobConfig.getSchedule().getIntervalScheduleInfo();
        ImmutableMap contextMap = ImmutableMap.of((Object)KEY_JOB_CONFIG, (Object)jobConfig, (Object)KEY_JOB_ID, (Object)jobId, (Object)KEY_SCHEDULER_SERVICE, (Object)this);
        this.scheduler.scheduleJob(jobId.toString(), JobRunnerAdapter.class, (Map)contextMap, interval.getFirstRunTime(), interval.getIntervalInMillis());
    }

    @Override
    @Nonnull
    public JobId scheduleJobWithGeneratedId(@Nonnull JobConfig jobConfig) throws SchedulerServiceException {
        JobId jobId = JobId.of(UUID.randomUUID().toString());
        this.scheduleJob(jobId, jobConfig);
        return jobId;
    }

    @Override
    public void unscheduleJob(@Nonnull JobId jobId) {
        this.scheduledJobs.remove(jobId);
        try {
            this.scheduler.unscheduleJob(jobId.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public JobDetails getJobDetails(@Nonnull JobId jobId) {
        JobConfig config = this.scheduledJobs.get(jobId);
        return config == null ? null : new SimpleJobDetails(jobId, config);
    }

    @Override
    @Nonnull
    public List<JobDetails> getJobsByJobRunnerKey(@Nonnull JobRunnerKey jobRunnerKey) {
        ArrayList<JobDetails> result = new ArrayList<JobDetails>();
        for (Map.Entry<JobId, JobConfig> entry : this.scheduledJobs.entrySet()) {
            if (!jobRunnerKey.equals(entry.getValue().getJobRunnerKey())) continue;
            result.add(new SimpleJobDetails(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    JobRunner getJobRunner(JobRunnerKey jobRunnerKey) {
        return this.jobRunners.get(jobRunnerKey);
    }

    private static class SimpleRunnerJobRequest
    implements JobRunnerRequest {
        private final JobConfig jobConfig;
        private final JobId jobId;
        private final Date startTime;

        private SimpleRunnerJobRequest(JobId jobId, JobConfig jobConfig) {
            this.jobConfig = jobConfig;
            this.jobId = jobId;
            this.startTime = new Date();
        }

        @Override
        @Nonnull
        public Date getStartTime() {
            return new Date(this.startTime.getTime());
        }

        @Override
        @Nonnull
        public JobId getJobId() {
            return this.jobId;
        }

        @Override
        @Nonnull
        public JobConfig getJobConfig() {
            return this.jobConfig;
        }
    }

    private static class SimpleJobDetails
    implements JobDetails {
        private final JobConfig config;
        private final JobId jobId;

        private SimpleJobDetails(JobId jobId, JobConfig config) {
            this.config = config;
            this.jobId = jobId;
        }

        @Override
        @Nonnull
        public JobId getJobId() {
            return this.jobId;
        }

        @Override
        @Nonnull
        public JobRunnerKey getJobRunnerKey() {
            return this.config.getJobRunnerKey();
        }

        @Override
        @Nonnull
        public RunMode getRunMode() {
            return this.config.getRunMode();
        }

        @Override
        @Nonnull
        public Schedule getSchedule() {
            return this.config.getSchedule();
        }

        @Override
        public Date getNextRunTime() {
            return null;
        }

        @Override
        @Nonnull
        public Map<String, Serializable> getParameters() {
            return this.config.getParameters();
        }

        @Override
        public boolean isRunnable() {
            return true;
        }
    }

    public static class JobRunnerAdapter
    implements PluginJob {
        public void execute(Map<String, Object> jobDataMap) {
            JobId jobId = (JobId)jobDataMap.get(KEY_JOB_ID);
            JobConfig jobConfig = (JobConfig)jobDataMap.get(KEY_JOB_CONFIG);
            FallbackSchedulerService scheduler = (FallbackSchedulerService)jobDataMap.get(KEY_SCHEDULER_SERVICE);
            JobRunner runner = scheduler.getJobRunner(jobConfig.getJobRunnerKey());
            if (runner != null) {
                runner.runJob(new SimpleRunnerJobRequest(jobId, jobConfig));
            }
        }
    }
}

