/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.output;

import com.atlassian.support.tools.properties.PropertyStore;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.util.NonLazyElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSupportInfoFormatter {
    private static final String UNKNOWN = "unknown";
    private static final Logger log = LoggerFactory.getLogger(XmlSupportInfoFormatter.class);

    public static String getFormattedProperties(PropertyStore properties, Properties propertyNameMappings, String stpVersion, String applicationName, String applicationVersion, String applicationSEN, String applicationID) {
        Document doc = DocumentHelper.createDocument();
        NonLazyElement root = new NonLazyElement("properties");
        doc.setRootElement((Element)root);
        Element stpElement = root.addElement("stp-version");
        stpElement.setText(stpVersion != null ? stpVersion : UNKNOWN);
        Element productElement = root.addElement("product");
        productElement.addAttribute("name", applicationName);
        productElement.addAttribute("version", applicationVersion);
        String rawTimezone = System.getProperty("user.timezone");
        TimeZone timeZone = TimeZone.getTimeZone(rawTimezone);
        int offsetMS = timeZone.getRawOffset() + (timeZone.inDaylightTime(new Date()) ? timeZone.getDSTSavings() : 0);
        int offsetHour = offsetMS / 1000 / 60 / 60;
        String timezoneStringInGMT = "GMT" + (offsetHour >= 0 ? "+" : "") + offsetHour;
        Element tzElement = root.addElement("timeZone");
        tzElement.setText(timezoneStringInGMT);
        Element senElement = root.addElement("sen");
        senElement.setText(applicationSEN != null ? applicationSEN : UNKNOWN);
        Element serverIdElement = root.addElement("serverId");
        serverIdElement.setText(applicationID != null ? applicationID : UNKNOWN);
        XmlSupportInfoFormatter.loadStore(properties, (Element)root, propertyNameMappings);
        OutputFormat format = OutputFormat.createPrettyPrint();
        StringWriter stringWriter = new StringWriter();
        try {
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, format);
            xmlWriter.write(doc);
        }
        catch (Exception e) {
            log.error("Couldn't write XML output", (Throwable)e);
        }
        return stringWriter.toString();
    }

    private static String escapeKeysForXMLOutput(String key) {
        if (key.endsWith("-")) {
            key = key + "x";
        }
        if (key.startsWith("-")) {
            key.replaceFirst("-", "");
        }
        if (key.startsWith("=")) {
            key.replaceFirst("=", "");
        }
        return key.replace(' ', '-').replace("(", "").replace(")", "").replace("#", "").replace("+", "").replace("&", "&amp;").replace("\"", "&quot;").replace("'", "&apos;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static void loadStore(PropertyStore store, Element element, Properties xmlElementNames) {
        String key;
        for (Map.Entry<String, String> entry : store.getValues().entrySet()) {
            if (entry.getValue() == null || StringUtils.isEmpty((String)entry.getValue())) continue;
            key = xmlElementNames.getProperty(entry.getKey(), entry.getKey());
            try {
                Element valueElement = element.addElement(XmlSupportInfoFormatter.escapeKeysForXMLOutput(key));
                valueElement.setText(entry.getValue());
            }
            catch (IllegalAddException e) {
                log.error("Unable to add child element '{}' to element '{}'...", new Object[]{key, element.getName(), e});
            }
        }
        for (Map.Entry<String, Object> entry : store.getCategories().entrySet()) {
            key = xmlElementNames.getProperty(entry.getKey(), entry.getKey());
            Iterable categoryList = (Iterable)entry.getValue();
            for (PropertyStore childObject : categoryList) {
                if (childObject instanceof PropertyStore) {
                    Element listChildElement = element.addElement(XmlSupportInfoFormatter.escapeKeysForXMLOutput(key));
                    XmlSupportInfoFormatter.loadStore(childObject, listChildElement, xmlElementNames);
                    continue;
                }
                log.warn("Couldn't add child object of type '{}' with key '{}' to PropertyStore.", (Object)((List)entry.getValue()).getClass().getCanonicalName(), (Object)key);
            }
        }
    }
}

