/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.jira.JiraApplicationContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.SimpleSupportMailQueueItem;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import java.io.IOException;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraMailUtility
extends AbstractMailUtility {
    private static final Logger log = LoggerFactory.getLogger(JiraMailUtility.class);
    public static final String HEADER_JIRA_FINGER_PRINT = "X-JIRA-FingerPrint";

    @Override
    protected void sendSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, MessagingException, IOException {
        JiraApplicationContext context = (JiraApplicationContext)ComponentAccessor.getComponent(JiraApplicationContext.class);
        requestInfo.addHeader(HEADER_JIRA_FINGER_PRINT, context.getFingerPrint());
        super.sendSupportRequestEmail(requestInfo, info);
    }

    @Override
    public void sendMail(Email email) {
        SimpleSupportMailQueueItem item = new SimpleSupportMailQueueItem(email);
        if (this.isMailServerConfigured()) {
            ComponentAccessor.getMailQueue().addItem((MailQueueItem)item);
            log.debug("Added message '{}' to JIRA's mail queue...", (Object)item.getSubject());
        } else {
            try {
                item.send();
                log.debug("Sent message '{}' using Atlassian's mail servers...", (Object)item.getSubject());
            }
            catch (MailException e) {
                log.error("Exception sending email using Atlassian's mail servers:", (Throwable)e);
            }
        }
    }
}

