/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.SimpleSupportMailQueueItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailUtility
extends AbstractMailUtility {
    private MultiQueueTaskManager taskManager;
    private static final Logger log = LoggerFactory.getLogger(ConfluenceMailUtility.class);

    public ConfluenceMailUtility(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public void sendMail(Email email) {
        SimpleSupportMailQueueItem item = new SimpleSupportMailQueueItem(email);
        if (this.isMailServerConfigured()) {
            this.taskManager.addTask("mail", (Task)item);
            log.debug("Added message '{}' to the Confluence mail queue...", (Object)item.getSubject());
        } else {
            try {
                item.send();
                log.debug("Sent message '{}' using Atlassian's mail servers.", (Object)item.getSubject());
            }
            catch (MailException e) {
                log.error("Error sending mail using Atlassian's mail servers:", (Throwable)e);
            }
        }
    }
}

