/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.SimpleSupportMailQueueItem;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestAttachment;
import com.atlassian.support.tools.salext.mail.SupportRequestMailQueueItem;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketMailUtility
extends AbstractMailUtility {
    private static final Logger log = LoggerFactory.getLogger(AbstractMailUtility.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final MailService mailService;

    public BitbucketMailUtility(ApplicationPropertiesService applicationPropertiesService, MailService mailService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.mailService = mailService;
    }

    @Override
    public String getDefaultFromAddress() {
        return this.applicationPropertiesService.getServerEmailAddress();
    }

    @Override
    public boolean isMailServerConfigured() {
        return this.mailService.isHostConfigured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, MessagingException, IOException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.mailService.getClass().getClassLoader());
            if (this.isMailServerConfigured()) {
                MailMessage.Builder builder = new MailMessage.Builder().from(requestInfo.getFromAddress()).subject(requestInfo.getSubject()).text(requestInfo.getBody()).to(new String[]{requestInfo.getToAddress()});
                for (Map.Entry<String, String> header : requestInfo.getHeaders()) {
                    builder.header(header.getKey(), header.getValue());
                }
                for (SupportRequestAttachment attachment : requestInfo.getAttachments()) {
                    Serializable data = attachment.getData();
                    if (data instanceof byte[]) {
                        builder.attachment(attachment.getName(), (DataSource)new ByteArrayDataSource((byte[])data, attachment.getType()));
                        continue;
                    }
                    if (data instanceof String) {
                        builder.attachment(attachment.getName(), (DataSource)new ByteArrayDataSource(((String)((Object)data)).getBytes(), attachment.getType()));
                        continue;
                    }
                    if (data instanceof File) {
                        builder.attachment(attachment.getName(), (File)data);
                        continue;
                    }
                    log.warn("Attachment [{}], of declared type [{}], contains unexpected data: '{}'. It will not be added to the mail message", (Object[])new String[]{attachment.getName(), attachment.getType(), data == null ? "(Null)" : data.getClass().getName()});
                }
                this.mailService.submit(builder.build());
                log.info("Sent support request to {} using configured MailService", (Object)requestInfo.getToAddress());
            } else {
                Properties props = new Properties();
                props.setProperty("mail.smtp.host", "mail.atlassian.com");
                props.put("mail.smtp.starttls.enable", String.valueOf(true));
                Session session = Session.getInstance((Properties)props);
                MimeMessage msg = new MimeMessage(session);
                msg.setContent(SupportRequestMailQueueItem.toMultiPart(requestInfo));
                msg.setFrom((Address)new InternetAddress(requestInfo.getFromAddress()));
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)requestInfo.getToAddress(), (boolean)false));
                msg.setSubject(requestInfo.getSubject());
                for (Map.Entry<String, String> entry : requestInfo.getHeaders()) {
                    msg.addHeader(entry.getKey(), entry.getValue());
                }
                Transport.send((Message)msg);
                log.info("Sent support request to {} using Atlassian mail server", (Object)requestInfo.getToAddress());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMail(Email email) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.mailService.getClass().getClassLoader());
            if (this.isMailServerConfigured()) {
                MailMessage.Builder builder = new MailMessage.Builder().from(email.getFrom()).subject(email.getSubject()).text(email.getBody()).to(new String[]{email.getTo()});
                Iterator iterator = email.getHeaders().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    builder.header(entry.getKey().toString(), entry.getValue().toString());
                }
                if (StringUtils.isNotBlank((String)email.getMimeType())) {
                    builder.header("Content-Type", email.getMimeType());
                }
                this.mailService.submit(builder.build());
            } else {
                try {
                    Properties props = new Properties();
                    props.setProperty("mail.smtp.host", "mail.atlassian.com");
                    props.put("mail.smtp.starttls.enable", String.valueOf(true));
                    Session session = Session.getInstance((Properties)props);
                    MimeMessage msg = new MimeMessage(session);
                    if (email.getMultipart() != null) {
                        msg.setContent(email.getMultipart());
                    } else {
                        msg.setContent((Object)email.getBody(), StringUtils.defaultString((String)email.getMimeType(), (String)"text/plain"));
                    }
                    msg.setFrom((Address)new InternetAddress(email.getFrom()));
                    msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)email.getTo(), (boolean)false));
                    msg.setSubject(email.getSubject());
                    Iterator entry = email.getHeaders().entrySet().iterator();
                    while (entry.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry2 = o = entry.next();
                        msg.addHeader(entry2.getKey().toString(), entry2.getValue().toString());
                    }
                    Transport.send((Message)msg);
                    SimpleSupportMailQueueItem item = new SimpleSupportMailQueueItem(email);
                    item.send();
                    log.debug("Sent message '{}'' using Atlassian's mail servers.", (Object)item.getSubject());
                }
                catch (Exception e) {
                    log.error("Error sending mail using Atlassian's mail servers:", (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

