/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.SimpleSupportMailQueueItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BambooMailUtility
extends AbstractMailUtility {
    private static final Logger log = LoggerFactory.getLogger(BambooMailUtility.class);

    @Override
    public boolean isMailServerConfigured() {
        MailServerManager serverManager = MailFactory.getServerManager();
        if (serverManager == null) {
            return false;
        }
        try {
            return serverManager.getDefaultSMTPMailServer() != null;
        }
        catch (MailException e) {
            log.warn("Failed to obtain a mail server.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMail(Email email) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (MailFactory.getServerManager() != null) {
                Thread.currentThread().setContextClassLoader(MailFactory.getServerManager().getClass().getClassLoader());
            }
            SimpleSupportMailQueueItem item = new SimpleSupportMailQueueItem(email);
            item.send();
        }
        catch (MailException e) {
            log.error("Error sending mail using Atlassian mail servers:", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

