/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.license;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import org.apache.commons.lang.StringUtils;

public class LicenseStatusService {
    private static final String BANNER_HIDDEN_TILL_DAY = "bannerHiddenTillDay";
    private final UserManager userManager;
    private final PluginSettings pluginSettings;

    public LicenseStatusService(UserManager userManager, PluginSettingsFactory pluginSettingsFactory) {
        this.userManager = userManager;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public void setHiddenUntilDays(int hiddenTillDays) {
        this.pluginSettings.put(this.getUserSettingKey(this.userManager.getRemoteUsername()), (Object)Integer.valueOf(hiddenTillDays).toString());
    }

    public int getBannerHiddenTillDays() {
        String settingValue = (String)this.pluginSettings.get(this.getUserSettingKey(this.userManager.getRemoteUsername()));
        if (StringUtils.isBlank((String)settingValue)) {
            return 30;
        }
        try {
            return Integer.parseInt(settingValue);
        }
        catch (NumberFormatException e) {
            return 30;
        }
    }

    public boolean shouldKeepBannerHidden(int daysToExpiry) {
        int hiddenTillDays = this.getBannerHiddenTillDays();
        if (hiddenTillDays == -1) {
            return true;
        }
        if (hiddenTillDays == 0) {
            return daysToExpiry < 7;
        }
        return daysToExpiry > hiddenTillDays;
    }

    private String getUserSettingKey(String username) {
        return BANNER_HIDDEN_TILL_DAY + username;
    }

    public void resetBannerHiddenProperty() {
        this.pluginSettings.remove(this.getUserSettingKey(this.userManager.getRemoteUsername()));
    }
}

