/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.license;

import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.sal.api.ApplicationProperties;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class JiraLicenseHelper {
    private static final int JIRA_BUILD_NUMBER_7_0_MINIMUM_WITH_SNAPSHOT = 70007;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper i18nHelper;
    private final UserUtil userUtil;

    public JiraLicenseHelper(ApplicationProperties applicationProperties, I18nHelper i18nHelper, UserUtil userUtil) {
        this.applicationProperties = applicationProperties;
        this.i18nHelper = i18nHelper;
        this.userUtil = userUtil;
    }

    public LicenseDetails getLicenseDetails(JiraLicenseService licenseService) {
        try {
            Class<?> licenseServiceClass = Class.forName("com.atlassian.jira.bc.license.JiraLicenseService");
            if (licenseServiceClass.isAssignableFrom(licenseService.getClass()) && this.isJira7OrAbove()) {
                Method getLicensesMethod = licenseServiceClass.getMethod("getLicenses", new Class[0]);
                Iterable license = (Iterable)getLicensesMethod.invoke((Object)licenseService, new Object[0]);
                return (LicenseDetails)license.iterator().next();
            }
            return licenseService.getLicense();
        }
        catch (Exception e) {
            return licenseService.getLicense();
        }
    }

    public Map<String, String> getLicenseInfo(LicenseDetails licenseDetails) {
        LinkedHashMap<String, String> licenseInfo = new LinkedHashMap<String, String>();
        licenseInfo.put(this.getText("admin.license.date.purchased"), licenseDetails.getPurchaseDate(this.getOutlookDate()));
        licenseInfo.put(this.getText("admin.license.type"), licenseDetails.getDescription());
        if (!licenseDetails.isUnlimitedNumberOfUsers()) {
            int userLimit = this.getMaximumNumberOfUsers(licenseDetails);
            licenseInfo.put(this.getText("admin.license.user.limit"), userLimit + " (" + this.getText("admin.license.active.user.count", String.valueOf(this.userUtil.getActiveUserCount())) + ")");
        }
        licenseInfo.put(this.getText("admin.license.maintenance.period.end.date"), licenseDetails.getMaintenanceEndString(this.getOutlookDate()));
        licenseInfo.put(this.getText("admin.license.maintenance.status"), licenseDetails.getBriefMaintenanceStatusMessage(this.i18nHelper));
        licenseInfo.put(this.getText("admin.license.sen"), StringUtils.isNotBlank((String)licenseDetails.getSupportEntitlementNumber()) ? licenseDetails.getSupportEntitlementNumber() : this.getText("common.concepts.not.applicable"));
        return licenseInfo;
    }

    private int getMaximumNumberOfUsers(LicenseDetails licenseDetails) {
        try {
            Class<?> licenseDetailsClass = Class.forName("com.atlassian.jira.license.LicenseDetails");
            if (licenseDetailsClass.isAssignableFrom(licenseDetails.getClass()) && this.isJira7OrAbove()) {
                Method getJiraLicenseMethod = licenseDetailsClass.getMethod("getJiraLicense", new Class[0]);
                JiraLicense jiraLicense = (JiraLicense)getJiraLicenseMethod.invoke((Object)licenseDetails, new Object[0]);
                return jiraLicense.getMaximumNumberOfUsers();
            }
            return licenseDetails.getMaximumNumberOfUsers();
        }
        catch (Exception e) {
            return licenseDetails.getMaximumNumberOfUsers();
        }
    }

    private OutlookDate getOutlookDate() {
        return ((OutlookDateManager)ComponentAccessor.getComponent(OutlookDateManager.class)).getOutlookDate(this.i18nHelper.getLocale());
    }

    private boolean isJira7OrAbove() {
        return Integer.parseInt(this.applicationProperties.getBuildNumber()) >= 70007;
    }

    private String getText(String key) {
        return this.i18nHelper.getText(key);
    }

    private String getText(String key, String value1) {
        return this.i18nHelper.getText(key, value1);
    }
}

