/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.license;

import com.atlassian.support.tools.ApplicationVersionInfo;
import com.atlassian.support.tools.salext.ApplicationType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;

public class IsSupportedApplicationConditionChecker {
    private static final ImmutableMap<ApplicationType, Integer> SUPPRESS_BANNERS;
    private final ApplicationVersionInfo applicationVersionInfo;

    public IsSupportedApplicationConditionChecker(ApplicationVersionInfo applicationVersionInfo) {
        this.applicationVersionInfo = (ApplicationVersionInfo)Preconditions.checkNotNull((Object)applicationVersionInfo);
    }

    public boolean isSupportedApplication() {
        Integer suppressAfter = (Integer)SUPPRESS_BANNERS.get((Object)this.applicationVersionInfo.getApplicationType());
        if (suppressAfter == null) {
            return true;
        }
        try {
            String applicationBuildNumber = this.applicationVersionInfo.getApplicationBuildNumber();
            int buildNumber = Integer.parseInt(applicationBuildNumber, 10);
            return buildNumber < suppressAfter;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static {
        ImmutableMap.Builder bob = new ImmutableMap.Builder();
        bob.put((Object)ApplicationType.JIRA, (Object)6327);
        bob.put((Object)ApplicationType.CONFLUENCE, (Object)5618);
        SUPPRESS_BANNERS = bob.build();
    }
}

