/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle;

import com.atlassian.support.healthcheck.api.model.HealthCheckFilter;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatus;
import com.atlassian.support.healthcheck.impl.SupportHealthCheckManager;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.AbstractApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthcheckResultsBundle
extends AbstractApplicationFileBundle {
    private static final Logger log = LoggerFactory.getLogger(HealthcheckResultsBundle.class);
    private final SupportApplicationInfo info;
    private final BundleContext bundleContext;
    private final Map<String, String> results = new HashMap<String, String>();

    public HealthcheckResultsBundle(BundleManifest bundle, String title, String description, SupportApplicationInfo info, BundleContext bundleContext) {
        super(bundle, title, description);
        this.info = info;
        this.bundleContext = bundleContext;
    }

    @Override
    public Map<String, String> getFiles() {
        File supportDir = new File(this.info.getApplicationHome(), "logs/support");
        if (supportDir.exists() || supportDir.mkdirs()) {
            this.results.putAll(this.getHealthcheckResults(supportDir));
        } else {
            log.error("Couldn't create export directory {}", (Object)supportDir.getAbsolutePath());
        }
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getHealthcheckResults(File directory) {
        HashMap<String, String> tmpResults = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        ServiceReference sr = this.bundleContext.getServiceReference("com.atlassian.support.healthcheck.impl.SupportHealthCheckManager");
        if (sr != null) {
            try {
                SupportHealthCheckManager supportHealthCheckManager = (SupportHealthCheckManager)this.bundleContext.getService(sr);
                if (supportHealthCheckManager != null) {
                    List statuses = supportHealthCheckManager.performChecks(HealthCheckFilter.ALL);
                    for (HealthCheckStatus status : statuses) {
                        sb.append(status.toString());
                        sb.append("\n");
                    }
                }
            }
            finally {
                this.bundleContext.ungetService(sr);
            }
        }
        try {
            File resultsFile = new File(directory, "healthcheckResults.txt");
            FileWriter writer = new FileWriter(resultsFile);
            try {
                String resultsString = sb.toString();
                if (resultsString.isEmpty()) {
                    writer.write("No healthcheck results");
                }
                writer.write(resultsString);
            }
            catch (IOException e) {
                log.error("Failed to write healthchecks to {}.", (Object)resultsFile.getPath(), (Object)e);
            }
            finally {
                writer.flush();
                writer.close();
            }
            tmpResults.put(resultsFile.getAbsolutePath(), "");
        }
        catch (Exception e) {
            log.error("Can't generate healthchecks results file.", (Throwable)e);
        }
        return tmpResults;
    }
}

