/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle;

import com.atlassian.support.tools.salext.bundle.AbstractApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.fileset.FileSet;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class FileSetsBundle
extends AbstractApplicationFileBundle {
    private final List<FileSet> fileSets;

    private FileSetsBundle(Builder builder) {
        super(builder.bundle, builder.title, builder.description);
        this.fileSets = builder.fileSetsBuilder.build();
    }

    public static Builder builder(BundleManifest bundle, String title, String description) {
        return new Builder(bundle, title, description);
    }

    @Override
    public Map<String, String> getFiles() {
        HashMap<String, String> resultFileMap = new HashMap<String, String>();
        for (FileSet fileSet : this.fileSets) {
            for (File file : fileSet.getFiles()) {
                resultFileMap.put(file.getAbsolutePath(), "");
            }
        }
        return Collections.unmodifiableMap(resultFileMap);
    }

    public static final class Builder {
        private final BundleManifest bundle;
        private final String title;
        private final String description;
        private ImmutableList.Builder<FileSet> fileSetsBuilder = ImmutableList.builder();

        private Builder(BundleManifest bundle, String title, String description) {
            this.bundle = bundle;
            this.title = title;
            this.description = description;
        }

        @Nonnull
        public Builder fileSet(@Nonnull FileSet fileSet) {
            this.fileSetsBuilder.add((Object)fileSet);
            return this;
        }

        @Nonnull
        public Builder fileSets(@Nonnull List<FileSet> fileSets) {
            this.fileSetsBuilder.addAll(fileSets);
            return this;
        }

        @Nonnull
        public FileSetsBundle build() {
            return new FileSetsBundle(this);
        }
    }
}

