/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle;

import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.ApplicationInfoBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.BundlePriority;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationPropertiesInfoBundle
implements ApplicationInfoBundle {
    private String title;
    private String description;
    private boolean selected = true;
    private SupportApplicationInfo info;
    private final BundleManifest bundle;
    private static final Logger log = LoggerFactory.getLogger(ApplicationPropertiesInfoBundle.class);

    public ApplicationPropertiesInfoBundle(BundleManifest bundle, String title, String description, SupportApplicationInfo info) {
        this.bundle = bundle;
        this.title = title;
        this.description = description;
        this.info = info;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFiles() {
        HashMap<String, String> files = new HashMap<String, String>();
        File supportDir = new File(this.info.getApplicationHome(), "logs/support");
        if (!supportDir.exists() && !supportDir.mkdirs()) {
            log.error("Couldn't create export directory {}", (Object)supportDir.getAbsolutePath());
            return null;
        }
        File propertiesFile = new File(supportDir, "application.xml");
        try {
            FileWriter out = new FileWriter(propertiesFile);
            try {
                String propertiesString = this.info.saveProperties(SupportInfoDetail.FULL);
                out.write(propertiesString);
            }
            catch (IOException e) {
                log.error("Failed to write application properties to {}.", (Object)propertiesFile.getPath(), (Object)e);
            }
            finally {
                out.flush();
                out.close();
            }
            files.put(propertiesFile.getAbsolutePath(), "");
        }
        catch (Exception e) {
            log.error("Can't generate properties file.", (Throwable)e);
        }
        return files;
    }

    @Override
    public String getKey() {
        return this.bundle.getKey();
    }

    @Override
    public void setSelected(boolean b) {
        this.selected = b;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public String getBundlePriorityKey() {
        return this.bundle.getPriority().getPriorityKey();
    }

    @Override
    public boolean isRequired() {
        return this.bundle.getPriority().equals((Object)BundlePriority.REQUIRED);
    }

    @Override
    public void validate(ValidationLog validationLog) {
    }
}

