/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.extras.api.ProductLicense;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.sisyphus.SisyphusPatternSourceDecorator;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.request.FileSanitizer;
import com.atlassian.support.tools.salext.AbstractSupportApplicationInfo;
import com.atlassian.support.tools.salext.ApplicationType;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.FileSetsBundle;
import com.atlassian.support.tools.salext.bundle.fileset.ExactFileSet;
import com.atlassian.support.tools.salext.bundle.fileset.RegexFileSet;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.ProductLicenseInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class StashApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final String ZIP_INCLUDE_STASH_LOGS_DESCRIPTION = "stp.zip.include.stash.logs.description";
    private static final String ZIP_INCLUDE_STASH_LOGS = "stp.zip.include.stash.logs";
    private static final String ZIP_INCLUDE_STASH_CFG_DESCRIPTION = "stp.zip.include.stash.cfg.description";
    private static final String ZIP_INCLUDE_STASH_CFG = "stp.zip.include.stash.cfg";
    public static final Pattern LOG_FILE_REGEX;
    private final LicenseHandler licenseHandler;
    private final LicenseService licenseService;
    private final ApplicationPropertiesService propertiesService;
    private volatile String sharedHome;

    public StashApplicationInfo(ApplicationProperties applicationProperties, ApplicationPropertiesService applicationPropertiesService, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, LicenseHandler licenseHandler, LicenseService licenseService, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, PluginAccessor pluginAccessor, MailUtility mailUtility) {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver, pluginAccessor, mailUtility);
        this.licenseHandler = licenseHandler;
        this.licenseService = licenseService;
        this.propertiesService = applicationPropertiesService;
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        String logFilePath = this.applicationProperties.getHomeDirectory() + "/log/atlassian-stash.log";
        if (new File(logFilePath).exists()) {
            return Collections.singletonList(ScanItem.createDefaultItem(logFilePath));
        }
        return Collections.emptyList();
    }

    public String getApplicationSharedHome() {
        if (this.sharedHome == null) {
            try {
                Method method = this.propertiesService.getClass().getMethod("getSharedHome", new Class[0]);
                File sharedHomeFile = (File)method.invoke((Object)this.propertiesService, new Object[0]);
                this.sharedHome = sharedHomeFile.getAbsolutePath();
            }
            catch (Exception e) {
                File repositoriesDir = this.propertiesService.getRepositoriesDir();
                this.sharedHome = repositoriesDir != null && repositoriesDir.getParentFile() != null && repositoriesDir.getParentFile().getParentFile() != null ? repositoriesDir.getParentFile().getParentFile().getAbsolutePath() : this.getApplicationHome();
            }
        }
        return this.sharedHome;
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException {
        SisyphusPatternSourceDecorator source = new SisyphusPatternSourceDecorator();
        String url = System.getProperty("hercules.regex.url", "https://confluence.atlassian.com/download/attachments/179443532/stash_regex_v2.xml");
        source.add(this.getPatternSourceByURL(url, this.getProxy()));
        return source;
    }

    @Override
    public String getApplicationSEN() {
        return this.licenseHandler.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        return this.licenseHandler.getServerId();
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "stash-autosupportrequests@atlassian.com";
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return false;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/admin/mail-server";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(FILE_PATTERNS, EXECUTABLE_EXTENSIONS);
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        super.initServletInfo(config);
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_STASH_CFG, ZIP_INCLUDE_STASH_CFG_DESCRIPTION).fileSet(ExactFileSet.ofPaths(this.getApplicationSharedHome() + "/stash-config.properties")).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_CONFIG, "stp.zip.include.tomcat.conf", "stp.zip.include.tomcat.conf.description").fileSet(RegexFileSet.fromDirectoryPath(this.findTomcatFileOrDirectory("conf"), Pattern.compile("^.*\\.(xml|properties|policy)$"))).fileSet(RegexFileSet.fromDirectoryPath(this.getApplicationSharedHome(), Pattern.compile("server\\.xml"))).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_STASH_LOGS, ZIP_INCLUDE_STASH_LOGS_DESCRIPTION).fileSet(RegexFileSet.fromDirectoryPath(this.getApplicationHome() + "/log", LOG_FILE_REGEX)).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_LOGS, "stp.zip.include.tomcat.logs", "stp.zip.include.tomcat.logs.description").fileSet(RegexFileSet.fromDirectoryPath(this.findTomcatFileOrDirectory("logs"), Pattern.compile(".*gc.*\\.log.*|^.*\\.(log|out)$"))).build());
    }

    @Override
    public String getApplicationLogDir() {
        return this.getApplicationHome() + "/log";
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        return new ProductLicenseInfo((ProductLicense)this.licenseService.get());
    }

    @Override
    public String getAdminLicenseUrl() {
        return "/admin/license?edit";
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.STASH;
    }

    @Override
    public Pattern getApplicationRestartPattern() {
        return Pattern.compile("(Starting\\sStash)");
    }

    static {
        FILE_PATTERNS.put("stash-config.properties", Arrays.asList(Pattern.compile("^[#\\s]*jdbc\\.password\\s*.(.*)", 2)));
        LOG_FILE_REGEX = Pattern.compile("(^(?!.*audit).*\\.log.*)");
    }
}

