/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.UnloadableJiraServiceContainer;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.util.system.check.SystemEnvironmentChecklist;
import com.atlassian.jira.util.system.patch.AppliedPatchInfo;
import com.atlassian.jira.util.system.patch.AppliedPatches;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.sisyphus.SisyphusPatternSourceDecorator;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.PropertyStore;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.request.FileSanitizer;
import com.atlassian.support.tools.salext.AbstractSupportApplicationInfo;
import com.atlassian.support.tools.salext.ApplicationType;
import com.atlassian.support.tools.salext.bundle.AuthenticationConfigurationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.FileSetsBundle;
import com.atlassian.support.tools.salext.bundle.HealthcheckResultsBundle;
import com.atlassian.support.tools.salext.bundle.fileset.ExactFileSet;
import com.atlassian.support.tools.salext.bundle.fileset.RegexFileSet;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.JiraLicenseHelper;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.BundleContext;

public class JiraApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final String JIRA_ATTACHMENT_LOCATION = "stp.properties.jira.attachment.location";
    private static final String JIRA_BACKUP_LOCATION = "stp.properties.jira.backup.location";
    private static final String JIRA_ENTITYENGINE_LOCATION = "stp.properties.jira.entityengine.location";
    private static final String JIRA_HOME = "stp.properties.jira.home.location";
    private static final String JIRA_LOCAL_HOME = "stp.properties.jira.local.home.location";
    private static final String JIRA_INDEX_LOCATION = "stp.properties.jira.index.location";
    private static final String JIRA_LOG_LOCATION = "stp.properties.jira.log.location";
    private static final int JIRA_CLUSTER_BUILD_NUMBER = 6144;
    private static final int JIRA_RENAISSANCE_BUILD_NUMBER = 70105;
    private final ExtendedSystemInfoUtils utils;
    private final LocaleManager localeManager;
    private final JiraLicenseService licenseService;
    private final DateTimeFormatterFactory factory;
    private final String jiraLocalHomePath;
    private final OutlookDateManager outlookDateManager;
    private final CrowdDirectoryService dirService;
    private final JiraLicenseHelper jiraLicenseHelper;
    private final BundleContext bundleContext;

    public JiraApplicationInfo(JiraLicenseService licenseService, ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, LocaleManager localeManager, DateTimeFormatterFactory factory, OutlookDateManager outlookDateManager, CrowdDirectoryService dirService, PluginAccessor pluginAccessor, UserUtil userUtil, I18nHelper i18nHelper, JiraHome jiraHome, BundleContext bundleContext, MailUtility mailUtility) {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver, pluginAccessor, mailUtility);
        this.licenseService = licenseService;
        this.localeManager = localeManager;
        this.factory = factory;
        this.outlookDateManager = outlookDateManager;
        this.utils = new ExtendedSystemInfoUtilsImpl((I18nHelper)new I18nBean(Locale.ENGLISH));
        this.dirService = dirService;
        this.jiraLocalHomePath = this.getJiraHomePath(jiraHome);
        this.jiraLicenseHelper = new JiraLicenseHelper(applicationProperties, i18nHelper, userUtil);
        this.bundleContext = bundleContext;
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException {
        SisyphusPatternSourceDecorator source = new SisyphusPatternSourceDecorator();
        Proxy proxy = this.getProxy();
        String jiraUrl = System.getProperty("hercules.regex.url", "https://confluence.atlassian.com/download/attachments/179443532/jira_regex_v2.xml");
        String jiraSwUrl = System.getProperty("hercules.regex.url", "https://confluence.atlassian.com/download/attachments/179443532/greenhopper_regex_v2.xml");
        String jiraSdUrl = System.getProperty("hercules.regex.url", "https://confluence.atlassian.com/download/attachments/179443532/servicedesk_regex_v2.xml");
        source.add(this.getPatternSourceByURL(jiraUrl, proxy));
        source.add(this.getPatternSourceByURL(jiraSwUrl, proxy));
        source.add(this.getPatternSourceByURL(jiraSdUrl, proxy));
        return source;
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        super.initServletInfo(config);
        String webInfClassesDir = this.getServletContextPath("WEB-INF/classes");
        String binDir = this.findTomcatFileOrDirectory("bin");
        String clusterPropertiesPath = this.jiraLocalHomePath + "/cluster.properties";
        File clusterProperties = new File(clusterPropertiesPath);
        if (clusterProperties.exists()) {
            this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, "stp.zip.include.jira.cfg", "stp.zip.include.jira.cfg.description").fileSet(ExactFileSet.ofPaths(webInfClassesDir + "/entityengine.xml", webInfClassesDir + "/log4j.properties", this.jiraLocalHomePath + "/dbconfig.xml", clusterPropertiesPath, binDir + "/setenv.sh", binDir + "/setenv.bat", binDir + "/setclasspath.sh", binDir + "/setclasspath.bat", binDir + "/start-jira.sh", binDir + "/start-jira.bat", binDir + "/stop-jira.sh", binDir + "/stop-jira.bat", binDir + "/startup.sh", binDir + "/startup.bat", binDir + "/shutdown.sh", binDir + "/shutdown.bat")).build());
        } else {
            this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, "stp.zip.include.jira.cfg", "stp.zip.include.jira.cfg.description").fileSet(ExactFileSet.ofPaths(webInfClassesDir + "/entityengine.xml", webInfClassesDir + "/log4j.properties", this.jiraLocalHomePath + "/dbconfig.xml")).build());
        }
        String conf = this.findTomcatFileOrDirectory("conf");
        if (StringUtils.isNotBlank((String)conf)) {
            this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_CONFIG, "stp.zip.include.tomcat.conf", "stp.zip.include.tomcat.conf.description").fileSet(RegexFileSet.fromDirectoryPath(conf, Pattern.compile("^.*.(xml|properties|policy)$"))).build());
        }
        this.applicationInfoBundles.add(new HealthcheckResultsBundle(BundleManifest.HEALTHCHECKS, "stp.zip.include.healthchecks", "stp.zip.include.healthchecks.description", this, this.bundleContext));
        this.applicationInfoBundles.add(new AuthenticationConfigurationFileBundle(BundleManifest.AUTH_CONFIG, "stp.zip.include.auth.cfg", "stp.zip.include.auth.cfg.description", this, this.dirService, webInfClassesDir + "/crowd.properties"));
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.CACHE_CONFIG, "stp.zip.include.cache.cfg", "stp.zip.include.cache.cfg.description").fileSet(ExactFileSet.ofPaths(webInfClassesDir + "/cache.properties", webInfClassesDir + "/oscache.properties")).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_LOGS, "stp.zip.include.jira.logs", "stp.zip.include.jira.logs.description").fileSet(RegexFileSet.fromDirectoryPath(this.jiraLocalHomePath + "/log", Pattern.compile("^.*\\.log.*"))).build());
        String logs = this.findTomcatFileOrDirectory("logs");
        if (StringUtils.isNotBlank((String)logs)) {
            this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_LOGS, "stp.zip.include.tomcat.logs", "stp.zip.include.tomcat.logs.description").fileSet(RegexFileSet.fromDirectoryPath(logs, Pattern.compile(".*gc.*\\.log.*|^.*\\.(log|out)$"))).build());
        }
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        String logFilePath = this.utils.getLogPath();
        if (new File(logFilePath).exists()) {
            return Collections.singletonList(ScanItem.createDefaultItem(logFilePath));
        }
        return Collections.emptyList();
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "jira-support@atlassian.com";
    }

    @Override
    public String getApplicationSEN() {
        LicenseDetails jiraLicenseDetails = this.jiraLicenseHelper.getLicenseDetails(this.licenseService);
        return jiraLicenseDetails.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        return this.licenseService.getServerId();
    }

    @Override
    protected PropertyStore internalLoadProperties(SupportInfoDetail detail) {
        PropertyStore store = super.internalLoadProperties(detail);
        this.addSystemInfo(store);
        this.addMemoryStatistics(store);
        this.addApplicationInfo(store);
        this.addLanguageInfo(store);
        this.addLicenseInfo(store);
        this.addConfigInfo(store);
        this.addDbStatistics(store);
        this.addPathInfo(store);
        this.addListenerInfo(store);
        this.addServiceInfo(store);
        this.addPluginInfo(store);
        this.addApplicationProperties(store);
        this.addPatchInfo(store);
        return store;
    }

    private void addApplicationInfo(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore appInfoStore = store.addCategory("stp.properties.application.info");
                appInfoStore.putValues(JiraApplicationInfo.this.cloneNullSafe(JiraApplicationInfo.this.utils.getBuildStats()));
                List upgradeHistory = JiraApplicationInfo.this.utils.getUpgradeHistory();
                for (Object upgrade : upgradeHistory) {
                    PropertyStore upgradeStore = appInfoStore.addCategory("stp.properties.upgrade");
                    upgradeStore.setValue("stp.properties.upgrade.time", JiraApplicationInfo.this.factory.formatter().format(JiraApplicationInfo.this.getTimePerformed(upgrade)));
                    upgradeStore.setValue("stp.properties.upgrade.version", JiraApplicationInfo.this.getTargetVersion(upgrade));
                    upgradeStore.setValue("stp.properties.upgrade.build", JiraApplicationInfo.this.getTargetBuildNumber(upgrade));
                }
                return null;
            }
        });
    }

    private Date getTimePerformed(Object upgrade) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = upgrade.getClass();
        Method getTimePerformed = clazz.getDeclaredMethod("getTimePerformed", new Class[0]);
        return (Date)getTimePerformed.invoke(upgrade, new Object[0]);
    }

    private String getTargetVersion(Object upgrade) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = upgrade.getClass();
        Method getTargetVersion = clazz.getDeclaredMethod("getTargetVersion", new Class[0]);
        return (String)getTargetVersion.invoke(upgrade, new Object[0]);
    }

    private String getTargetBuildNumber(Object upgrade) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = upgrade.getClass();
        Method getTargetBuildNumber = clazz.getDeclaredMethod("getTargetBuildNumber", new Class[0]);
        return (String)getTargetBuildNumber.invoke(upgrade, new Object[0]);
    }

    private void addApplicationProperties(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore applicationProperties = store.addCategory("stp.properties.application.properties");
                applicationProperties.putValues(JiraApplicationInfo.this.utils.getApplicationPropertiesFormatted(", "));
                return null;
            }
        });
    }

    private void addConfigInfo(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore configStore = store.addCategory("stp.properties.config.info");
                configStore.putValues(JiraApplicationInfo.this.utils.getCommonConfigProperties());
                return null;
            }
        });
    }

    private void addDbStatistics(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore dbStatsStore = store.addCategory("stp.properties.db.statistics");
                dbStatsStore.putValues(JiraApplicationInfo.this.utils.getUsageStats());
                return null;
            }
        });
    }

    private void addLanguageInfo(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore languageProperties = store.addCategory("stp.properties.languages.installed");
                for (Locale language : JiraApplicationInfo.this.localeManager.getInstalledLocales()) {
                    PropertyStore languageStore = languageProperties.addCategory("stp.properties.languages.language");
                    languageStore.setValue("stp.properties.languages.language.abbreviation", language.getLanguage());
                    languageStore.setValue("stp.properties.languages.language.name", language.getDisplayLanguage());
                    languageStore.setValue("stp.properties.languages.language.country", language.getDisplayCountry());
                    if (!language.getDisplayName().equals(JiraApplicationInfo.this.utils.getDefaultLanguage())) continue;
                    languageStore.setValue("stp.properties.languages.default", "true");
                }
                return null;
            }
        });
    }

    private void addMemoryStatistics(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore jvmStatsStore = store.addCategory("stp.properties.memory.statistics");
                jvmStatsStore.putValues(JiraApplicationInfo.this.cloneNullSafe(JiraApplicationInfo.this.utils.getJvmStats()));
                return null;
            }
        });
    }

    private void addLicenseInfo(final PropertyStore store) {
        final LicenseDetails jiraLicenseDetails = this.jiraLicenseHelper.getLicenseDetails(this.licenseService);
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore licenseProperties = store.addCategory("stp.properties.license.info");
                licenseProperties.putValues(JiraApplicationInfo.this.jiraLicenseHelper.getLicenseInfo(jiraLicenseDetails));
                return null;
            }
        });
    }

    private void addListenerInfo(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore listenersStore = store.addCategory("stp.properties.listeners");
                for (Object listenerObject : JiraApplicationInfo.this.utils.getListeners().toArray()) {
                    Map listener = (Map)listenerObject;
                    if (listener.get("clazz") == null || listener.get("name") == null) continue;
                    PropertyStore listenerStore = listenersStore.addCategory("stp.properties.listeners.listener");
                    listenerStore.setValue("stp.properties.listeners.listener.name", listener.get("name").toString());
                    listenerStore.setValue("stp.properties.listeners.listener.clazz", listener.get("clazz").toString());
                }
                return null;
            }
        });
    }

    private void addPatchInfo(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore patchesStore = store.addCategory("stp.properties.patches");
                for (AppliedPatchInfo patch : AppliedPatches.getAppliedPatches()) {
                    PropertyStore patchStore = patchesStore.addCategory("stp.properties.patches.patch");
                    patchStore.setValue("stp.properties.patches.patch.key", patch.getIssueKey());
                    patchStore.setValue("stp.properties.patches.patch.description", patch.getDescription());
                }
                return null;
            }
        });
    }

    private void addPathInfo(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore filePathStore = store.addCategory("stp.properties.path.info");
                filePathStore.setValue(JiraApplicationInfo.JIRA_HOME, JiraApplicationInfo.this.utils.getJiraHomeLocation());
                if (!JiraApplicationInfo.this.utils.getJiraHomeLocation().equals(JiraApplicationInfo.this.jiraLocalHomePath)) {
                    filePathStore.setValue(JiraApplicationInfo.JIRA_LOCAL_HOME, JiraApplicationInfo.this.jiraLocalHomePath);
                }
                filePathStore.setValue(JiraApplicationInfo.JIRA_ENTITYENGINE_LOCATION, JiraApplicationInfo.this.utils.getEntityEngineXmlPath());
                filePathStore.setValue(JiraApplicationInfo.JIRA_LOG_LOCATION, JiraApplicationInfo.this.utils.getLogPath());
                filePathStore.setValue(JiraApplicationInfo.JIRA_INDEX_LOCATION, JiraApplicationInfo.this.utils.getIndexLocation());
                filePathStore.setValue(JiraApplicationInfo.JIRA_ATTACHMENT_LOCATION, JiraApplicationInfo.this.utils.getAttachmentsLocation());
                filePathStore.setValue(JiraApplicationInfo.JIRA_BACKUP_LOCATION, JiraApplicationInfo.this.utils.getBackupLocation());
                return null;
            }
        });
    }

    private void addPluginInfo(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Collection plugins = JiraApplicationInfo.this.utils.getPlugins();
                PluginMetadataManager pluginMetadataManager = (PluginMetadataManager)ComponentManager.getComponent(PluginMetadataManager.class);
                PropertyStore pluginProperties = store.addCategory("stp.properties.plugins.enabled");
                for (Plugin plugin : plugins) {
                    PluginInformation pluginInformation = plugin.getPluginInformation();
                    PropertyStore pluginStore = pluginProperties.addCategory("stp.properties.plugins.plugin");
                    pluginStore.setValue("stp.properties.plugins.plugin.key", plugin.getKey());
                    pluginStore.setValue("stp.properties.plugins.plugin.name", plugin.getName());
                    pluginStore.setValue("stp.properties.plugins.plugin.version", pluginInformation.getVersion());
                    pluginStore.setValue("stp.properties.plugins.plugin.vendor", pluginInformation.getVendorName());
                    pluginStore.setValue("stp.properties.plugins.plugin.status", plugin.getPluginState().toString());
                    pluginStore.setValue("stp.properties.plugins.plugin.vendor.url", pluginInformation.getVendorUrl());
                    pluginStore.setValue("stp.properties.plugins.plugin.framework.version", String.valueOf(plugin.getPluginsVersion()));
                    pluginStore.setValue("stp.properties.plugins.plugin.user.installed", pluginMetadataManager.isUserInstalled(plugin) ? "true" : "false");
                    pluginStore.setValue("stp.properties.plugins.plugin.bundled", plugin.isBundledPlugin() ? JiraApplicationInfo.this.getText("stp.properties.plugins.plugin.bundled") : JiraApplicationInfo.this.getText("stp.properties.plugins.plugin.user.installed"));
                }
                return null;
            }
        });
    }

    private void addServiceInfo(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DecimalFormat df = new DecimalFormat("#");
                PropertyStore servicesStore = store.addCategory("stp.properties.services");
                Collection services = JiraApplicationInfo.this.utils.getServices();
                for (JiraServiceContainer service : services) {
                    PropertyStore serviceStore = servicesStore.addCategory("stp.properties.services.service");
                    serviceStore.setValue("stp.properties.services.service.name", service.getName());
                    serviceStore.setValue("stp.properties.services.service.delay", df.format(service.getDelay() / 1000L) + "ms");
                    if (service instanceof UnloadableJiraServiceContainer) {
                        serviceStore.setValue("stp.properties.services.service.status", "unloaded");
                        continue;
                    }
                    serviceStore.setValue("stp.properties.services.service.last.run", JiraApplicationInfo.this.factory.formatter().format(new Date(service.getLastRun())));
                    if (service.getDescription() == null) continue;
                    serviceStore.setValue("stp.properties.services.service.description", service.getDescription());
                }
                return null;
            }
        });
    }

    private void addSystemInfo(final PropertyStore store) {
        this.callAndLogExceptions(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PropertyStore systemStore = store.addCategory("stp.properties.system.info");
                systemStore.putValues(JiraApplicationInfo.this.utils.getProps());
                return null;
            }
        });
    }

    private String getStringNotNull(Object o) {
        return o == null ? "" : o.toString();
    }

    private Map<String, String> cloneNullSafe(Map<?, ?> map) {
        HashMap<String, String> retMap = new HashMap<String, String>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = this.getStringNotNull(entry.getKey());
            String value = this.getStringNotNull(entry.getValue());
            retMap.put(key, value);
        }
        return retMap;
    }

    @Override
    public String getMailQueueURL(HttpServletRequest req) {
        return this.getBaseURL(req) + "/secure/admin/MailQueueAdmin!default.jspa";
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return true;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/secure/admin/OutgoingMailServers.jspa";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(FILE_PATTERNS, EXECUTABLE_EXTENSIONS);
    }

    @Override
    public List<String> getSystemWarnings() {
        return SystemEnvironmentChecklist.getWarningMessages((Locale)Locale.getDefault(), (boolean)false);
    }

    @Override
    public String getApplicationLogDir() {
        return this.getApplicationHome() + "/log";
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        final LicenseDetails jiraLicenseDetails = this.jiraLicenseHelper.getLicenseDetails(this.licenseService);
        return new ApplicationLicenseInfo(){

            @Override
            public boolean isStarter() {
                return jiraLicenseDetails.isStarter();
            }

            @Override
            public boolean isEvaluation() {
                return jiraLicenseDetails.isEvaluation();
            }

            @Override
            public boolean isEntitledToSupport() {
                return jiraLicenseDetails.isEntitledToSupport();
            }

            @Override
            public String getSEN() {
                return JiraApplicationInfo.this.getApplicationSEN();
            }

            @Override
            public Date getMaintenanceExpiryDate() {
                OutlookDate oDate = JiraApplicationInfo.this.outlookDateManager.getOutlookDate(Locale.getDefault());
                String dateStr = jiraLicenseDetails.getMaintenanceEndString(oDate);
                try {
                    return oDate.parseDatePicker(dateStr);
                }
                catch (ParseException e) {
                    return null;
                }
            }
        };
    }

    @Override
    public String getAdminLicenseUrl() {
        boolean isJiraRenaissance;
        boolean bl = isJiraRenaissance = Integer.parseInt(this.applicationProperties.getBuildNumber()) >= 70105;
        if (isJiraRenaissance) {
            return "/plugins/servlet/applications/versions-licenses";
        }
        return "/secure/admin/ViewLicense!default.jspa";
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.JIRA;
    }

    @Override
    public Pattern getApplicationRestartPattern() {
        return Pattern.compile("(JIRA\\sstarting...)");
    }

    private String getJiraHomePath(JiraHome jiraHome) {
        String defaultHomePath = this.applicationProperties.getHomeDirectory().toString();
        try {
            Class<?> jiraHomeClass = Class.forName("com.atlassian.jira.config.util.JiraHome");
            if (!jiraHomeClass.isAssignableFrom(jiraHome.getClass())) {
                return defaultHomePath;
            }
            if (this.hasClustering()) {
                Method getKeyMethod = jiraHomeClass.getMethod("getLocalHomePath", new Class[0]);
                return (String)getKeyMethod.invoke((Object)jiraHome, new Object[0]);
            }
            return defaultHomePath;
        }
        catch (ClassNotFoundException e) {
            return defaultHomePath;
        }
        catch (InvocationTargetException e) {
            return defaultHomePath;
        }
        catch (NoSuchMethodException e) {
            return defaultHomePath;
        }
        catch (IllegalAccessException e) {
            return defaultHomePath;
        }
    }

    private boolean hasClustering() {
        return Integer.parseInt(this.applicationProperties.getBuildNumber()) >= 6144;
    }

    static {
        FILE_PATTERNS.put("osuser.xml", Arrays.asList(Pattern.compile("(?:.*<property name=\"principal\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"credentials\">)(.*)(?:</property>.*)")));
        FILE_PATTERNS.put("dbconfig.xml", Arrays.asList(Pattern.compile("<username>([^<]+)</username>"), Pattern.compile("<password>([^<]+)</password>")));
        FILE_PATTERNS.put("application.xml", Arrays.asList(Pattern.compile("<dvcs\\.connector\\.(?:github|bitbucket)\\.clientId(?:\\.\\d+)?>([^<]+)<\\/dvcs\\.connector\\.(?:github|bitbucket)\\.clientId(?:\\.\\d+)?>"), Pattern.compile("<dvcs\\.connector\\.(?:github|bitbucket)\\.secret(?:\\.\\d+)?>([^<]+)<\\/dvcs\\.connector\\.(?:github|bitbucket)\\.secret(?:\\.\\d+)?>")));
    }
}

