/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.crucible.spi.data.RepositoryData;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.fisheye.spi.data.RepositoryDataFE;
import com.atlassian.fisheye.spi.services.RepositoryService;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.sisyphus.SisyphusPatternSourceDecorator;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.PropertyStore;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.request.FileSanitizer;
import com.atlassian.support.tools.salext.AbstractSupportApplicationInfo;
import com.atlassian.support.tools.salext.ApplicationType;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.FileSetsBundle;
import com.atlassian.support.tools.salext.bundle.fileset.ExactFileSet;
import com.atlassian.support.tools.salext.bundle.fileset.RegexFileSet;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.ProductLicenseInfo;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.cenqua.crucible.CrucibleVersionInfo;
import com.cenqua.crucible.hibernate.DBControlFactoryImpl;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.config1.CustomSecurityConfigType;
import com.cenqua.fisheye.config1.HostauthConfigType;
import com.cenqua.fisheye.config1.LdapConfigType;
import com.cenqua.fisheye.config1.ResourcesType;
import com.cenqua.fisheye.config1.SvnConfigType;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.support.ModzDetectorCache;
import com.cenqua.fisheye.util.PropertiesUtil;
import com.cenqua.fisheye.web.admin.actions.plugins.PluginDataFactory;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FisheyeApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final String FISHEYE_AJP_USER_MANAGEMENT = "stp.properties.fisheye.ajp.user.management";
    private static final String FISHEYE_BUILTIN_SIGNUP_ENABLED = "stp.properties.fisheye.builtin.signup.enabled";
    private static final String FISHEYE_BUILTIN_USER_MANAGEMENT = "stp.properties.fisheye.builtin.user.management";
    private static final String FISHEYE_CROWD_NAME = "stp.properties.fisheye.crowd.name";
    private static final String FISHEYE_CROWD_SSO_ENABLED = "stp.properties.fisheye.crowd.sso.enabled";
    private static final String FISHEYE_CROWD_URL = "stp.properties.fisheye.crowd.url";
    private static final String FISHEYE_CROWD_USER_MANAGEMENT = "stp.properties.fisheye.crowd.user.management";
    private static final String FISHEYE_CROWD_VERSION = "stp.properties.fisheye.crowd.version";
    private static final String FISHEYE_CUSTOM_USER_MANAGEMENT = "stp.properties.fisheye.custom.user.management";
    private static final String FISHEYE_HOST_USER_MANAGEMENT = "stp.properties.fisheye.host.user.management";
    private static final String FISHEYE_LDAP_USER_MANAGEMENT = "stp.properties.fisheye.ldap.user.management";
    private static final String HERCULES_SCANITEM_FECRU_APP_LOG = "stp.hercules.scanitem.fecru.appLog";
    private static final String HERCULES_SCANITEM_FISHEYE_LOG = "stp.hercules.scanitem.fisheye.log";
    private static final String ZIP_INCLUDE_FECRU_CFG_DESCRIPTION = "stp.zip.include.fecru.cfg.description";
    private static final String ZIP_INCLUDE_FECRU_LOGS = "stp.zip.include.fecru.logs";
    private static final String ZIP_INCLUDE_FECRU_LOGS_DESCRIPTION = "stp.zip.include.fecru.logs.description";
    private static final String ZIP_INCLUDE_FECRU_OUT = "stp.zip.include.fecru.out";
    private static final String ZIP_INCLUDE_FECRU_OUT_DESCRIPTION = "stp.zip.include.fecru.out.description";
    private static final String ZIP_INCLUDE_FECRU_PLUGIN_CFG = "stp.zip.include.fecru.plugin.cfg";
    private static final String ZIP_INCLUDE_FECRU_PLUGIN_CFG_DESCRIPTION = "stp.zip.include.fecru.plugin.cfg.description";
    private static final String ZIP_INCLUDE_FECRU_PLUGINSTATE_PROPERTIES = "stp.zip.include.fecru.pluginstate.properties";
    private static final String ZIP_INCLUDE_FECRU_PLUGINSTATE_PROPERTIES_DESCRIPTION = "stp.zip.include.fecru.pluginstate.properties.description";
    public static final String ZIP_INCLUDE_FECRU_CFG = "stp.zip.include.fecru.cfg";
    private static final Logger log = LoggerFactory.getLogger(AbstractMailUtility.class);
    private static final String API_ENABLED = "stp.properties.fisheye.api.enabled";
    private static final String AUTO_ADD_USERS = "stp.properties.fisheye.auth.users.auto.add";
    private static final String CACHE_TTL = "stp.properties.fisheye.cache.ttl";
    private static final String CRUCIBLE_VERSION = "stp.properties.crucible.version";
    private static final String CUSTOM_SECURITY_CLASS = "stp.properties.fisheye.auth.custom.classname";
    private static final String CUSTOM_SECURITY_PROPERTIES = "stp.properties.fisheye.auth.custom.properties";
    private static final String DEBUG_ENABLED = "stp.properties.fisheye.debug.enabled";
    private static final String FISHEYE_BUILD = "stp.properties.fisheye.build";
    private static final String FISHEYE_INSTANCE_DIRECTORY = "stp.properties.fisheye.instance.dir";
    private static final String FISHEYE_VERSION = "stp.properties.fisheye.version";
    private static final String HOST_AUTH_DOMAIN_SERVICE = "stp.properties.fisheye.auth.domain.service";
    private static final String HOST_AUTH_REQUIRED_GROUP = "stp.properties.fisheye.auth.required.group";
    private static final String HTTP_BIND = "stp.properties.fisheye.http.bind";
    private static final String HTTP_CONTEXT = "stp.properties.fisheye.http.context";
    private static final String INCREMENTAL_THREADS_MAX = "stp.properties.fisheye.threads.incremental.max";
    private static final String INCREMENTAL_THREADS_MIN = "stp.properties.fisheye.threads.incremental.min";
    private static final String INITIAL_THREADS_MAX = "stp.properties.fisheye.threads.initial.max";
    private static final String INITIAL_THREADS_MIN = "stp.properties.fisheye.threads.initial.min";
    private static final String LDAP_BASE_DN = "stp.properties.fisheye.auth.ldap.base.dn";
    private static final String LDAP_BIND_USER = "stp.properties.fisheye.auth.ldap.initial.bind.user";
    private static final String LDAP_DISPLAY_NAME_ATTRIBUTE = "stp.properties.fisheye.auth.ldap.display.name.attribute";
    private static final String LDAP_EMAIL_ATTRIBUTE = "stp.properties.fisheye.auth.ldap.email.attribute";
    private static final String LDAP_SYNC_PERIOD = "stp.properties.fisheye.auth.ldap.sync.period";
    private static final String LDAP_UID_ATTRIBUTE = "stp.properties.fisheye.auth.ldap.uid.attribute";
    private static final String LDAP_URL = "stp.properties.fisheye.auth.ldap.url";
    private static final String LDAP_USER_FILTER = "stp.properties.fisheye.auth.ldap.user.filter";
    private static final String LICENSE_DESCRIPTION_CRUCIBLE = "stp.properties.crucible.license.description";
    private static final String MAX_CRUCIBLE_USERS = "stp.properties.crucible.max.users";
    private static final String MAX_FE_USERS = "stp.properties.fisheye.fisheye.max.users";
    private static final String NONPATH_LIBRARIES_DIRECTORY_LISTING = "stp.properties.fisheye.nonpath.libraries";
    private static final String NONPATH_LIBRARIES_DIRECTORY = "stp.properties.fisheye.nonpath.libraries.directory";
    private static final String NONPATH_LIBRARIES_PATH = "stp.properties.fisheye.nonpath.libraries.path";
    private static final String NONPATH_LIBRARIES_FILES = "stp.properties.fisheye.nonpath.libraries.files";
    private static final String P4_CLIENT = "stp.properties.fisheye.p4.client";
    private static final String SITE_CONTEXT = "stp.properties.fisheye.site.context";
    private static final String SITE_PROXY_HOST = "stp.properties.fisheye.site.proxy.host";
    private static final String SITE_PROXY_PORT = "stp.properties.fisheye.site.proxy.port";
    private static final String SITE_PROXY_SCHEME = "stp.properties.fisheye.site.proxy.scheme";
    private static final String SITE_URL = "stp.properties.fisheye.site.url";
    private static final String SVN_CLIENT_JAR = "stp.properties.fisheye.svn.client.jar";
    private static final String SVN_CLIENT_LIB = "stp.properties.fisheye.svn.client.libs";
    private static final String USER_MGMT_TYPE = "stp.properties.user.management.type";
    public static final Map<String, List<Pattern>> FISHEYE_FILE_PATTERNS;
    private ConfigDocument.Config cfg;
    private PluginDataFactory pluginDataFactory;
    private ModzDetectorCache modz = new ModzDetectorCache();
    private DatabaseConfig dbConfig = null;
    private DBControlFactoryImpl factory;
    private com.atlassian.crucible.spi.services.RepositoryService crucibleRepositoryService;
    private RepositoryService feRepositoryService;

    public FisheyeApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, PluginAccessor pluginAccessor, com.atlassian.crucible.spi.services.RepositoryService crucibleRepositoryService, RepositoryService feRepositoryService, MailUtility mailUtility) {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver, pluginAccessor, mailUtility);
        this.pluginDataFactory = new PluginDataFactory(pluginAccessor);
        this.factory = new DBControlFactoryImpl();
        this.cfg = AppConfig.getsConfig().getConfig();
        this.dbConfig = new DatabaseConfig(this.factory.getCurrentControl().getInfo().getConnectionInfo());
        this.crucibleRepositoryService = crucibleRepositoryService;
        this.feRepositoryService = feRepositoryService;
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        super.initServletInfo(config);
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_FECRU_CFG, ZIP_INCLUDE_FECRU_CFG_DESCRIPTION).fileSet(ExactFileSet.ofPaths(AppConfig.getInstanceDir().getAbsolutePath() + "/config.xml")).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.PLUGIN_CONFIG, ZIP_INCLUDE_FECRU_PLUGIN_CFG, ZIP_INCLUDE_FECRU_PLUGIN_CFG_DESCRIPTION).fileSet(RegexFileSet.fromDirectoryPath(AppConfig.getInstanceDir().getAbsolutePath() + "/var/plugins/config", Pattern.compile(".*\\.config"))).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.MODZ, "stp.zip.include.modz", "stp.zip.include.modz.description").fileSet(ExactFileSet.ofPaths(this.getModifiedFiles())).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_FECRU_LOGS, ZIP_INCLUDE_FECRU_LOGS_DESCRIPTION).fileSet(RegexFileSet.fromDirectoryPath(this.getApplicationLogDir(), Pattern.compile("^(atlassian-)?fisheye.*\\.log.*"))).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.FECRU_OUT, ZIP_INCLUDE_FECRU_OUT, ZIP_INCLUDE_FECRU_OUT_DESCRIPTION).fileSet(ExactFileSet.ofPaths(AppConfig.getInstanceDir().getAbsolutePath() + "/var/log/fisheye.out")).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.FECRU_PLUGIN_STATE, ZIP_INCLUDE_FECRU_PLUGINSTATE_PROPERTIES, ZIP_INCLUDE_FECRU_PLUGINSTATE_PROPERTIES_DESCRIPTION).fileSet(ExactFileSet.ofPaths(AppConfig.getInstanceDir().getAbsolutePath() + "/var/plugins/config/pluginstate.properties")).build());
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException, MalformedURLException {
        Proxy proxy = Proxy.NO_PROXY;
        if (this.cfg.getWebServer().getHttp().isSetProxyHost()) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(SITE_PROXY_HOST, this.cfg.getWebServer().getHttp().isSetProxyPort() ? Integer.parseInt(SITE_PROXY_PORT) : 80));
        }
        String fisheyeUrl = System.getProperty("hercules.regex.url", "https://confluence.atlassian.com/download/attachments/179443532/fisheye_regex_v2.xml");
        String crucibleUrl = System.getProperty("hercules.regex.url", "https://confluence.atlassian.com/download/attachments/179443532/crucible_regex_v2.xml");
        SisyphusPatternSourceDecorator source = new SisyphusPatternSourceDecorator();
        source.add(this.getPatternSourceByURL(fisheyeUrl, proxy));
        source.add(this.getPatternSourceByURL(crucibleUrl, proxy));
        return source;
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        String fisheyeLog;
        ArrayList<ScanItem> logFilePaths = new ArrayList<ScanItem>();
        String mostRecentAppLog = this.mostRecentFile(AppConfig.getLogDir().listFiles((FilenameFilter)new RegexFileFilter(".*fisheye.*\\.log.*")));
        if (!StringUtils.isBlank((String)mostRecentAppLog)) {
            logFilePaths.add(new ScanItem(HERCULES_SCANITEM_FECRU_APP_LOG, mostRecentAppLog));
        }
        if (new File(fisheyeLog = AppConfig.getInstanceDir() + "/var/log/fisheye.out").exists()) {
            logFilePaths.add(new ScanItem(HERCULES_SCANITEM_FISHEYE_LOG, fisheyeLog));
        }
        return logFilePaths;
    }

    private String mostRecentFile(File[] errorLogs) {
        String mostRecentFile = null;
        long lastModified = 0L;
        for (File file : errorLogs) {
            if (file.lastModified() <= lastModified) continue;
            try {
                mostRecentFile = file.getCanonicalPath();
                lastModified = file.lastModified();
            }
            catch (IOException e) {
                log.error("Error retrieving canonical path for file {}", (Object)file.getPath(), (Object)e);
            }
        }
        return mostRecentFile;
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "fisheye-autosupportrequests@atlassian.com";
    }

    @Override
    public String getApplicationSEN() {
        LicenseInfo productLicense = AppConfig.getsConfig().getLicense();
        if (productLicense.isFishEye()) {
            return productLicense.getFisheyeLicense().getSupportEntitlementNumber();
        }
        return productLicense.getCrucibleLicense().getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        LicenseInfo productLicense = AppConfig.getsConfig().getLicense();
        if (productLicense.isFishEye()) {
            return productLicense.getFisheyeLicense().getServerId();
        }
        return productLicense.getCrucibleLicense().getServerId();
    }

    @Override
    protected PropertyStore internalLoadProperties(SupportInfoDetail detail) {
        PropertyStore store = super.internalLoadProperties(detail);
        this.addApplicationProperties(store);
        this.addUserManagementProperties(store);
        this.addLicenseInformation(store);
        this.addPluginProperties(store);
        this.addDatabaseSettings(store);
        this.addModifiedFilesData(store);
        this.addResourceLimitsProperties(store);
        this.addSourceControlProperties(store);
        this.addRepositoryData(store);
        this.addNonPathLibraryDirectoriesListing(store);
        return store;
    }

    private void addApplicationProperties(PropertyStore store) {
        PropertyStore appProps = store.addCategory("stp.properties.application.properties");
        appProps.setValue("stp.properties.application.home", AppConfig.getAppHome().getAbsolutePath());
        appProps.setValue(FISHEYE_INSTANCE_DIRECTORY, AppConfig.getInstanceDir().getAbsolutePath());
        FisheyeVersionInfo fisheyeVersionInfo = new FisheyeVersionInfo();
        appProps.setValue(FISHEYE_VERSION, fisheyeVersionInfo.getReleaseNum());
        appProps.setValue(FISHEYE_BUILD, fisheyeVersionInfo.getBuildNumber());
        appProps.setValue(CRUCIBLE_VERSION, new CrucibleVersionInfo().getReleaseNum());
        appProps.setValue(DEBUG_ENABLED, String.valueOf(Logs.APP_LOG.isDebugEnabled()));
        appProps.setValue(API_ENABLED, String.valueOf(AppConfig.getsConfig().isApiEnabled()));
        if (this.cfg.getWebServer() != null) {
            if (this.cfg.getWebServer().isSetSiteUrl()) {
                appProps.setValue(SITE_URL, this.cfg.getWebServer().getSiteUrl());
            }
            if (this.cfg.getWebServer().isSetContext()) {
                appProps.setValue(SITE_CONTEXT, this.cfg.getWebServer().getContext());
            }
            if (this.cfg.getWebServer().isSetHttp()) {
                if (this.cfg.getWebServer().getHttp().isSetContext()) {
                    appProps.setValue(HTTP_CONTEXT, this.cfg.getWebServer().getHttp().getContext());
                }
                appProps.setValue(HTTP_BIND, this.cfg.getWebServer().getHttp().getBind());
                if (this.cfg.getWebServer().getHttp().isSetProxyHost()) {
                    appProps.setValue(SITE_PROXY_HOST, String.valueOf(this.cfg.getWebServer().getHttp().getProxyHost()));
                }
                if (this.cfg.getWebServer().getHttp().isSetProxyPort()) {
                    appProps.setValue(SITE_PROXY_PORT, String.valueOf(this.cfg.getWebServer().getHttp().getProxyPort()));
                }
                if (this.cfg.getWebServer().getHttp().isSetProxyScheme()) {
                    appProps.setValue(SITE_PROXY_SCHEME, this.cfg.getWebServer().getHttp().getProxyScheme());
                }
            }
        }
    }

    private void addUserManagementProperties(PropertyStore store) {
        PropertyStore userMgmtProps = store.addCategory("stp.properties.user.management");
        if (this.cfg.getSecurity().isSetCrowd()) {
            CrowdAuthConfigType crowdCfg = this.cfg.getSecurity().getCrowd();
            userMgmtProps.setValue(USER_MGMT_TYPE, FISHEYE_CROWD_USER_MANAGEMENT);
            String crowdPropertiesStr = crowdCfg.getCrowdProperties();
            if (!Strings.isNullOrEmpty((String)crowdPropertiesStr)) {
                Properties crowdProperties = PropertiesUtil.loadFromString((String)crowdPropertiesStr);
                userMgmtProps.setValue(FISHEYE_CROWD_NAME, crowdProperties.getProperty("application.name"));
                userMgmtProps.setValue(FISHEYE_CROWD_URL, crowdProperties.getProperty("crowd.server.url"));
            }
            userMgmtProps.setValue(FISHEYE_CROWD_VERSION, "2.7.1");
            userMgmtProps.setValue(AUTO_ADD_USERS, String.valueOf(crowdCfg.getAutoAdd()));
            userMgmtProps.setValue(FISHEYE_CROWD_SSO_ENABLED, String.valueOf(crowdCfg.getSsoEnabled()));
            if (crowdCfg.isSetResync()) {
                userMgmtProps.setValue(LDAP_SYNC_PERIOD, crowdCfg.getResyncPeriod());
            } else {
                userMgmtProps.setValue(LDAP_SYNC_PERIOD, String.valueOf(crowdCfg.getResync()));
            }
        }
        if (this.cfg.getSecurity().isSetBuiltIn()) {
            userMgmtProps.setValue(USER_MGMT_TYPE, this.getText(FISHEYE_BUILTIN_USER_MANAGEMENT));
            userMgmtProps.setValue(FISHEYE_BUILTIN_SIGNUP_ENABLED, String.valueOf(this.cfg.getSecurity().getBuiltIn().getSignup().getEnabled()));
        }
        if (this.cfg.getSecurity().isSetLdap()) {
            LdapConfigType ldapCfg = this.cfg.getSecurity().getLdap();
            userMgmtProps.setValue(USER_MGMT_TYPE, FISHEYE_LDAP_USER_MANAGEMENT);
            userMgmtProps.setValue(LDAP_URL, ldapCfg.getUrl());
            userMgmtProps.setValue(LDAP_BASE_DN, ldapCfg.getBaseDn());
            userMgmtProps.setValue(LDAP_USER_FILTER, ldapCfg.getFilter());
            userMgmtProps.setValue(LDAP_UID_ATTRIBUTE, ldapCfg.getUidAttr());
            userMgmtProps.setValue(LDAP_EMAIL_ATTRIBUTE, ldapCfg.getEmailAttr());
            userMgmtProps.setValue(LDAP_DISPLAY_NAME_ATTRIBUTE, ldapCfg.isSetDisplaynameAttr() ? ldapCfg.getDisplaynameAttr() : "stp.properties.not.set");
            userMgmtProps.setValue(CACHE_TTL, ldapCfg.getPositiveCacheTtl());
            userMgmtProps.setValue(AUTO_ADD_USERS, String.valueOf(ldapCfg.getAutoAdd()));
            userMgmtProps.setValue(LDAP_BIND_USER, ldapCfg.isSetInitialDn() ? ldapCfg.getInitialDn() : "stp.properties.not.set");
            userMgmtProps.setValue(LDAP_SYNC_PERIOD, ldapCfg.getResyncPeriod());
        }
        if (this.cfg.getSecurity().isSetCustom() && this.cfg.getSecurity().getCustom() != null) {
            CustomSecurityConfigType customCfg = this.cfg.getSecurity().getCustom();
            userMgmtProps.setValue(USER_MGMT_TYPE, FISHEYE_CUSTOM_USER_MANAGEMENT);
            userMgmtProps.setValue(CUSTOM_SECURITY_CLASS, customCfg.getClassname());
            userMgmtProps.setValue(AUTO_ADD_USERS, String.valueOf(customCfg.getAutoAdd()));
            userMgmtProps.setValue(CACHE_TTL, customCfg.getPositiveCacheTtl());
            userMgmtProps.setValue(CUSTOM_SECURITY_PROPERTIES, customCfg.getProperties());
        }
        if (this.cfg.getSecurity().isSetAjp() && this.cfg.getSecurity().getCustom() != null) {
            userMgmtProps.setValue(USER_MGMT_TYPE, FISHEYE_AJP_USER_MANAGEMENT);
            CustomSecurityConfigType ajpCfg = this.cfg.getSecurity().getCustom();
            userMgmtProps.setValue(AUTO_ADD_USERS, String.valueOf(ajpCfg.getAutoAdd()));
            userMgmtProps.setValue(CACHE_TTL, ajpCfg.getPositiveCacheTtl());
        }
        if (this.cfg.getSecurity().isSetHostAuth() && this.cfg.getSecurity().getHostAuth() != null) {
            HostauthConfigType hostCfg = this.cfg.getSecurity().getHostAuth();
            userMgmtProps.setValue(USER_MGMT_TYPE, FISHEYE_HOST_USER_MANAGEMENT);
            userMgmtProps.setValue(HOST_AUTH_REQUIRED_GROUP, hostCfg.getRequiredGroup());
            userMgmtProps.setValue(HOST_AUTH_DOMAIN_SERVICE, hostCfg.getDomain());
            userMgmtProps.setValue(AUTO_ADD_USERS, String.valueOf(hostCfg.getAutoAdd()));
            userMgmtProps.setValue(CACHE_TTL, hostCfg.getPositiveCacheTtl());
        }
    }

    private void addLicenseInformation(PropertyStore store) {
        PropertyStore licenseProps = store.addCategory("stp.properties.license");
        LicenseInfo productLicense = AppConfig.getsConfig().getLicense();
        if (productLicense.isCrucibleOnly()) {
            licenseProps.setValue("stp.properties.license.sen", productLicense.getCrucibleLicense().getSupportEntitlementNumber());
            licenseProps.setValue("stp.properties.license.server.id", productLicense.getCrucibleLicense().getServerId());
        } else if (productLicense.isFishEye()) {
            licenseProps.setValue("stp.properties.license.sen", productLicense.getFisheyeLicense().getSupportEntitlementNumber());
            licenseProps.setValue("stp.properties.license.server.id", productLicense.getFisheyeLicense().getServerId());
            licenseProps.setValue("stp.properties.license.expires", productLicense.getSoftExpiryValue().toString());
            String upgradesMaintenence = "";
            upgradesMaintenence = productLicense.getLatestBuildAllowedValue() != null ? this.getText("stp.properties.license.expires") + " " + productLicense.getLatestBuildAllowedValue().toString() : this.getText("stp.properties.license.never.expires");
            licenseProps.setValue("stp.properties.license.period", upgradesMaintenence);
        }
        licenseProps.setValue("stp.properties.license.product", productLicense.getProductName());
        licenseProps.setValue("stp.properties.license.owner", productLicense.getOwner());
        licenseProps.setValue("stp.properties.license.description", productLicense.getDescription());
        if (productLicense.getCrucibleLicense() != null) {
            String maxCRUUsers = productLicense.getCrucibleLicense().isUnlimitedNumberOfUsers() ? "stp.properties.license.unlimited.users" : "" + productLicense.getCrucibleLicense().getMaximumNumberOfUsers();
            licenseProps.setValue(MAX_CRUCIBLE_USERS, maxCRUUsers);
            licenseProps.setValue(LICENSE_DESCRIPTION_CRUCIBLE, productLicense.getCrucibleLicense().getDescription());
        }
        licenseProps.setValue("stp.properties.license.organisation", productLicense.getOwnerStatement());
        if (productLicense.getFisheyeLicense() != null) {
            String maxFEUsers = productLicense.getFisheyeLicense().isUnlimitedNumberOfUsers() ? "stp.properties.license.unlimited.users" : "" + productLicense.getFisheyeLicense().getMaximumNumberOfUsers();
            licenseProps.setValue(MAX_FE_USERS, maxFEUsers);
        }
    }

    private void addPluginProperties(PropertyStore store) {
        Collection pluginData = this.pluginDataFactory.getPluginData(null, null);
        PropertyStore pluginProperties = store.addCategory("stp.properties.plugins.enabled");
        for (PluginDataFactory.PluginData plugin : pluginData) {
            PropertyStore pluginStore = pluginProperties.addCategory("stp.properties.plugins.plugin");
            pluginStore.setValue("stp.properties.plugins.plugin.key", plugin.getKey());
            pluginStore.setValue("stp.properties.plugins.plugin.name", plugin.getName());
            pluginStore.setValue("stp.properties.plugins.plugin.version", plugin.getVersion());
            pluginStore.setValue("stp.properties.plugins.plugin.vendor", plugin.getVendor());
            pluginStore.setValue("stp.properties.plugins.plugin.status", plugin.getState().toString());
        }
    }

    private void addDatabaseSettings(PropertyStore store) {
        PropertyStore dbProps = store.addCategory("stp.properties.db");
        dbProps.setValue("stp.properties.db.name", this.dbConfig.getType().getDisplayName());
        dbProps.setValue("stp.properties.db.driver.name", this.dbConfig.getType().getDriver());
        dbProps.setValue("stp.properties.db.connection.url", this.dbConfig.getJdbcURL());
        dbProps.setValue("stp.properties.db.version", this.factory.getCurrentControl().getInfo().currentVersion().toString());
    }

    private void addModifiedFilesData(PropertyStore store) {
        PropertyStore modProps = store.addCategory("stp.properties.modz");
        if (this.getModifiedFiles() != null && this.getModifiedFiles().size() > 0) {
            PropertyStore modifiedStore = modProps.addCategory("stp.properties.modz.modified");
            for (Object file : this.getModifiedFiles()) {
                modifiedStore.setValue("stp.properties.modz.file", file.toString());
            }
        }
        if (this.getRemovedFiles() != null && this.getRemovedFiles().size() > 0) {
            PropertyStore removedStore = modProps.addCategory("stp.properties.modz.removed");
            for (Object file : this.getRemovedFiles()) {
                removedStore.setValue("stp.properties.modz.file", file.toString());
            }
        }
    }

    private void addResourceLimitsProperties(PropertyStore store) {
        PropertyStore resourceProps = store.addCategory("stp.properties.resource.limits");
        if (this.cfg.isSetResources()) {
            ResourcesType resourceCfg = this.cfg.getResources();
            if (resourceCfg.isSetInitialIndexThreads()) {
                if (resourceCfg.getInitialIndexThreads().isSetMax()) {
                    resourceProps.setValue(INITIAL_THREADS_MAX, String.valueOf(resourceCfg.getInitialIndexThreads().getMax()));
                }
                if (resourceCfg.getInitialIndexThreads().isSetMin()) {
                    resourceProps.setValue(INITIAL_THREADS_MIN, String.valueOf(resourceCfg.getInitialIndexThreads().getMin()));
                }
            }
            if (resourceCfg.isSetIncrementalIndexThreads()) {
                if (resourceCfg.getIncrementalIndexThreads().isSetMax()) {
                    resourceProps.setValue(INCREMENTAL_THREADS_MAX, String.valueOf(resourceCfg.getIncrementalIndexThreads().getMax()));
                }
                if (resourceCfg.getIncrementalIndexThreads().isSetMin()) {
                    resourceProps.setValue(INCREMENTAL_THREADS_MIN, String.valueOf(resourceCfg.getIncrementalIndexThreads().getMin()));
                }
            }
        }
    }

    private void addSourceControlProperties(PropertyStore store) {
        PropertyStore sourceProps = store.addCategory("stp.properties.source.control");
        if (this.cfg.isSetSvnConfig()) {
            SvnConfigType svnCfg = this.cfg.getSvnConfig();
            if (svnCfg.isSetJar()) {
                sourceProps.setValue(SVN_CLIENT_JAR, svnCfg.getJar());
            }
            if (svnCfg.isSetJnilib()) {
                sourceProps.setValue(SVN_CLIENT_LIB, svnCfg.getJnilib());
            }
        }
        if (this.cfg.isSetP4Config()) {
            sourceProps.setValue(P4_CLIENT, this.cfg.getP4Config().getP4Location());
        }
    }

    private void addRepositoryData(PropertyStore store) {
        PropertyStore repositories = store.addCategory("stp.properties.repositories");
        for (RepositoryDataFE repo : this.feRepositoryService.listRepositories()) {
            PropertyStore repoProps = repositories.addCategory("stp.properties.repository");
            repoProps.setValue("stp.properties.repository.name", repo.getName());
            repoProps.setValue("stp.properties.repository.state", repo.getState().name());
            RepositoryData crucibleRepo = this.crucibleRepositoryService.getRepository(repo.getName());
            if (crucibleRepo == null) continue;
            repoProps.setValue("stp.properties.repository.type", crucibleRepo.getType());
        }
    }

    private void addNonPathLibraryDirectoriesListing(PropertyStore store) {
        ImmutableList pathsToWalk = ImmutableList.builder().add((Object)(AppConfig.getInstanceDir().getAbsolutePath() + "/lib")).addAll(Splitter.on((String)File.pathSeparator).split((CharSequence)System.getProperty("java.ext.dirs", ""))).build();
        PropertyStore libraries = store.addCategory(NONPATH_LIBRARIES_DIRECTORY_LISTING);
        for (String dir : pathsToWalk) {
            PropertyStore extDirs = libraries.addCategory(NONPATH_LIBRARIES_DIRECTORY);
            List<File> allFilesInExtDirs = this.getRecursiveFileList(new File(dir), new ArrayList<File>());
            extDirs.setValue(NONPATH_LIBRARIES_PATH, dir);
            extDirs.setValue(NONPATH_LIBRARIES_FILES, Joiner.on((String)File.pathSeparator).join(allFilesInExtDirs));
        }
    }

    private List<File> getRecursiveFileList(File root, List<File> collector) {
        if (root.exists()) {
            File[] files;
            for (File f : files = root.listFiles()) {
                if (collector.size() > 1000) break;
                collector.add(f);
                if (!f.isDirectory()) continue;
                this.getRecursiveFileList(f, collector);
            }
        }
        return collector;
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return true;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/admin/editSmtpConfig-default.do";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(FISHEYE_FILE_PATTERNS, EXECUTABLE_EXTENSIONS);
    }

    private List getModifiedFiles() {
        try {
            if (this.modz.getModifications().modifiedFiles.isEmpty()) {
                return Collections.emptyList();
            }
            return this.modz.getModifications().modifiedFiles;
        }
        catch (ModzRegistryException e) {
            Logs.APP_LOG.warn((Object)("Problems calculating modified files: " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    private List getRemovedFiles() {
        try {
            if (this.modz.getModifications().removedFiles.isEmpty()) {
                return Collections.emptyList();
            }
            return this.modz.getModifications().removedFiles;
        }
        catch (ModzRegistryException e) {
            Logs.APP_LOG.warn((Object)("Problems calculating removed files: " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    @Override
    public String getApplicationLogDir() {
        return AppConfig.getLogDir().getAbsolutePath();
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        ProductLicense license = AppConfig.getsConfig().getLicense().getFisheyeLicense();
        return new ProductLicenseInfo(license);
    }

    @Override
    public String getAdminLicenseUrl() {
        return "/admin/editLicense-default.do?";
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.FISHEYE;
    }

    @Override
    public Pattern getApplicationRestartPattern() {
        return Pattern.compile("(Starting\\sdatabase...)");
    }

    static {
        HashMap<String, List<Pattern>> map = new HashMap<String, List<Pattern>>();
        map.putAll(FILE_PATTERNS);
        map.put("config.xml", Collections.unmodifiableList(Arrays.asList(Pattern.compile("password%3D(.+?)%0A"), Pattern.compile("password=[\"]([^\"]+?)\""), Pattern.compile("initial-secret=\"(.+?)\""), Pattern.compile("application.password=(.+?)$"), Pattern.compile("<publicKey>(.*?)</publicKey>"), Pattern.compile("<privateKey>(.*?)</privateKey>"), Pattern.compile("<restApiKey api-key=[\"](.*?)[\"]/>"), Pattern.compile("admin-hash=\"([^\"]+)\""))));
        FISHEYE_FILE_PATTERNS = Collections.unmodifiableMap(map);
    }
}

