/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.admin.actions.lookandfeel.DefaultDecorator;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.core.PersistentDecorator;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.plugins.synchrony.api.SynchronyEnv;
import com.atlassian.confluence.plugins.synchrony.api.SynchronyProcessManager;
import com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager;
import com.atlassian.confluence.setup.settings.CustomHtmlSettings;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.setup.settings.beans.CaptchaSettings;
import com.atlassian.confluence.spaces.DefaultSpaceManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.persistence.dao.SpaceDao;
import com.atlassian.confluence.status.service.SystemInformationHelper;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.DatabaseInfo;
import com.atlassian.confluence.status.service.systeminfo.MemoryInfo;
import com.atlassian.confluence.status.service.systeminfo.UsageInfo;
import com.atlassian.confluence.themes.StylesheetManager;
import com.atlassian.confluence.themes.persistence.PersistentDecoratorDao;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.support.tools.format.ByteSizeFormat;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.PropertyStore;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.request.FileSanitizer;
import com.atlassian.support.tools.salext.AbstractSupportApplicationInfo;
import com.atlassian.support.tools.salext.ApplicationType;
import com.atlassian.support.tools.salext.bundle.AuthenticationConfigurationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.CustomisationFileBundle;
import com.atlassian.support.tools.salext.bundle.FileSetsBundle;
import com.atlassian.support.tools.salext.bundle.HealthcheckResultsBundle;
import com.atlassian.support.tools.salext.bundle.fileset.ExactFileSet;
import com.atlassian.support.tools.salext.bundle.fileset.RegexFileSet;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.ProductLicenseInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceApplicationInfo.class);
    private static final int CONFLUENCE_SIX_BASE_BUILD_NUMBER = 7100;
    public static final String CONFLUENCE_CLUSTERED = "clustered";
    public static final String CONFLUENCE_SITE_HOME_PAGE = "site.home.page";
    public static final String CONFLUENCE_USAGE_CONTENT_CURRENT = "usage.content.current";
    public static final String CONFLUENCE_USAGE_CONTENT_TOTAL = "usage.content.total";
    public static final String CONFLUENCE_USAGE_GLOBAL_SPACES = "usage.global.spaces";
    public static final String CONFLUENCE_USAGE_PERSONAL_SPACES = "usage.personal.spaces";
    public static final String CONFLUENCE_USAGE_TOTAL_SPACES = "usage.total.spaces";
    public static final String ZIP_INCLUDE_CONFLUENCE_LOGS_DESCRIPTION = "stp.zip.include.confluence.logs.description";
    public static final String ZIP_INCLUDE_CONFLUENCE_LOGS = "stp.zip.include.confluence.logs";
    public static final String ZIP_INCLUDE_CONFLUENCE_CFG = "stp.zip.include.confluence.cfg";
    public static final String ZIP_INCLUDE_CONFLUENCE_CUST = "stp.zip.include.confluence.cust";
    public static final String ZIP_INCLUDE_CONFLUENCE_CUST_DESC = "stp.zip.include.confluence.cust.description";
    private final ByteSizeFormat byteFormat = new ByteSizeFormat();
    private final NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private final I18NBeanFactory i18NBeanFactory;
    private final LicenseService licenseService;
    private final SystemInformationService sysInfoService;
    private final LanguageManager languageManager;
    private final ClusterManager clusterManager;
    private final CrowdDirectoryService dirService;
    private final SpaceManager spaceManager;
    private final StylesheetManager stylesheetManager;
    private final SettingsManager settingsManager;
    private final ApplicationConfiguration applicationConfiguration;
    private final BundleContext bundleContext;

    public ConfluenceApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, SystemInformationService sysInfoService, LanguageManager languageManager, ClusterManager clusterManager, I18NBeanFactory i18NBeanFactory, LicenseService licenseService, CrowdDirectoryService dirService, SettingsManager settingsManager, SpaceManager spaceManager, StylesheetManager stylesheetManager, ApplicationConfiguration applicationConfiguration, PluginAccessor pluginAccessor, BundleContext bundleContext, MailUtility mailUtility) {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver, pluginAccessor, mailUtility);
        this.sysInfoService = sysInfoService;
        this.languageManager = languageManager;
        this.clusterManager = clusterManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.licenseService = licenseService;
        this.dirService = dirService;
        this.spaceManager = spaceManager;
        this.stylesheetManager = stylesheetManager;
        this.settingsManager = settingsManager;
        this.applicationConfiguration = applicationConfiguration;
        this.bundleContext = bundleContext;
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException {
        String url = System.getProperty("hercules.regex.url", "https://confluence.atlassian.com/download/attachments/179443532/confluence_regex_v2.xml");
        return this.getPatternSourceByURL(url, this.getProxy());
    }

    @Override
    public String getApplicationSEN() {
        ConfluenceInfo confluenceInfo = this.sysInfoService.getConfluenceInfo();
        return confluenceInfo.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        ConfluenceInfo confluenceInfo = this.sysInfoService.getConfluenceInfo();
        return confluenceInfo.getServerId();
    }

    @Override
    public String getApplicationHome() {
        return this.applicationConfiguration.getApplicationHome();
    }

    @Override
    protected PropertyStore internalLoadProperties(SupportInfoDetail detail) {
        int userCount;
        PropertyStore store = super.internalLoadProperties(detail);
        DatabaseInfo dbInfo = this.sysInfoService.getDatabaseInfo();
        PropertyStore dbProperties = store.addCategory("stp.properties.db");
        dbProperties.setValue("stp.properties.db.driver.class", dbInfo.getClass().getName());
        dbProperties.setValue("stp.properties.db.dialect", dbInfo.getDialect());
        dbProperties.setValue("stp.properties.db.driver.name", dbInfo.getDriverName());
        dbProperties.setValue("stp.properties.db.driver.version", dbInfo.getDriverVersion());
        dbProperties.setValue("stp.properties.db.example.Latency", dbInfo.getExampleLatency().toString());
        dbProperties.setValue("stp.properties.db.connection.transaction.isolation", dbInfo.getIsolationLevel());
        dbProperties.setValue("stp.properties.db.name", dbInfo.getName());
        dbProperties.setValue("stp.properties.db.connection.url", dbInfo.getUrl());
        dbProperties.setValue("stp.properties.db.version", dbInfo.getVersion());
        ConfluenceInfo confluenceInfo = this.sysInfoService.getConfluenceInfo();
        PropertyStore confluenceProperties = store.addCategory("stp.properties.application.info");
        confluenceProperties.setValue("stp.properties.application.base.url", confluenceInfo.getBaseUrl());
        confluenceProperties.setValue("stp.properties.application.build.number", confluenceInfo.getBuildNumber());
        confluenceProperties.setValue("stp.properties.application.home", confluenceInfo.getHome());
        confluenceProperties.setValue("stp.properties.license.server.id", confluenceInfo.getServerId());
        confluenceProperties.setValue("stp.properties.application.start.time", new Date(confluenceInfo.getStartTime()).toString());
        confluenceProperties.setValue("stp.properties.license.sen", confluenceInfo.getSupportEntitlementNumber());
        confluenceProperties.setValue("stp.properties.application.uptime", confluenceInfo.getUpTime());
        confluenceProperties.setValue("stp.properties.application.version", confluenceInfo.getVersion());
        Settings globalSettings = confluenceInfo.getGlobalSettings();
        confluenceProperties.setValue("stp.properties.attachment.data.store", globalSettings.getAttachmentDataStore());
        confluenceProperties.setValue("stp.properties.attachment.max.size", String.valueOf(globalSettings.getAttachmentMaxSize()));
        confluenceProperties.setValue("stp.properties.backup.path", globalSettings.getBackupPath());
        CaptchaSettings captchaSettings = globalSettings.getCaptchaSettings();
        confluenceProperties.setValue("stp.properties.captcha.enabled", String.valueOf(captchaSettings.isEnableCaptcha()));
        confluenceProperties.setValue("stp.properties.captcha.groups", StringUtils.join((Collection)captchaSettings.getCaptchaGroups(), (char)','));
        confluenceProperties.setValue("stp.properties.backup.date.format.pattern", globalSettings.getDailyBackupDateFormatPattern());
        confluenceProperties.setValue("stp.properties.backup.file.prefix", globalSettings.getDailyBackupFilePrefix());
        confluenceProperties.setValue("stp.properties.default.encoding", globalSettings.getDefaultEncoding());
        confluenceProperties.setValue("stp.properties.global.default.locale", globalSettings.getGlobalDefaultLocale());
        confluenceProperties.setValue("stp.properties.indexing.language", globalSettings.getIndexingLanguage());
        confluenceProperties.setValue("stp.properties.attachment.ui.max", String.valueOf(globalSettings.getMaxAttachmentsInUI()));
        confluenceProperties.setValue("stp.properties.rss.max.items", String.valueOf(globalSettings.getMaxRssItems()));
        confluenceProperties.setValue("stp.properties.quicknav.max.requests", String.valueOf(globalSettings.getMaxSimultaneousQuickNavRequests()));
        confluenceProperties.setValue(CONFLUENCE_SITE_HOME_PAGE, globalSettings.getSiteHomePage());
        confluenceProperties.setValue("stp.properties.application.time.zone", globalSettings.getTimeZone().toString());
        SystemInformationHelper helper = new SystemInformationHelper(this.i18NBeanFactory.getI18NBean(Locale.ENGLISH), this.sysInfoService);
        confluenceProperties.setValue("stp.properties.system.date", (String)helper.getSystemSummary().get("system.date"));
        confluenceProperties.setValue("stp.properties.system.time", (String)helper.getSystemSummary().get("system.time"));
        PropertyStore systemSummaryStore = store.addCategory("stp.properties.system");
        systemSummaryStore.putValues(helper.getSystemSummary());
        if (this.isCollabEditingSupported()) {
            this.addSynchronyConfiguration(store);
        }
        PropertyStore enabledPluginProperties = store.addCategory("stp.properties.plugins.enabled");
        this.loadPluginPropertiesIntoStore(enabledPluginProperties, confluenceInfo.getEnabledPlugins());
        PropertyStore disabledPluginProperties = store.addCategory("stp.properties.plugins.disabled");
        this.loadPluginPropertiesIntoStore(disabledPluginProperties, this.getDisabledPlugins());
        MemoryInfo memoryInfo = this.sysInfoService.getMemoryInfo();
        PropertyStore memoryProperties = store.addCategory("stp.properties.memory");
        memoryProperties.setValue("stp.properties.java.heap.allocated", this.byteFormat.format(memoryInfo.getAllocatedHeap().bytes()));
        memoryProperties.setValue("stp.properties.java.heap.available", this.byteFormat.format(memoryInfo.getAvailableHeap().bytes()));
        memoryProperties.setValue("stp.properties.java.permgen.available", this.byteFormat.format(memoryInfo.getAvailablePermGen().bytes()));
        memoryProperties.setValue("stp.properties.java.heap.free.allocated", this.byteFormat.format(memoryInfo.getFreeAllocatedHeap().bytes()));
        memoryProperties.setValue("stp.properties.java.heap.percent.used", this.percentFormat.format((double)memoryInfo.getFreeAllocatedHeap().bytes() / (double)memoryInfo.getMaxHeap().bytes()) + this.i18nResolver.getText("stp.java.memory.free"));
        memoryProperties.setValue("stp.properties.java.heap.max", this.byteFormat.format(memoryInfo.getMaxHeap().bytes()));
        memoryProperties.setValue("stp.properties.java.heap.used", this.byteFormat.format(memoryInfo.getUsedHeap().bytes()));
        memoryProperties.setValue("stp.properties.java.permgen.percent.used", this.percentFormat.format((double)memoryInfo.getAvailablePermGen().bytes() / (double)memoryInfo.getMaxPermGen().bytes()) + this.i18nResolver.getText("stp.java.memory.free"));
        memoryProperties.setValue("stp.properties.java.permgen.max", this.byteFormat.format(memoryInfo.getMaxPermGen().bytes()));
        memoryProperties.setValue("stp.properties.java.permgen.used", this.byteFormat.format(memoryInfo.getUsedPermGen().bytes()));
        Map modifications = this.sysInfoService.getModifications();
        PropertyStore modificationProperties = store.addCategory("stp.properties.modz");
        modificationProperties.putValues(modifications);
        UsageInfo usageInfo = this.sysInfoService.getUsageInfo();
        PropertyStore usageProperties = store.addCategory("stp.properties.usage");
        usageProperties.setValue(CONFLUENCE_USAGE_CONTENT_TOTAL, String.valueOf(usageInfo.getAllContent()));
        usageProperties.setValue(CONFLUENCE_USAGE_CONTENT_CURRENT, String.valueOf(usageInfo.getCurrentContent()));
        usageProperties.setValue("stp.properties.usage.index.size", String.valueOf(usageInfo.getIndexSize()));
        usageProperties.setValue("stp.properties.usage.local.groups", String.valueOf(usageInfo.getLocalGroups()));
        usageProperties.setValue("stp.properties.usage.local.users", String.valueOf(usageInfo.getLocalUsers()));
        usageProperties.setValue(CONFLUENCE_USAGE_GLOBAL_SPACES, String.valueOf(usageInfo.getGlobalSpaces()));
        usageProperties.setValue(CONFLUENCE_USAGE_PERSONAL_SPACES, String.valueOf(usageInfo.getPersonalSpaces()));
        usageProperties.setValue(CONFLUENCE_USAGE_TOTAL_SPACES, String.valueOf(usageInfo.getTotalSpaces()));
        PropertyStore languageProperties = store.addCategory("stp.properties.languages.installed");
        for (Language language : this.languageManager.getLanguages()) {
            PropertyStore languageStore = languageProperties.addCategory(language.getName());
            languageStore.setValue("stp.properties.languages.language.name", language.getName());
            languageStore.setValue("stp.properties.languages.language.country", language.getCountry());
        }
        PropertyStore licenseProperties = store.addCategory("stp.properties.license");
        License license = LicenseManager.getInstance().getLicense("CONF");
        licenseProperties.setValue("stp.properties.license.organisation", license.getOrganisation());
        if (license.getLicenseType() != null) {
            licenseProperties.setValue("stp.properties.license.type", license.getLicenseType().toString());
        }
        if (license.getExpiryDate() != null) {
            licenseProperties.setValue("stp.properties.license.period", license.getExpiryDate().toString());
        }
        licenseProperties.setValue("stp.properties.license.users", String.valueOf(license.getUsers()));
        licenseProperties.setValue("stp.properties.license.partner", license.getPartnerName());
        licenseProperties.setValue("stp.properties.license.server.id", confluenceInfo.getServerId());
        licenseProperties.setValue("stp.properties.license.sen", confluenceInfo.getSupportEntitlementNumber());
        licenseProperties.setValue(CONFLUENCE_CLUSTERED, String.valueOf(this.clusterManager.isClustered()));
        UserChecker userChecker = (UserChecker)ContainerManager.getComponent((String)"userChecker");
        if (userChecker != null && (userCount = userChecker.getNumberOfRegisteredUsers()) > 0) {
            licenseProperties.setValue("stp.properties.license.users.active", String.valueOf(userCount));
        }
        this.addUpgradeRecoveryFileNames(store);
        return store;
    }

    private void loadPluginPropertiesIntoStore(PropertyStore pluginPropertiesStore, Collection<Plugin> pluginsCollection) {
        for (Plugin plugin : pluginsCollection) {
            PluginInformation pluginInformation = plugin.getPluginInformation();
            PropertyStore pluginStore = pluginPropertiesStore.addCategory("stp.properties.plugins.plugin");
            pluginStore.setValue("stp.properties.plugins.plugin.key", plugin.getKey());
            pluginStore.setValue("stp.properties.plugins.plugin.name", plugin.getName());
            pluginStore.setValue("stp.properties.plugins.plugin.version", pluginInformation.getVersion());
            pluginStore.setValue("stp.properties.plugins.plugin.vendor", pluginInformation.getVendorName());
            pluginStore.setValue("stp.properties.plugins.plugin.status", plugin.getPluginState().toString());
            pluginStore.setValue("stp.properties.plugins.plugin.vendor.url", pluginInformation.getVendorUrl());
            pluginStore.setValue("stp.properties.plugins.plugin.framework.version", String.valueOf(plugin.getPluginsVersion()));
            pluginStore.setValue("stp.properties.plugins.plugin.bundled", plugin.isBundledPlugin() ? this.getText("stp.properties.plugins.plugin.bundled") : this.getText("stp.properties.plugins.plugin.user.installed"));
        }
    }

    private void addUpgradeRecoveryFileNames(PropertyStore store) {
        PropertyStore upgradeRecoveryFiles = store.addCategory("stp.properties.upgrade.recovery.files");
        File directory = new File(this.applicationProperties.getHomeDirectory(), "recovery");
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("upgradeRecoveryFile-") && name.endsWith(".xml.gz");
            }
        });
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return Long.signum(o2.lastModified() - o1.lastModified());
            }
        });
        for (File file : files) {
            PropertyStore upgradeRecoveryfile = upgradeRecoveryFiles.addCategory("stp.properties.upgrade.recovery.file");
            upgradeRecoveryfile.setValue("stp.properties.upgrade.recovery.file.name", file.getName());
            upgradeRecoveryfile.setValue("stp.properties.upgrade.recovery.file.date", new Date(file.lastModified()).toString());
            upgradeRecoveryfile.setValue("stp.properties.upgrade.recovery.file.size", this.byteFormat.format(file.length()));
        }
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        super.initServletInfo(config);
        String webInfDir = this.findTomcatFileOrDirectory("confluence/WEB-INF");
        String webInfClassesDir = webInfDir + "/classes";
        String binDir = this.findTomcatFileOrDirectory("bin");
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_CONFLUENCE_CFG, "stp.zip.include.confluence.cfg.description").fileSet(ExactFileSet.ofPaths(webInfClassesDir + "/confluence-init.properties", this.getApplicationHome() + "/confluence.cfg.xml", webInfDir + "/web.xml", webInfClassesDir + "/log4j.properties", webInfClassesDir + "/log4j-diagnostic.properties", webInfClassesDir + "/logging.properties", binDir + "/setenv.sh", binDir + "/setenv.bat", binDir + "/setclasspath.sh", binDir + "/setclasspath.bat", binDir + "/start-confluence.sh", binDir + "/start-confluence.bat", binDir + "/stop-confluence.sh", binDir + "/stop-confluence.bat", binDir + "/startup.sh", binDir + "/startup.bat", binDir + "/shutdown.sh", binDir + "/shutdown.bat")).build());
        this.applicationInfoBundles.add(new CustomisationFileBundle(BundleManifest.CONF_CUSTOMISATIONS, ZIP_INCLUDE_CONFLUENCE_CUST, ZIP_INCLUDE_CONFLUENCE_CUST_DESC, this, this.getCustomDecorators(), this.getCustomHtml(), this.getCustomStylesheet()));
        this.applicationInfoBundles.add(new HealthcheckResultsBundle(BundleManifest.HEALTHCHECKS, "stp.zip.include.healthchecks", "stp.zip.include.healthchecks.description", this, this.bundleContext));
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_CONFIG, "stp.zip.include.tomcat.conf", "stp.zip.include.tomcat.conf.description").fileSet(RegexFileSet.fromDirectoryPath(this.findTomcatFileOrDirectory("conf"), Pattern.compile("^.*\\.(xml|properties|policy)$"))).build());
        this.applicationInfoBundles.add(new AuthenticationConfigurationFileBundle(BundleManifest.AUTH_CONFIG, "stp.zip.include.auth.cfg", "stp.zip.include.auth.cfg.description", this, this.dirService, webInfClassesDir + "/seraph-config.xml", webInfClassesDir + "/seraph-paths.xml", webInfClassesDir + "/crowd.properties"));
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.CACHE_CONFIG, "stp.zip.include.cache.cfg", "stp.zip.include.cache.cfg.description").fileSet(ExactFileSet.ofPaths(this.getApplicationHome() + "/config/ehcache.xml", this.getApplicationHome() + "/config/ehcache.properties")).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_CONFLUENCE_LOGS, ZIP_INCLUDE_CONFLUENCE_LOGS_DESCRIPTION).fileSet(RegexFileSet.fromDirectoryPath(this.getApplicationHome() + "/logs", Pattern.compile("^.*\\.log.*"))).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_LOGS, "stp.zip.include.tomcat.logs", "stp.zip.include.tomcat.logs.description").fileSet(RegexFileSet.fromDirectoryPath(this.findTomcatFileOrDirectory("logs"), Pattern.compile(".*gc.*\\.log.*|^.*\\.(log|out)$"))).build());
    }

    private TreeMap<String, String> getCustomDecorators() {
        TreeMap<String, String> customDecorators = new TreeMap<String, String>();
        PersistentDecoratorDao decDao = (PersistentDecoratorDao)ContainerManager.getComponent((String)"persistentDecoratorDao");
        DefaultSpaceManager spaceManager = new DefaultSpaceManager();
        SpaceDao spaceDao = (SpaceDao)ContainerManager.getComponent((String)"spaceDao");
        spaceManager.setSpaceDao(spaceDao);
        for (DefaultDecorator dec : DefaultDecorator.getDecorators()) {
            PersistentDecorator customDec = decDao.get(null, dec.getFileName());
            if (customDec != null) {
                customDecorators.put(String.format("Global customised layout - %s", dec.getFileName().replace('/', '-').replace('\\', '-')), customDec.getBody());
            }
            for (Space space : spaceManager.getAllSpaces()) {
                PersistentDecorator spaceDec = decDao.get(space.getKey(), dec.getFileName());
                if (spaceDec == null) continue;
                customDecorators.put(String.format("Space %s customised layout - %s", space.getName(), dec.getFileName().replace('/', '-').replace('\\', '-')), spaceDec.getBody());
            }
        }
        return customDecorators;
    }

    private HashMap<String, String> getCustomHtml() {
        HashMap<String, String> customHtml = new HashMap<String, String>();
        CustomHtmlSettings customHtmlSettings = new CustomHtmlSettings(this.settingsManager.getGlobalSettings().getCustomHtmlSettings());
        String headHtml = customHtmlSettings.getBeforeHeadEnd();
        String bodyStartHtml = customHtmlSettings.getAfterBodyStart();
        String bodyEndHtml = customHtmlSettings.getBeforeBodyEnd();
        if (!headHtml.isEmpty()) {
            customHtml.put("Before HEAD end", headHtml);
        }
        if (!bodyStartHtml.isEmpty()) {
            customHtml.put("After BODY start", bodyStartHtml);
        }
        if (!bodyEndHtml.isEmpty()) {
            customHtml.put("Before BODY end", bodyEndHtml);
        }
        return customHtml;
    }

    private HashMap<String, String> getCustomStylesheet() {
        HashMap<String, String> customStylesheet = new HashMap<String, String>();
        String globalStylesheet = this.stylesheetManager.getGlobalStylesheet();
        if (StringUtils.isNotEmpty((String)globalStylesheet)) {
            customStylesheet.put("Global Custom Stylesheet", globalStylesheet);
        }
        for (Space space : this.spaceManager.getAllSpaces()) {
            String spaceStylesheet = this.stylesheetManager.getSpaceStylesheet(space.getKey(), false);
            if (!StringUtils.isNotEmpty((String)spaceStylesheet)) continue;
            customStylesheet.put("Space " + space.getName() + " custom stylesheet", spaceStylesheet);
        }
        return customStylesheet;
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        String logFilePath = this.getApplicationHome() + "/logs/atlassian-confluence.log";
        if (new File(logFilePath).exists()) {
            return Collections.singletonList(ScanItem.createDefaultItem(logFilePath));
        }
        return Collections.emptyList();
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "confluence-autosupportrequests@atlassian.com";
    }

    @Override
    public String getMailQueueURL(HttpServletRequest req) {
        return this.getBaseURL(req) + "/admin/mail/viewmailqueue.action";
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return true;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/admin/mail/viewmailservers.action";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(FILE_PATTERNS, EXECUTABLE_EXTENSIONS);
    }

    @Override
    public String getApplicationLogDir() {
        return this.getApplicationHome() + "/logs";
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        return new ProductLicenseInfo((ProductLicense)this.licenseService.retrieve());
    }

    @Override
    public String getAdminLicenseUrl() {
        return "/admin/license.action";
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.CONFLUENCE;
    }

    @Override
    public Pattern getApplicationRestartPattern() {
        return Pattern.compile("(Starting\\sConfluence...)");
    }

    private boolean isCollabEditingSupported() {
        return Integer.parseInt(this.getApplicationBuildNumber()) >= 7100;
    }

    private void addSynchronyConfiguration(PropertyStore store) {
        block21: {
            try (SynchronyServiceWrapper wrapper = new SynchronyServiceWrapper();){
                SynchronyProcessManager processManager;
                PropertyStore configProps = store.addCategory("stp.properties.synchrony.configuration");
                ServiceReference configRef = wrapper.getConfigManagerRef();
                if (configRef != null) {
                    SynchronyConfigurationManager configManager = wrapper.getConfigManager();
                    if (configManager != null) {
                        configProps.setValue("stp.properties.synchrony.enabled", String.valueOf(configManager.isSynchronyEnabled()));
                        configProps.setValue("stp.properties.synchrony.shared.drafts.enabled", String.valueOf(configManager.isSharedDraftsEnabled()));
                        configProps.setValue("stp.properties.synchrony.explicitly.disabled", String.valueOf(configManager.isSynchronyExplicitlyDisabled()));
                        configProps.setValue("stp.properties.synchrony.shared.drafts.explicitly.disabled", String.valueOf(configManager.isSharedDraftsExplicitlyDisabled()));
                        configProps.setValue("stp.properties.synchrony.production.override", String.valueOf(configManager.isSynchronyProdOverrideEnabled()));
                        configProps.setValue("stp.properties.synchrony.internal.url", configManager.getInternalServiceUrl());
                        configProps.setValue("stp.properties.synchrony.internal.port", String.valueOf(configManager.getInternalPort()));
                        configProps.setValue("stp.properties.synchrony.external.url", configManager.getExternalServiceUrl());
                        configProps.setValue("stp.properties.synchrony.resources.url", configManager.getResourcesUrl());
                    }
                } else if (this.isCollabEditingSupported()) {
                    log.warn("Not able to locate the service for getting the Synchrony configuration. The Collaborative Editor Plugin may have been disabled.");
                }
                try {
                    Class<?> confluenceSystemProperties = Class.forName("com.atlassian.confluence.core.ConfluenceSystemProperties");
                    Method isSynchronyProxyEnabled = confluenceSystemProperties.getMethod("isSynchronyProxyEnabled", new Class[0]);
                    boolean isEnabled = (Boolean)isSynchronyProxyEnabled.invoke(ConfluenceSystemProperties.class, new Object[0]);
                    configProps.setValue("stp.properties.synchrony.proxy.enabled", String.valueOf(isEnabled));
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    log.error(ex.getMessage());
                }
                PropertyStore envProps = store.addCategory("stp.properties.synchrony.environment");
                ServiceReference processRef = wrapper.getProcessManagerRef();
                if (processRef == null || (processManager = wrapper.getProcessManager()) == null) break block21;
                try {
                    ?[] enumConstants;
                    Class<?> synchronyEnv = Class.forName("com.atlassian.confluence.plugins.synchrony.api.SynchronyEnv");
                    for (Object enumConstant : enumConstants = synchronyEnv.getEnumConstants()) {
                        envProps.setValue(String.valueOf(enumConstant), processManager.getSynchronyProperty((SynchronyEnv)enumConstant));
                    }
                }
                catch (ClassNotFoundException ex) {
                    log.error(ex.getMessage());
                }
            }
        }
    }

    static {
        FILE_PATTERNS.put("confluence.cfg.xml", Arrays.asList(Pattern.compile("(?:.*<property name=\"confluence\\.license\\.message\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.username\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.password\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"license\\.string\">)(.*)(?:</property>.*)")));
        FILE_PATTERNS.put("application.xml", Arrays.asList(Pattern.compile("<JwtPublicKey>(.*?)</JwtPublicKey>"), Pattern.compile("<JwtPrivateKey>(.*?)</JwtPrivateKey>")));
    }

    private final class SynchronyServiceWrapper
    implements AutoCloseable {
        private final ServiceReference configManagerRef;
        private final ServiceReference processManagerRef;

        SynchronyServiceWrapper() {
            this.configManagerRef = ConfluenceApplicationInfo.this.bundleContext.getServiceReference("com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager");
            this.processManagerRef = ConfluenceApplicationInfo.this.bundleContext.getServiceReference("com.atlassian.confluence.plugins.synchrony.api.SynchronyProcessManager");
        }

        @Override
        public void close() {
            if (this.getConfigManagerRef() != null) {
                ConfluenceApplicationInfo.this.bundleContext.ungetService(this.configManagerRef);
            }
            if (this.getProcessManagerRef() != null) {
                ConfluenceApplicationInfo.this.bundleContext.ungetService(this.processManagerRef);
            }
        }

        private ServiceReference getConfigManagerRef() {
            return this.configManagerRef;
        }

        private ServiceReference getProcessManagerRef() {
            return this.processManagerRef;
        }

        private SynchronyConfigurationManager getConfigManager() {
            return (SynchronyConfigurationManager)ConfluenceApplicationInfo.this.bundleContext.getService(this.configManagerRef);
        }

        private SynchronyProcessManager getProcessManager() {
            return (SynchronyProcessManager)ConfluenceApplicationInfo.this.bundleContext.getService(this.processManagerRef);
        }
    }
}

