/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.sisyphus.SisyphusPatternSourceDecorator;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.request.FileSanitizer;
import com.atlassian.support.tools.salext.AbstractSupportApplicationInfo;
import com.atlassian.support.tools.salext.ApplicationType;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.FileSetsBundle;
import com.atlassian.support.tools.salext.bundle.fileset.AlternativesAwareFileSet;
import com.atlassian.support.tools.salext.bundle.fileset.ExactFileSet;
import com.atlassian.support.tools.salext.bundle.fileset.RegexFileSet;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.ProductLicenseInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketApplicationInfo
extends AbstractSupportApplicationInfo {
    private static final Logger log = LoggerFactory.getLogger(BitbucketApplicationInfo.class);
    @VisibleForTesting
    static final Pattern LOG_FILE_PATTERN = Pattern.compile("(^(?!.*audit).*\\.log.*)");
    private static final String ZIP_INCLUDE_BITBUCKET_LOGS_DESCRIPTION = "stp.zip.include.bitbucket.logs.description";
    private static final String ZIP_INCLUDE_BITBUCKET_LOGS = "stp.zip.include.bitbucket.logs";
    private static final String ZIP_INCLUDE_BITBUCKET_CFG_DESCRIPTION = "stp.zip.include.bitbucket.cfg.description";
    private static final String ZIP_INCLUDE_BITBUCKET_CFG = "stp.zip.include.bitbucket.cfg";
    private static final String BITBUCKET_PROPERTIES = "bitbucket.properties";
    private static final String BUCKLER_CONFIG_YAML = "buckler.yml";
    private static final Pattern YML_FILE_PATTERN = Pattern.compile("^.*\\.yml$");
    private static final Map<String, List<Pattern>> FILE_PATTERNS_TO_SANITIZE = ImmutableMap.builder().putAll(FILE_PATTERNS).put((Object)"bitbucket.properties", (Object)ImmutableList.of((Object)Pattern.compile("^[#\\s]*jdbc\\.password\\s*.(.*)"), (Object)Pattern.compile("^[#\\s]*hazelcast\\.group\\.name\\s*.(.*)"), (Object)Pattern.compile("^[#\\s]*hazelcast\\.group\\.password\\s*.(.*)"), (Object)Pattern.compile("^[#\\s]*hazelcast\\.network\\.aws\\.secret\\.key\\s*.(.*)"))).put((Object)"buckler.yml", (Object)ImmutableList.of((Object)Pattern.compile("^[#\\s]*auth\\.basic\\.password\\s*.(.*)"))).build();
    private final LicenseHandler licenseHandler;
    private final LicenseService licenseService;
    private final ApplicationPropertiesService propertiesService;
    private volatile String sharedHome;

    public BitbucketApplicationInfo(ApplicationProperties applicationProperties, ApplicationPropertiesService applicationPropertiesService, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, LicenseHandler licenseHandler, LicenseService licenseService, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, PluginAccessor pluginAccessor, MailUtility mailUtility) {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver, pluginAccessor, mailUtility);
        this.licenseHandler = licenseHandler;
        this.licenseService = licenseService;
        this.propertiesService = applicationPropertiesService;
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        String logFilePath = this.applicationProperties.getHomeDirectory() + "/log/atlassian-bitbucket.log";
        if (new File(logFilePath).exists()) {
            return Collections.singletonList(ScanItem.createDefaultItem(logFilePath));
        }
        return Collections.emptyList();
    }

    public String getApplicationSharedHome() {
        if (this.sharedHome == null) {
            try {
                Method method = this.propertiesService.getClass().getMethod("getSharedHome", new Class[0]);
                File sharedHomeFile = (File)method.invoke((Object)this.propertiesService, new Object[0]);
                this.sharedHome = sharedHomeFile.getAbsolutePath();
            }
            catch (Exception e) {
                File repositoriesDir = this.propertiesService.getRepositoriesDir();
                this.sharedHome = repositoriesDir != null && repositoriesDir.getParentFile() != null && repositoriesDir.getParentFile().getParentFile() != null ? repositoriesDir.getParentFile().getParentFile().getAbsolutePath() : this.getApplicationHome();
            }
        }
        return this.sharedHome;
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException {
        String url = System.getProperty("hercules.regex.url", "https://confluence.atlassian.com/download/attachments/179443532/stash_regex_v2.xml");
        SisyphusPatternSourceDecorator source = new SisyphusPatternSourceDecorator();
        source.add(this.getPatternSourceByURL(url, this.getProxy()));
        return source;
    }

    @Override
    public String getApplicationSEN() {
        return this.licenseHandler.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        return this.licenseHandler.getServerId();
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "stash-autosupportrequests@atlassian.com";
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return false;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/admin/mail-server";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(FILE_PATTERNS_TO_SANITIZE, EXECUTABLE_EXTENSIONS);
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        super.initServletInfo(config);
        String searchConfigurationDir = this.getApplicationSharedHome() + "/search";
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_BITBUCKET_CFG, ZIP_INCLUDE_BITBUCKET_CFG_DESCRIPTION).fileSet(ExactFileSet.ofPaths(this.getApplicationSharedHome() + "/" + BITBUCKET_PROPERTIES)).fileSet(RegexFileSet.fromDirectoryPath(searchConfigurationDir, YML_FILE_PATTERN)).fileSet(RegexFileSet.fromDirectoryPath(searchConfigurationDir + "/buckler", YML_FILE_PATTERN)).build());
        String tomcatConfDir = this.findTomcatFileOrDirectory("conf");
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_CONFIG, "stp.zip.include.tomcat.conf", "stp.zip.include.tomcat.conf.description").fileSet(RegexFileSet.fromDirectoryPath(tomcatConfDir, Pattern.compile("^.*\\.(properties|policy)$"))).fileSet(RegexFileSet.fromDirectoryPath(tomcatConfDir, Pattern.compile("^(?!server).*\\.xml$"))).fileSet(AlternativesAwareFileSet.builder().pathWithAlternatives((Collection<String>)ImmutableList.of((Object)(this.getApplicationHome() + "/server.xml"), (Object)(this.getApplicationSharedHome() + "/server.xml"), (Object)(tomcatConfDir + "/server.xml"))).build()).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_BITBUCKET_LOGS, ZIP_INCLUDE_BITBUCKET_LOGS_DESCRIPTION).fileSet(RegexFileSet.fromDirectoryPath(this.getApplicationHome() + "/log", LOG_FILE_PATTERN)).fileSet(RegexFileSet.fromDirectoryPath(this.getApplicationHome() + "/log/search", Pattern.compile(".*"))).build());
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_LOGS, "stp.zip.include.tomcat.logs", "stp.zip.include.tomcat.logs.description").fileSet(RegexFileSet.fromDirectoryPath(this.findTomcatFileOrDirectory("logs"), Pattern.compile(".*gc.*\\.log.*|^.*\\.(log|out)$"))).build());
    }

    @Override
    public String getApplicationLogDir() {
        return this.getApplicationHome() + "/log";
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        return new ProductLicenseInfo((ProductLicense)this.licenseService.get());
    }

    @Override
    public String getAdminLicenseUrl() {
        return "/admin/license?edit";
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.BITBUCKET;
    }

    @Override
    public Pattern getApplicationRestartPattern() {
        return Pattern.compile("(Starting\\sBitbucket)");
    }
}

