/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.rest;

import com.atlassian.support.tools.request.SupportRequestService;
import com.atlassian.support.tools.rest.CacheControlUtils;
import com.atlassian.support.tools.rest.RestTaskStatus;
import com.atlassian.support.tools.task.TaskMonitor;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="support-request")
@Produces(value={"application/json"})
@Singleton
public class SupportRequestResource {
    private final SupportRequestService supportRequestService;

    public SupportRequestResource(SupportRequestService supportRequestService) {
        this.supportRequestService = supportRequestService;
    }

    @GET
    @Path(value="{id}")
    public Response getSupportZipDetails(@PathParam(value="id") String id) {
        TaskMonitor monitor = this.supportRequestService.getMonitor(id);
        if (monitor == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControlUtils.NO_CACHE).build();
        }
        Response.ResponseBuilder builder = Response.ok().entity((Object)new RestTaskStatus(monitor));
        if (!monitor.isDone()) {
            builder.cacheControl(CacheControlUtils.NO_CACHE);
        }
        return builder.build();
    }
}

