/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.rest;

import com.atlassian.support.tools.rest.RestMessage;
import com.atlassian.support.tools.task.TaskMonitor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;

public class RestTaskStatus
extends LinkedHashMap<String, Object> {
    public RestTaskStatus(TaskMonitor<?> monitor) {
        this.put("id", monitor.getTaskId());
        this.put("available", monitor.isDone());
        this.put("progressPercentage", monitor.getProgressPercentage());
        this.put("progressMessage", monitor.getProgressMessage());
        if (!monitor.getWarnings().isEmpty()) {
            this.put("warnings", ImmutableList.copyOf((Iterable)Iterables.transform(monitor.getWarnings(), RestMessage.TO_REST)));
        }
        if (!monitor.getErrors().isEmpty()) {
            this.put("errors", ImmutableList.copyOf((Iterable)Iterables.transform(monitor.getErrors(), RestMessage.TO_REST)));
        }
    }
}

