/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.request;

import com.atlassian.support.tools.action.DefaultMessage;
import com.atlassian.support.tools.request.FileSanitizer;
import com.atlassian.support.tools.request.SupportZipCreationRequest;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.ApplicationInfoBundle;
import com.atlassian.support.tools.spi.HostApplication;
import com.atlassian.support.tools.task.DefaultTaskMonitor;
import com.atlassian.support.tools.task.MonitoredCallable;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateSupportZipTask
implements MonitoredCallable<File, DefaultTaskMonitor<File>> {
    private static final Logger infoLog = LoggerFactory.getLogger((String)"atlassian.plugin");
    private static final Logger log = LoggerFactory.getLogger(CreateSupportZipTask.class);
    private final SupportApplicationInfo applicationInfo;
    private final HostApplication hostApplication;
    private final DefaultTaskMonitor<File> monitor;
    private final SupportZipCreationRequest request;
    private final String username;

    CreateSupportZipTask(SupportZipCreationRequest request, SupportApplicationInfo applicationInfo, HostApplication hostApplication) {
        this.applicationInfo = applicationInfo;
        this.hostApplication = hostApplication;
        this.request = request;
        this.username = applicationInfo.getUserName();
        this.monitor = new DefaultTaskMonitor();
    }

    @Override
    public File call() throws Exception {
        return this.hostApplication.asUser(this.username, new Callable<File>(){

            @Override
            public File call() throws IOException {
                return CreateSupportZipTask.this.createSupportZip();
            }
        }).call();
    }

    @Override
    @Nonnull
    public DefaultTaskMonitor<File> getMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createSupportZip() throws IOException {
        File zipFile = this.createNewZipFile();
        FileOutputStream out = new FileOutputStream(zipFile);
        try {
            this.zip(out, this.request);
            this.monitor.updateProgress(100, this.applicationInfo.getText("stp.create.support.zip.success.message") + " " + zipFile.getAbsolutePath());
            infoLog.info("Saved Support Zip to: {}", (Object)zipFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.handleException(e);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        finally {
            Closeables.close((Closeable)out, (boolean)true);
        }
        return zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyUpTo(OutputStream out, File file, int maxBytesToCopy, boolean limitFileSizes) throws IOException {
        long totalSize = file.length();
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            int n;
            if (limitFileSizes && totalSize > (long)maxBytesToCopy) {
                f.skipBytes((int)(totalSize - (long)maxBytesToCopy));
                this.monitor.addWarning(new DefaultMessage("File Truncated", this.applicationInfo.getText("stp.zip.file.size.limited", new Serializable[]{file.getName(), "25Mb"})));
            }
            byte[] buffer = new byte[4096];
            long count = 0L;
            while (-1 != (n = f.read(buffer))) {
                out.write(buffer, 0, n);
                count += (long)n;
            }
            out.flush();
            log.debug("Copied {} bytes for {}", (Object)count, (Object)file.getName());
        }
    }

    private File createNewZipFile() throws IOException {
        File supportDir = new File(this.applicationInfo.getExportDirectory());
        if (!supportDir.exists() && !supportDir.mkdirs()) {
            throw new IOException("Couldn't create export directory " + supportDir.getAbsolutePath());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String baseFilename = this.applicationInfo.getApplicationName() + "_support_" + format.format(new Date());
        String filename = baseFilename + ".zip";
        int counter = 0;
        while (new File(filename).exists()) {
            filename = baseFilename + "-" + ++counter + ".zip";
        }
        File zipFile = new File(supportDir, filename);
        try {
            zipFile.createNewFile();
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + " - " + zipFile.getAbsolutePath());
        }
        return zipFile;
    }

    private void updateProgress(int percentage, ApplicationInfoBundle bundle, String argument) {
        String bundleTitle = this.applicationInfo.getText(bundle.getTitle());
        String message = this.applicationInfo.getText("stp.create.support.zip.progress.bundle.message", new Serializable[]{bundleTitle, argument});
        this.monitor.updateProgress(percentage, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zip(OutputStream destination, SupportZipCreationRequest request) throws IOException {
        TreeSet<String> filenames = new TreeSet<String>();
        ZipOutputStream out = new ZipOutputStream(destination);
        int entryCount = 0;
        try {
            out.setComment("zip, created by Support Tools Plugin");
            FileSanitizer sanitizer = this.applicationInfo.getFileSanitizer();
            int bundleProgressShare = request.getBundles().size() == 0 ? 0 : 100 / request.getBundles().size();
            int bundleIndex = 0;
            for (ApplicationInfoBundle bundle : request.getBundles()) {
                Map<String, String> bundleFiles;
                int progress = 100 * bundleIndex++ / request.getBundles().size();
                this.updateProgress(progress, bundle, "");
                try {
                    bundleFiles = bundle.getFiles();
                }
                catch (Throwable t) {
                    String bundleTitle = this.applicationInfo.getText(bundle.getTitle());
                    String error = this.applicationInfo.getText("stp.create.support.zip.error", new Serializable[]{bundleTitle, t.getClass().getSimpleName() + ": " + t.getMessage()});
                    this.monitor.addWarning(new DefaultMessage(bundleTitle, error));
                    log.warn(error, t);
                    continue;
                }
                for (String filePath : bundleFiles.keySet()) {
                    File file = new File(filePath);
                    if (!file.exists()) {
                        log.debug("Unable to find {} for {}", (Object)file.getName(), (Object)bundle.getKey());
                        continue;
                    }
                    if (file.isDirectory()) {
                        log.debug("{} is a directory in {}", (Object)file.getName(), (Object)bundle.getKey());
                        continue;
                    }
                    ++entryCount;
                    int currentProgress = progress + bundleProgressShare * filenames.size() / bundleFiles.size();
                    if (currentProgress > 100) {
                        currentProgress = 100;
                    }
                    String filename = sanitizer.sanitizeExtensions(file.getName());
                    int suffix = 0;
                    while (!filenames.add(filename)) {
                        filename = file.getName() + suffix++;
                    }
                    String subfolder = StringUtils.isEmpty((String)bundleFiles.get(filePath)) ? "" : bundleFiles.get(filePath) + "/";
                    String path = bundle.getKey() + "/" + subfolder + filename;
                    log.debug("adding entry: {}, as {}", (Object)file.getPath(), (Object)path);
                    this.updateProgress(currentProgress, bundle, path);
                    ZipEntry zentry = new ZipEntry(path);
                    zentry.setTime(file.lastModified());
                    out.putNextEntry(zentry);
                    this.copyUpTo(out, sanitizer.sanitize(file), 0x1900000, request.isFileSizesLimited());
                    out.closeEntry();
                }
            }
        }
        finally {
            if (entryCount > 0) {
                out.finish();
                Closeables.close((Closeable)out, (boolean)true);
            } else {
                log.warn("Support zip is empty");
                destination.close();
            }
        }
    }

    private <E extends Throwable> void handleException(E e) {
        this.monitor.updateProgress(100, e.getMessage());
        this.monitor.addError(new DefaultMessage("Support Zip Creation", e.getMessage()));
        throw Throwables.propagate(e);
    }
}

