/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.request;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.action.AbstractSupportToolsAction;
import com.atlassian.support.tools.action.SupportToolsAction;
import com.atlassian.support.tools.request.FileOptionsValidator;
import com.atlassian.support.tools.request.SupportRequestCreationRequest;
import com.atlassian.support.tools.request.SupportRequestService;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.servlet.SafeHttpServletRequest;
import com.atlassian.support.tools.task.TaskMonitor;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.EmailValidator;

public class CreateSupportRequestAction
extends AbstractSupportToolsAction {
    public static final String ACTION_NAME = "create-support-request";
    private final SupportApplicationInfo info;
    private final MailUtility mailUtility;
    private final SupportRequestService supportRequestService;
    private final EventPublisher eventPublisher;

    public CreateSupportRequestAction(SupportApplicationInfo info, MailUtility mailUtility, SupportRequestService supportRequestService, EventPublisher eventPublisher) {
        super(ACTION_NAME, "stp.contact.title", "stp.get.help.title");
        this.info = info;
        this.mailUtility = mailUtility;
        this.supportRequestService = supportRequestService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void prepare(Map<String, Object> context, SafeHttpServletRequest request, ValidationLog validationLog) {
        context.put("description", CreateSupportRequestAction.getParameter(request, "description"));
        context.put("contactEmail", this.getContactEmail(request));
        context.put("subject", CreateSupportRequestAction.getParameter(request, "subject"));
        context.put("priority", String.valueOf(this.getPriority(request)));
        context.put("mailQueueURL", this.info.getMailQueueURL(request));
        context.put("maxBytesPerFile", "25Mb");
        context.put("mailExceptionAvailable", this.info.isMailExceptionAvailable());
        context.put("mailServerConfigured", this.mailUtility.isMailServerConfigured());
        String baseUrl = this.info.getBaseURL(request);
        String licenseAdminUrl = baseUrl + this.info.getAdminLicenseUrl();
        context.put("requestUrl", request.getRequestURL());
        context.put("isLicenseExpired", this.isLicenseExpired());
        context.put("licenseAdminUrl", licenseAdminUrl);
        context.put("applicationName", this.info.getApplicationName());
        context.put("mailServerConfigurationUrl", this.info.getMailServerConfigurationURL(request));
        this.info.flagSelectedApplicationFileBundles(request);
    }

    @Override
    public void validate(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
        String contactEmail;
        if (StringUtils.isBlank((String)req.getParameter("subject"))) {
            validationLog.addFieldError("subject", "stp.create.support.request.subject.empty");
        }
        if (StringUtils.isBlank((String)req.getParameter("description"))) {
            validationLog.addFieldError("description", "stp.create.support.request.description.empty");
        }
        if (StringUtils.isBlank((String)(contactEmail = req.getParameter("contactEmail")))) {
            validationLog.addFieldError("contactEmail", "stp.create.support.request.from.empty");
        } else if (!CreateSupportRequestAction.isValidEmail(contactEmail)) {
            validationLog.addFieldError("contactEmail", "stp.create.support.request.from.invalid", new Serializable[]{StringEscapeUtils.escapeHtml((String)contactEmail)});
        }
        new FileOptionsValidator(this.info, false).validate(context, req, validationLog);
    }

    public static boolean isValidEmail(String emailAddress) {
        EmailValidator validator = EmailValidator.getInstance();
        return validator.isValid(emailAddress);
    }

    @Override
    public void execute(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
        TaskMonitor<Void> monitor = this.supportRequestService.createSupportRequest(((SupportRequestCreationRequest.Builder)((SupportRequestCreationRequest.Builder)new SupportRequestCreationRequest.Builder().description(req.getParameter("description")).fromAddres(this.getContactEmail(req)).priority(this.getPriority(req)).subject(req.getParameter("subject")).bundles(this.info.getSelectedApplicationInfoBundles(req))).limitFileSizes(req.getParameter("limit-file-sizes") != null)).build());
        context.put("taskId", monitor.getTaskId());
    }

    @Override
    public SupportToolsAction newInstance() {
        return new CreateSupportRequestAction(this.info, this.mailUtility, this.supportRequestService, this.eventPublisher);
    }

    private boolean isLicenseExpired() {
        return this.info.getLicenseInfo().getDaysToExpiry() <= 0;
    }

    private String getContactEmail(HttpServletRequest request) {
        String contactEmail = CreateSupportRequestAction.getParameter(request, "contactEmail");
        return StringUtils.isBlank((String)contactEmail) ? this.info.getUserEmail() : contactEmail;
    }

    private int getPriority(HttpServletRequest request) {
        return CreateSupportRequestAction.toInt(request.getParameter("priority"), 3);
    }

    private static String getParameter(HttpServletRequest request, String paramName) {
        String value = request.getParameter(paramName);
        return value != null ? value : "";
    }

    private static int toInt(String str, int defaultValue) {
        try {
            return str == null ? defaultValue : Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }
}

