/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.properties.appenders;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.support.tools.spi.RootLevelSupportInfoAppender;
import com.atlassian.support.tools.spi.SupportInfoBuilder;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class CrowdDirectorySupportInfo
extends RootLevelSupportInfoAppender {
    static final String STP_BASE = "stp.properties.crowd.embedded.directories";
    static final String STP_DIRECTORY_BASE = "stp.properties.crowd.embedded.directories.directory";
    private static final Logger log = LoggerFactory.getLogger(CrowdDirectorySupportInfo.class);
    private final CrowdDirectoryService crowdDirectoryService;
    private final Method isMembershipAggregationEnabledMethod;

    public CrowdDirectorySupportInfo(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.isMembershipAggregationEnabledMethod = ClassUtils.getMethodIfAvailable(CrowdDirectoryService.class, (String)"isMembershipAggregationEnabled", (Class[])new Class[0]);
    }

    @Override
    protected void addSupportInfo(SupportInfoBuilder supportInfoBuilder) {
        List directories = this.crowdDirectoryService.findAllDirectories();
        if (directories != null) {
            SupportInfoBuilder directoriesAppender = supportInfoBuilder.addCategory(STP_BASE);
            if (this.isMembershipAggregationEnabledMethod != null) {
                String membershipAggregationEnabled;
                try {
                    membershipAggregationEnabled = this.isMembershipAggregationEnabledMethod.invoke((Object)this.crowdDirectoryService, new Object[0]).toString();
                }
                catch (IllegalAccessException e) {
                    log.warn("Failed to invoke isMembershipAggregationEnabled()", (Throwable)e);
                    membershipAggregationEnabled = "Unknown";
                }
                catch (InvocationTargetException e) {
                    log.warn("Failed to invoke isMembershipAggregationEnabled()", (Throwable)e);
                    membershipAggregationEnabled = "Unknown";
                }
                directoriesAppender.addValue("stp.properties.crowd.embedded.directories.membership.aggregation", membershipAggregationEnabled);
            }
            for (Directory directory : directories) {
                SupportInfoBuilder directoryAppender = directoriesAppender.addCategory(STP_DIRECTORY_BASE);
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.id", Long.toString(directory.getId()));
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.name", directory.getName());
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.active", Boolean.toString(directory.isActive()));
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.type", this.toString(directory.getType()));
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.created", this.toString(directory.getCreatedDate()));
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.updated", this.toString(directory.getUpdatedDate()));
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.operations", this.toString(directory.getAllowedOperations()));
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.class", directory.getImplementationClass());
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.encryption", directory.getEncryptionType());
                HashMap mutableAttributes = Maps.newHashMap((Map)directory.getAttributes());
                for (String key : directory.getAttributes().keySet()) {
                    if (!key.contains("pwd") && !key.contains("password") && !key.contains("credential")) continue;
                    mutableAttributes.put(key, "(not shown)");
                }
                directoryAppender.addValue("stp.properties.crowd.embedded.directories.directory.attributes", ((Object)mutableAttributes).toString());
                directoryAppender.addContext(directory);
            }
        }
    }

    private String toString(DirectoryType directoryType) {
        if (directoryType == null) {
            return null;
        }
        return directoryType.name();
    }

    private String toString(Set<OperationType> operations) {
        if (operations == null) {
            return null;
        }
        return StringUtils.join((Collection)ImmutableSortedSet.copyOf(operations), (char)',');
    }

    private String toString(Date date) {
        if (date == null) {
            return null;
        }
        return date.toString();
    }
}

