/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.properties;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.support.tools.properties.DefaultSupportInfoBuilderContext;
import com.atlassian.support.tools.properties.PropertyStore;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.spi.SupportInfoAppender;
import com.atlassian.support.tools.spi.SupportInfoBuilder;
import com.atlassian.support.tools.spi.SupportInfoBuilderContext;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import com.atlassian.support.tools.spi.SupportInfoModuleDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class PluginSupportInfoAppenderManager
implements SupportInfoAppenderManager,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PluginSupportInfoAppenderManager.class);
    private final PluginModuleTracker<SupportInfoAppender<?>, SupportInfoModuleDescriptor> moduleTracker;
    private final int maximumContextObjectDepth = Integer.valueOf(System.getProperty("stp.spi.contexts.maximum", "1000"));
    private final int maximumCategoryDepth = Integer.valueOf(System.getProperty("stp.spi.categories.maximum", "25"));

    public PluginSupportInfoAppenderManager(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this((PluginModuleTracker<SupportInfoAppender<?>, SupportInfoModuleDescriptor>)new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, SupportInfoModuleDescriptor.class));
    }

    protected PluginSupportInfoAppenderManager(PluginModuleTracker<SupportInfoAppender<?>, SupportInfoModuleDescriptor> moduleTracker) {
        this.moduleTracker = (PluginModuleTracker)Preconditions.checkNotNull(moduleTracker);
    }

    public void destroy() {
        this.moduleTracker.close();
    }

    @Override
    public void addSupportInfo(PropertyStore propertyStore, SupportInfoDetail detail) {
        Preconditions.checkNotNull((Object)propertyStore);
        Preconditions.checkNotNull((Object)((Object)detail));
        PropertyStoreSupportInfoBuilder builder = new PropertyStoreSupportInfoBuilder(propertyStore, new DefaultSupportInfoBuilderContext(detail));
        this.addSupportInfo(builder, null);
    }

    private <T> void addSupportInfo(SupportInfoBuilder builder, T context) {
        ArrayList filteredModuleDescriptors = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.moduleTracker.getModuleDescriptors(), PluginSupportInfoAppenderManager.contextClassMatches(context)));
        Collections.sort(filteredModuleDescriptors);
        for (SupportInfoModuleDescriptor descriptor : filteredModuleDescriptors) {
            Object appender = descriptor.getModule();
            try {
                appender.addSupportInfo(builder, context);
            }
            catch (Exception e) {
                log.warn("Problem adding support info for module '{}'", (Object)descriptor.getCompleteKey(), (Object)e);
            }
        }
    }

    private static Predicate<SupportInfoModuleDescriptor> contextClassMatches(final Object context) {
        return new Predicate<SupportInfoModuleDescriptor>(){

            public boolean apply(SupportInfoModuleDescriptor descriptor) {
                Class aClass = Void.class;
                if (context != null) {
                    aClass = context.getClass();
                }
                return descriptor.getContextClass().isAssignableFrom(aClass);
            }
        };
    }

    private class PropertyStoreSupportInfoBuilder
    implements SupportInfoBuilder {
        private final int countOfContextObjects;
        private final PropertyStore propertyStore;
        private final Set<Integer> allContextObjectsIds;
        private final SupportInfoBuilderContext builderContext;
        private int currentCategoryDepth;

        private PropertyStoreSupportInfoBuilder(PropertyStore propertyStore, SupportInfoBuilderContext builderContext) {
            this.propertyStore = (PropertyStore)Preconditions.checkNotNull((Object)propertyStore);
            this.builderContext = (SupportInfoBuilderContext)Preconditions.checkNotNull((Object)builderContext);
            this.allContextObjectsIds = new HashSet<Integer>();
            this.countOfContextObjects = 0;
            this.currentCategoryDepth = 0;
        }

        private PropertyStoreSupportInfoBuilder(PropertyStoreSupportInfoBuilder parentBuilder, PropertyStore propertyStore) {
            this.propertyStore = (PropertyStore)Preconditions.checkNotNull((Object)propertyStore);
            this.builderContext = parentBuilder.builderContext;
            this.allContextObjectsIds = parentBuilder.allContextObjectsIds;
            this.countOfContextObjects = parentBuilder.countOfContextObjects;
            this.currentCategoryDepth = parentBuilder.currentCategoryDepth + 1;
        }

        private PropertyStoreSupportInfoBuilder(PropertyStoreSupportInfoBuilder parentBuilder, Object context) {
            this.propertyStore = parentBuilder.propertyStore;
            this.builderContext = parentBuilder.builderContext;
            this.allContextObjectsIds = ImmutableSet.builder().addAll(parentBuilder.allContextObjectsIds).add((Object)System.identityHashCode(context)).build();
            this.countOfContextObjects = parentBuilder.countOfContextObjects + 1;
            this.currentCategoryDepth = parentBuilder.currentCategoryDepth;
        }

        @Override
        public SupportInfoBuilderContext getBuilderContext() {
            return this.builderContext;
        }

        @Override
        public SupportInfoBuilder addValue(String key, String value) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"empty or blank key");
            if (StringUtils.isNotEmpty((String)value)) {
                this.propertyStore.setValue(key, value);
            }
            return this;
        }

        @Override
        public SupportInfoBuilder addCategory(String categoryKey) {
            Preconditions.checkState((this.currentCategoryDepth <= PluginSupportInfoAppenderManager.this.maximumCategoryDepth ? 1 : 0) != 0, (Object)"Maximum number of categories reached");
            Preconditions.checkNotNull((Object)categoryKey, (Object)"categoryKey");
            return new PropertyStoreSupportInfoBuilder(this, this.propertyStore.addCategory(categoryKey));
        }

        @Override
        public <T> SupportInfoBuilder addContext(T context) {
            Preconditions.checkState((!this.allContextObjectsIds.contains(System.identityHashCode(context)) ? 1 : 0) != 0, (Object)"Cannot have recursive context objects");
            Preconditions.checkNotNull(context, (Object)"context");
            PropertyStoreSupportInfoBuilder child = new PropertyStoreSupportInfoBuilder(this, context);
            if (this.countOfContextObjects < PluginSupportInfoAppenderManager.this.maximumContextObjectDepth) {
                PluginSupportInfoAppenderManager.this.addSupportInfo(child, context);
            } else {
                log.warn("Maximum number of context objects reached, not calling child appenders");
            }
            return child;
        }
    }
}

