/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.hercules;

import com.atlassian.sisyphus.LogLine;
import com.atlassian.sisyphus.MatchResultVisitor;
import com.atlassian.sisyphus.SisyphusPattern;
import com.atlassian.support.tools.hercules.FileProgressMonitor;
import com.atlassian.support.tools.hercules.LogScanMonitor;
import com.atlassian.support.tools.hercules.LogScanResult;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.task.MonitoredCallable;
import com.atlassian.support.tools.task.TaskMonitor;
import java.io.File;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogScanTask
implements MonitoredCallable<LogScanResult, LogScanMonitor> {
    private static final Logger LOG = LoggerFactory.getLogger(LogScanTask.class);
    private static final String LOG_SCAN_URL = "https://confluence.atlassian.com/x/KZoiLw";
    private final SupportApplicationInfo applicationInfo;
    private final File logFile;
    private final LogScanMonitor monitor;
    private final LogScanResult result;

    public LogScanTask(File logFile, SupportApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        this.logFile = logFile;
        this.monitor = new LogScanMonitor(logFile, System.currentTimeMillis());
        this.result = new LogScanResult();
    }

    @Override
    @Nonnull
    public LogScanMonitor getMonitor() {
        return this.monitor;
    }

    /*
     * Exception decompiling
     */
    @Override
    public LogScanResult call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class ScanResultVisitor
    implements MatchResultVisitor {
        private final TaskMonitor<?> monitor;
        private final LogScanResult result;

        private ScanResultVisitor(TaskMonitor<?> monitor, LogScanResult result) {
            this.monitor = monitor;
            this.result = result;
        }

        @Override
        public void patternMatched(String s, LogLine logLine, SisyphusPattern pattern) {
            this.result.add(pattern, logLine);
        }

        @Override
        public boolean isCancelled() {
            return this.monitor.isCancelled();
        }
    }

    private static class LogFileProgressMonitor
    implements FileProgressMonitor {
        private final SupportApplicationInfo applicationInfo;
        private final LogScanMonitor monitor;
        private long bytesProcessed;
        private long totalSize;

        private LogFileProgressMonitor(SupportApplicationInfo applicationInfo, LogScanMonitor monitor) {
            this.applicationInfo = applicationInfo;
            this.monitor = monitor;
        }

        @Override
        public void setTotalSize(long value) {
            this.totalSize = value;
        }

        @Override
        public void setProgress(long value) {
            this.bytesProcessed = value;
            this.monitor.updateProgress((int)Math.round(100.0 * (double)this.bytesProcessed / (double)this.totalSize), this.applicationInfo.getText("stp.hercules.scan.progress", new Serializable[]{this.monitor.getLogFile().getPath(), Long.valueOf(this.bytesProcessed / 1024L), Long.valueOf(this.totalSize / 1024L)}));
        }

        @Override
        public boolean isCancelled() {
            return this.monitor.isCancelled();
        }
    }
}

