/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.hercules;

import com.atlassian.mail.Email;
import com.atlassian.support.tools.hercules.HerculesTools;
import com.atlassian.support.tools.hercules.LogScanReportSettings;
import com.atlassian.support.tools.hercules.LogScanResult;
import com.atlassian.support.tools.hercules.LogScanTask;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.salext.mail.ProductAwareEmail;
import com.atlassian.support.tools.scheduler.utils.RenderingUtils;
import com.atlassian.support.tools.task.DefaultTaskMonitor;
import com.atlassian.support.tools.task.MonitoredCallable;
import com.atlassian.templaterenderer.RenderingException;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogScanReportTask
implements MonitoredCallable<Void, DefaultTaskMonitor<Void>> {
    private static final Logger log = LoggerFactory.getLogger(LogScanReportTask.class);
    private final SupportApplicationInfo info;
    private final MailUtility mailUtility;
    private final DefaultTaskMonitor<Void> monitor;
    private final LogScanReportSettings settings;

    public LogScanReportTask(SupportApplicationInfo info, MailUtility mailUtility, LogScanReportSettings settings) {
        this.info = info;
        this.mailUtility = mailUtility;
        this.monitor = new DefaultTaskMonitor();
        this.settings = settings;
    }

    @Override
    @Nonnull
    public DefaultTaskMonitor<Void> getMonitor() {
        return this.monitor;
    }

    @Override
    public Void call() throws Exception {
        List<ScanItem> applicationLogs = this.info.getApplicationLogFilePaths();
        if (applicationLogs == null || applicationLogs.size() == 0) {
            log.error("Couldn't find any application logs to scan, can't continue.");
            return null;
        }
        String logFilePath = applicationLogs.get(0).getPath();
        File primaryLog = new File(logFilePath);
        if (!primaryLog.exists()) {
            log.error("Log file '{}' doesn't exist, can't continue with the scan.", (Object)logFilePath);
            return null;
        }
        log.info("Scanning log file '{}'...", (Object)logFilePath);
        long start = System.currentTimeMillis();
        LogScanTask logScanTask = new LogScanTask(primaryLog, this.info);
        ListenableFutureTask subTask = ListenableFutureTask.create((Callable)logScanTask);
        logScanTask.getMonitor().init("scan-log-subtask", subTask);
        try {
            LogScanResult result = logScanTask.call();
            log.info("Finished scanning {} using Hercules. Total size: {} bytes. Time taken: {} ms. Patterns matched: {}", new Object[]{logFilePath, primaryLog.length(), System.currentTimeMillis() - start, result.size()});
            if (result.isEmpty()) {
                log.info("No issues found in log file '{}'. Not sending the report by email.", (Object)logFilePath);
                return null;
            }
            log.info("Preparing hercules report...");
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("info", this.info);
                params.put("fileName", FilenameUtils.getName((String)logFilePath));
                params.put("results", result.getMatches());
                params.put("warnings", this.monitor.getWarnings());
                params.put("errors", this.monitor.getErrors());
                params.put("herculesTools", new HerculesTools());
                String mailBody = RenderingUtils.render(this.info.getTemplateRenderer(), "/templates/email/hercules-report.vm", params);
                String recipients = this.settings.getRecipients();
                Email email = new ProductAwareEmail(recipients).addProductHeader(this.info.getApplicationName()).setFrom(this.info.getFromAddress()).setSubject(this.info.getText("stp.scheduler.hercules.mail.subject", new Serializable[]{DateFormatUtils.ISO_DATE_FORMAT.format(new Date())})).setBody(mailBody).setMimeType("text/html");
                log.info("Sending Hercules report...");
                this.mailUtility.sendMail(email);
            }
            catch (RenderingException e) {
                log.error("Error rendering Hercules report: ", (Throwable)e);
            }
            catch (IOException e) {
                log.error("I/O error while generating Hercules report: ", (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            log.error("Interrupted while waiting for Hercules scan to complete: ", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("Error generating Hercules report: ", e.getCause());
        }
        return null;
    }
}

