/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.cache;

import com.atlassian.support.tools.cache.CacheFactorySupplier;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheFactorySupplier
implements CacheFactorySupplier {
    private static final Logger log = LoggerFactory.getLogger(DefaultCacheFactorySupplier.class);
    private final ServiceTracker serviceTracker;

    public DefaultCacheFactorySupplier(BundleContext bundleContext) {
        ServiceTracker tracker = null;
        try {
            bundleContext.getBundle().loadClass("com.atlassian.cache.CacheSettingsBuilder");
            tracker = new ServiceTracker(bundleContext, "com.atlassian.cache.CacheFactory", null);
            tracker.open();
        }
        catch (ClassNotFoundException e) {
            log.debug("atlassian-cache 2.0 or higher is not available. Certain caching features will be disabled");
        }
        this.serviceTracker = tracker;
    }

    @Override
    public Object get() {
        return this.serviceTracker == null ? null : this.serviceTracker.getService();
    }

    public void destroy() {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
        }
    }
}

