/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.action;

import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.action.SupportToolsAction;
import com.atlassian.support.tools.servlet.SafeHttpServletRequest;
import java.util.Map;

public abstract class AbstractSupportToolsAction
implements SupportToolsAction {
    private final String category;
    private final String name;
    private final String templateError;
    private final String templateStart;
    private final String templateSuccess;
    private final String title;

    protected AbstractSupportToolsAction(String name, String category, String title) {
        this(name, category, title, null, null, null);
    }

    protected AbstractSupportToolsAction(String name, String category, String title, String templatePath) {
        this(name, category, title, templatePath, templatePath, templatePath);
    }

    protected AbstractSupportToolsAction(String name, String category, String title, String templateStart, String templateSuccess, String templateError) {
        this.category = category;
        this.name = name;
        this.templateError = this.getDefaultTemplatePath(templateError, "start");
        this.templateStart = this.getDefaultTemplatePath(templateStart, "start");
        this.templateSuccess = this.getDefaultTemplatePath(templateSuccess, "execute");
        this.title = title;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getSuccessTemplatePath() {
        return this.templateSuccess;
    }

    @Override
    public String getErrorTemplatePath() {
        return this.templateError;
    }

    @Override
    public String getStartTemplatePath() {
        return this.templateStart;
    }

    @Override
    public void prepare(Map<String, Object> context, SafeHttpServletRequest request, ValidationLog validationLog) {
    }

    @Override
    public void execute(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
    }

    @Override
    public void validate(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
    }

    private String getDefaultTemplatePath(String path, String suffix) {
        if (path != null) {
            return path;
        }
        return "templates/html/" + this.name + "-" + suffix + ".vm";
    }
}

