/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sisyphus;

import com.atlassian.sisyphus.SisyphusPattern;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public class SisyphusPatternPersister {
    private static final Logger log = Logger.getLogger(SisyphusPatternPersister.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePatternsOut(Writer out, Map<String, SisyphusPattern> patterns) throws IOException {
        XStream xstream = new XStream();
        xstream.alias("RegexEntry", SisyphusPattern.class);
        ObjectOutputStream xmlout = xstream.createObjectOutputStream(new BufferedWriter(out));
        try {
            for (SisyphusPattern pattern : patterns.values()) {
                xmlout.writeObject(pattern);
            }
        }
        finally {
            try {
                xmlout.close();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, SisyphusPattern> readPatternsIn(Reader reader) throws IOException, ClassNotFoundException {
        HashMap<String, SisyphusPattern> patterns = new HashMap<String, SisyphusPattern>();
        XStream xstream = new XStream();
        xstream.alias("RegexEntry", SisyphusPattern.class);
        ObjectInputStream xmlIn = xstream.createObjectInputStream(new BufferedReader(reader));
        try {
            while (true) {
                try {
                    while (true) {
                        SisyphusPattern pat = (SisyphusPattern)xmlIn.readObject();
                        pat.getRegex();
                        if (pat.isBrokenPattern()) {
                            log.info((Object)("INVALID PATTERN: '" + pat.getRegex() + " at " + pat.getURL()));
                            continue;
                        }
                        patterns.put(pat.getId(), pat);
                    }
                }
                catch (PatternSyntaxException syntaxExc) {
                    log.info((Object)syntaxExc);
                    continue;
                }
                catch (EOFException eof) {
                    try {
                        xmlIn.close();
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                xmlIn.close();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            throw throwable;
        }
        return patterns;
    }
}

