/**
 * Stickytable headers for confluence
 *
 * Adds stalking headers for viewpage and editor dependeds on a modified version of stalky headers
 * that allow extra options to be passed
 */
define("sticky-table-headers", [
    "ajs",
    "sticky-table-headers/viewpage",
    "sticky-table-headers/editor"
], function(
    AJS,
    StickyViewpage,
    StickyEditor
) {
    "use strict";

    return {
        initialize: function() {
            if (!AJS.DarkFeatures.isEnabled("confluence-table-enhancements.sticky-headers.disabled")) {
                // auto initialize for the viewpage
                AJS.toInit(StickyViewpage.initialize);
            }

            if (AJS.DarkFeatures.isEnabled("confluence-table-enhancements.sticky-headers-editor")) {
                // auto initialize for the editor
                AJS.bind("rte-ready", StickyEditor.initialize);

                // this is to make stickyheaders works with quick-edit
                AJS.bind("rte-quick-edit-push-state", StickyEditor.initialize);
                AJS.bind("rte-quick-edit-push-hash", StickyEditor.initialize);
            }
        }
    };
});

// auto start
require("sticky-table-headers").initialize();
