var RY = RY || {};

AJS.toInit(function($) {
    
    // set click handlers
    // remove default action, overwrite with our own
    $("#view-user-history-link").unbind("click");
    $("#view-user-history-link").click(function(e) {
        e.preventDefault();

        // setup dialog
        var dialog = new AJS.Dialog({
            width: 600, height: 500, id:"recently-viewed-dialog", closeOnOutsideClick: true
        });

        var $body = $(RY.Templates.body());

        dialog.addHeader(AJS.I18n.getText("com.atlassian.confluence.plugins.recently.viewed.title"));
        dialog.addPanel("SinglePanel", $body);
        dialog.addLink(AJS.I18n.getText("com.atlassian.confluence.plugins.recently.viewed.done"), function(dialog) {
            dialog.hide();
        });

        // show hint
        var $hint = $("<div>", {'class': "dialog-tip"}).text(AJS.I18n.getText("com.atlassian.confluence.plugins.recently.viewed.footer.hint"));
        dialog.popup.element.find(".dialog-button-panel").append($hint);

        // init backbone
        var collection = new RY.PageCollection();
        var collectionView = new RY.PageCollectionView({collection: collection});
        $body.find(".pages").html(collectionView.render().el);

        // show dialog
        dialog.gotoPanel(0);
        dialog.show();

        var spinner = $("#recently-viewed-dialog").spin('large');

        collection.fetch({
            success: function() {
                spinner.spinStop();

                // initialize filtering and navigation
                var navigationEvents = _.extend({}, Backbone.Events);
                var pageNavigator = new RY.PageNavigator(collectionView.$el, $body.parent(), navigationEvents);

                var filterView = new RY.FilterView({
                    collection: collection,
                    el: $body.find(".filter"),
                    navigationEvents: navigationEvents
                }).render();

                // trigger search to filter new models
                filterView.search();
            }
        });

        // trigger analytics
        RY.util.analytics.trackDialogOpen();
    });
});


