/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.code.config;

import com.atlassian.confluence.ext.code.config.NewcodeSettings;
import com.atlassian.confluence.ext.code.util.Constants;
import com.atlassian.confluence.setup.settings.SettingsManager;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Supplier;

public class NewcodeSettingsManager {
    private final SettingsManager settingsManager;
    private final Supplier<NewcodeSettings> currentSettings;

    public NewcodeSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
        this.currentSettings = () -> {
            Serializable settings = settingsManager.getPluginSettings(Constants.PLUGIN_KEY);
            NewcodeSettings result = new NewcodeSettings();
            if (settings != null && settings instanceof Map) {
                result.mapToSettings((Map)((Object)settings));
            }
            return result;
        };
    }

    public NewcodeSettings getCurrentSettings() {
        return this.currentSettings.get();
    }

    public void updateSettings(String theme, String language) {
        NewcodeSettings newSettings = new NewcodeSettings();
        newSettings.setDefaultTheme(theme);
        newSettings.setDefaultLanguage(language);
        this.settingsManager.updatePluginSettings(Constants.PLUGIN_KEY, (Serializable)((Object)newSettings.settingsToMap()));
    }
}

