/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.code.actions;

import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.ext.code.languages.Language;
import com.atlassian.confluence.ext.code.languages.LanguageRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class GetLanguagesAction
extends ConfluenceActionSupport
implements Beanable {
    private final LanguageRegistry languageRegistry;

    public GetLanguagesAction(LanguageRegistry languageRegistry) {
        this.languageRegistry = languageRegistry;
    }

    public Object getBean() {
        List<Language> languages = this.languageRegistry.listLanguages();
        Collections.sort(languages, new Comparator<Language>(){

            @Override
            public int compare(Language first, Language second) {
                return first.getFriendlyName().compareTo(second.getFriendlyName());
            }
        });
        return languages;
    }

    public String execute() throws Exception {
        return "success";
    }
}

