/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.cyberneko.html.parsers.SAXParser;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.scan.AbstractAntiSamyScanner;
import org.owasp.validator.html.scan.MagicSAXFilter;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class AntiSamySAXScanner
extends AbstractAntiSamyScanner {
    public AntiSamySAXScanner(Policy policy) {
        super(policy);
    }

    @Override
    public CleanResults getResults() {
        return null;
    }

    @Override
    public CleanResults scan(String html, String inputEncoding, String outputEncoding) throws ScanException {
        if (html == null) {
            throw new ScanException(new NullPointerException("Null input"));
        }
        int maxInputSize = this.policy.getMaxInputSize();
        if (maxInputSize < html.length()) {
            this.addError("error.size.toolarge", new Object[]{new Integer(html.length()), new Integer(maxInputSize)});
            throw new ScanException(this.errorMessages.get(0).toString());
        }
        MagicSAXFilter filter = new MagicSAXFilter(this.policy, this.messages);
        XMLDocumentFilter[] filters = new XMLDocumentFilter[]{filter};
        try {
            SAXParser parser = new SAXParser();
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
            parser.setFeature("http://cyberneko.org/html/features/scanner/cdata-sections", true);
            parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            Date start = new Date();
            SAXSource source = new SAXSource((XMLReader)parser, new InputSource(new StringReader(html)));
            StringWriter out = new StringWriter();
            StreamResult result = new StreamResult(out);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "html");
            transformer.transform(source, result);
            Date end = new Date();
            this.errorMessages = filter.getErrorMessages();
            return new CleanResults(start, end, out.getBuffer().toString(), null, this.errorMessages);
        }
        catch (Exception e) {
            throw new ScanException(e);
        }
    }
}

