var jiraIntegration = window.jiraIntegration || {};

jiraIntegration.transitionForm = (function($, _) {

    return {
        isRequired : function(issue, transition) {
            // On a transition, only the resolution can be required
            // Every other required field will already be set during issue creation.
            return transition.fields && _.some(transition.fields, jiraIntegration.fields.canRender);
        },
        $render : function(issue, transition, valuesByField, errors) {
            if (!$.fn.auiSelect2) {
                throw new Error('AUI version 5.2 or greater is required as this plugin needs the .auiSelect2() jQuery plugin.');
            }
            var errorsByField = {};
            var hasFieldErrors = false;
            _.each(errors && errors.errors || [], function(error) {
                hasFieldErrors = hasFieldErrors || error.context;
                var field = error.context || '__global__';
                errorsByField[field] = errorsByField[field] || [];
                errorsByField[field].push(error.message);
            });
            var hasGlobalErrors = !!errorsByField['__global__'];

            if (!hasGlobalErrors || hasFieldErrors) {
                // we need to maintain the order of the keys in the map as much as possible
                // JS doesn't guarantee that this is the correct order, but it tends to be.
                var sortedFields = transition.fields ? _.values(transition.fields) : [];
                _.each(sortedFields, function(field, i) {
                    field.fieldIndex = i;
                });
                // The caveat is that we want to move unrenderable fields to the end.
                sortedFields.sort(function(fieldA, fieldB) {
                    var canRenderA = jiraIntegration.fields.canRender(fieldA) ? 0 : 1;
                    var canRenderB = jiraIntegration.fields.canRender(fieldB) ? 0 : 1;
                    return (canRenderA - canRenderB) || (fieldA.fieldIndex - fieldB.fieldIndex);
                });

                var $transitionForm = $(jiraIntegration.templates._transitionForm.form({
                    errorTexts: errorsByField['__global__'],
                    transition: transition,
                    fieldContent: _.map(sortedFields,function (field) {
                        return jiraIntegration.fields.renderField(issue, field, valuesByField, errorsByField);
                    }).join('')
                }));
                jiraIntegration.fields.attachFieldBehaviors($transitionForm, {serverId: issue.applicationLinkId, projectKey: issue.fields.project.key}, issue);
                return $transitionForm;
            } else { // most likely case is that there's nothing we can do to salvage this. Link them to JIRA
                return $(jiraIntegration.templates._transitionForm.globalError({
                    errorTexts : errorsByField['__global__'],
                    actionText : AJS.I18n.getText('transition.in.jira', transition.name),
                    actionUrl : issue.url
                }));
            }
        },
        getJSON : function($form) {
            return _.reduce($form.find('input,select,textarea').not('.select2-input,.select2-focusser'), function(fields, fieldEl) {
                var $field = $(fieldEl);
                fields[$field.attr('name')] = jiraIntegration.fields.getJSON($field);
                return fields;
            }, {});
        }
    };
}(AJS.$, window._));