var jiraIntegration = window.jiraIntegration || {};
jiraIntegration.JiraCreateIssueForm = jiraIntegration.JiraCreateIssueForm || {};
jiraIntegration.JiraCreateIssueForm.FieldHelper = (function($, _) {
    function fillSelectData($select, data, autoSelectFirstItem) {
        var selectHTML = autoSelectFirstItem ? [] : [getDefaultOption($select)];
        $.each(data, function(index, data) {
            var option = {
                value : data.id,
                text: data.name,
                iconUrl: data.iconUrl ? data.iconUrl : (data.avatarUrls ? data.avatarUrls['16x16'] : '')
            };
            if (autoSelectFirstItem && index === 0) {
                option.selected = true;
            }
            selectHTML.push(aui.form.optionOrOptgroup(option));
        });

        $select.html(selectHTML.join(''));
        $select.auiSelect2("val", "");

    }

    function resetSelectField($select) {
        $select.html(getDefaultOption($select));
        $select.auiSelect2("val", "");
    }

    function getDefaultOption($field) {
        var text = $field.attr('data-placeholder');
        return aui.form.optionOrOptgroup({
            value : '',
            text: text,
            iconUrl: ''
        });
    }

    function hideField($field) {
        $field.parent().hide();
    }

    function showField($field) {
        $field.parent().show();
    }

    function setFieldDisabled($field, disabled) {
        disabled ? $field.disable() : $field.enable();
    }

    function setIsLoading($field, isLoading) {
        return isLoading ? $field.after(aui.icons.icon({icon: 'wait'})) : $field.next('.aui-icon.aui-icon-wait').remove();
    }

    return {
        fillSelectData: fillSelectData,
        resetSelectField: resetSelectField,
        hideField: hideField,
        showField: showField,
        setFieldDisabled: setFieldDisabled,
        setIsLoading: setIsLoading
    };
})(AJS.$, window._);
