
var jiraIntegration = window.jiraIntegration || {};
jiraIntegration.JiraCreateIssueForm = jiraIntegration.JiraCreateIssueForm || {};
jiraIntegration.JiraCreateIssueForm.Data = (function($) {
    var servers = {};
    var requiredFieldsMeta = {};
    var securedIconUrl = AJS.contextPath() + "/plugins/servlet/jira-integration/icons?serverId={0}&iconType={1}&{2}";
    var imagesCache = [];

    var getJSON = function(url, successCallback) {
        return $.ajax({
            dataType: "json",
            timeout: 0,
            url: url,
            success: successCallback
        });
    }

    function loadServers() {
        return getJSON(AJS.contextPath() + '/rest/jira-integration/1.0/servers', function(data) {
            if(data.length) {
                $.each(data, function(index, server) {
                    servers[server.id] = server;
                });
            }
        });
    }

    function loadProjects(serverId) {
        var projectData = (servers[serverId]) ? servers[serverId].projects : undefined;
        return projectData ? $.Deferred().resolve(projectData) :
            getJSON(AJS.contextPath() + '/rest/jira-integration/1.0/servers/'+ serverId +'/projects', function(data) {
                if(data.length) {
                    $.each(data, function(index, project) {
                        var issueTypes = _.filter(project.issuetypes, function(item) { // Do not allow to create a sub-task
                            return !item.subtask;
                        });
                        project.issueTypes = issueTypes;

                        var issueTypeIcons = [];
                        _.each(issueTypes, function(item) {
                            issueTypeIcons[item.id] = item.iconUrl;
                        });

                        var projectImagesCache = {
                            iconUrl: AJS.format(securedIconUrl, serverId, "project", project.avatarUrls['16x16'].split("/secure/projectavatar?")[1]),
                            issueTypes: issueTypeIcons
                        };
                        imagesCache[getCacheKey(serverId, project.id)] = projectImagesCache;
                    });
                    if (!servers[serverId]) {
                        servers[serverId] = {};
                    }
                    servers[serverId].projects = data;
                }
            });
    }

    function getIssueTypes(serverId, projectId) {
        var project = _.find(getProjects(serverId), function(project) {
           return project.id === projectId;
        });

        return project ? project.issueTypes : [];
    }

    function getFieldMetadata(context) {
        var cacheKey = getCacheKey(context.serverId, context.projectKey, context.issueType);

        if (!_.has(requiredFieldsMeta, cacheKey)) {
            return $.ajax({
                type : 'GET',
                timeout: 0,
                url : AJS.contextPath() + '/rest/jira-integration/1.0/servers/' + context.serverId + '/projects/' + context.projectKey + '/issue-types/' + context.issueType + '/fields-meta'
            }).pipe(function(data) {
                requiredFieldsMeta[cacheKey] = data;
                return requiredFieldsMeta[cacheKey];
            });
        } else {
            return $.Deferred().resolve(requiredFieldsMeta[cacheKey]);
        }
    }

    function getServerById(serverId) {
        return servers ? servers[serverId] : {};
    }

    function isIssueCreationSupported(serverId) {
        if (!servers || !servers[serverId]) {
            return false;
        }

        return (servers[serverId].isSupported != undefined) ? $.Deferred().resolve(servers[serverId].issueCreationSupported) :  // if we checked issue creation support once then don't check again
            $.ajax({
                type : 'GET',
                timeout: 0,
                url : AJS.contextPath() + '/rest/jira-integration/1.0/servers/' + serverId + '/features'
            }).pipe(function(data) {
                if (data != undefined) {
                    servers[serverId].issueCreationSupported = _.contains(data, 'CREATE_ISSUE');
                }
                return servers[serverId].issueCreationSupported;
            });
    }

    function getProjects(serverId) {
        return servers && servers[serverId] ? servers[serverId].projects : [];
    }

    function getProjectIconUrl(serverId, projectId) {
        var cacheKey = getCacheKey(serverId, projectId);
        return imagesCache[cacheKey] ? imagesCache[cacheKey].iconUrl : "";
    }

    function getIssueTypeIconUrl(serverId, projectId, issueTypeId) {
        var cacheKey = getCacheKey(serverId, projectId);
        var cache = imagesCache[cacheKey];
        return (cache && cache.issueTypes[issueTypeId]) ? cache.issueTypes[issueTypeId] : "";
    }

    function getCacheKey(serverId, projectId, issueTypeId) {
        return serverId + (projectId ? "-" + projectId : "") + (issueTypeId ? "-" + issueTypeId : "");
    }

    return {
        loadServers: loadServers,
        loadProjects: loadProjects,
        getIssueTypes: getIssueTypes,
        getFieldMetadata: getFieldMetadata,
        getServerById: getServerById,
        getProjectIconUrl: getProjectIconUrl,
        getIssueTypeIconUrl: getIssueTypeIconUrl,
        getProjects: getProjects,
        isIssueCreationSupported: isIssueCreationSupported
    };
})(AJS.$);

