var jiraIntegration = window.jiraIntegration || {};
jiraIntegration.fields = jiraIntegration.fields || {};

jiraIntegration.fields._labelPicker = function($) {
    var build = function($labelsField, getDataFunction) {
        $labelsField.auiSelect2({
            tags: true,
            multiple: true,
            tokenSeparators: [",", " "],
            createSearchChoice: function(term) {
                if (!term) {
                    return null;
                }
                return {
                    id: term,
                    text: term,
                    isNew: true
                };
            },
            query: function(query) {
                var onGetDataSuccess = function(datas) {
                    query.callback({results: datas});
                };
                getDataFunction(query.term).done(onGetDataSuccess);
            },
            formatResult: function(result) {
                return jiraIntegration.templates.fields.labelFieldResult({
                    label: {
                        labelName: result.text,
                        isNew: result.isNew
                    }
                });
            }
        });
    };

    return {
        build: build
    };
}(AJS.$);