/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.internal.integration.jira.rest;

import com.atlassian.integration.jira.JiraCommunicationException;
import com.atlassian.integration.jira.JiraMultipleCommunicationException;
import com.atlassian.internal.integration.jira.rest.RestErrorMessage;
import com.atlassian.internal.integration.jira.rest.RestErrors;
import com.atlassian.internal.integration.jira.rest.RestUtils;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class JiraMultipleCommunicationExceptionMapper
implements ExceptionMapper<JiraMultipleCommunicationException> {
    public Response toResponse(JiraMultipleCommunicationException multiException) {
        RestErrors errors = new RestErrors();
        for (JiraCommunicationException exception : multiException.getExceptions()) {
            errors.addError(JiraMultipleCommunicationExceptionMapper.buildRestErrorMessage(exception));
        }
        return RestUtils.serverError(errors).type("application/json;charset=UTF-8").build();
    }

    private static RestErrorMessage buildRestErrorMessage(JiraCommunicationException exception) {
        RestErrorMessage errorMessage = new RestErrorMessage(exception);
        errorMessage.put("applicationName", exception.getApplicationName());
        errorMessage.put("applicationUrl", exception.getApplicationUrl().toString());
        return errorMessage;
    }
}

