/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.internal.integration.jira.rest;

import com.atlassian.integration.jira.JiraAuthenticationRequiredException;
import com.atlassian.integration.jira.JiraMultipleAuthenticationException;
import com.atlassian.internal.integration.jira.rest.RestErrorMessage;
import com.atlassian.internal.integration.jira.rest.RestErrors;
import com.atlassian.internal.integration.jira.rest.RestUtils;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class JiraMultipleAuthenticationExceptionMapper
implements ExceptionMapper<JiraMultipleAuthenticationException> {
    public Response toResponse(JiraMultipleAuthenticationException multiException) {
        RestErrors errors = new RestErrors();
        for (JiraAuthenticationRequiredException exception : multiException) {
            errors.addError(JiraMultipleAuthenticationExceptionMapper.buildRestErrorMessage(exception));
        }
        return RestUtils.ok(errors).type("application/json;charset=UTF-8").build();
    }

    private static RestErrorMessage buildRestErrorMessage(JiraAuthenticationRequiredException exception) {
        RestErrorMessage errorMessage = new RestErrorMessage(exception);
        errorMessage.put("authenticationUri", exception.getAuthenticationUri().toString());
        errorMessage.put("applicationName", exception.getApplicationName());
        return errorMessage;
    }
}

