/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.internal.integration.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.applinks.api.auth.types.BasicAuthenticationProvider;
import com.atlassian.fugue.Either;
import com.atlassian.integration.jira.JiraAuthenticationRequiredException;
import com.atlassian.integration.jira.JiraCommunicationException;
import com.atlassian.integration.jira.JiraErrors;
import com.atlassian.integration.jira.JiraException;
import com.atlassian.integration.jira.JiraFeature;
import com.atlassian.integration.jira.JiraIssueUrlsRequest;
import com.atlassian.integration.jira.JiraIssuesRequest;
import com.atlassian.integration.jira.JiraKeyScanner;
import com.atlassian.integration.jira.JiraMultipleAuthenticationException;
import com.atlassian.integration.jira.JiraMultipleCommunicationException;
import com.atlassian.integration.jira.JiraValidationException;
import com.atlassian.integration.jira.applinks.LinkableEntityResolver;
import com.atlassian.internal.integration.jira.IconRequest;
import com.atlassian.internal.integration.jira.InternalJiraService;
import com.atlassian.internal.integration.jira.JiraConfig;
import com.atlassian.internal.integration.jira.autocomplete.AutoCompleteDataProvider;
import com.atlassian.internal.integration.jira.autocomplete.AutoCompleteDataProviderRegistry;
import com.atlassian.internal.integration.jira.autocomplete.AutoCompleteItem;
import com.atlassian.internal.integration.jira.autocomplete.RestAutoCompleteContext;
import com.atlassian.internal.integration.jira.util.JiraIconPathUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraService
implements InternalJiraService {
    private static final String EMPTY_JSON_OBJECT = "{}";
    private static final String EMPTY_LIST_JSON = "[]";
    private static final Function<String, String> ENCODE = new Function<String, String>(){

        public String apply(String input) {
            try {
                return URLEncoder.encode(input, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn("UTF-8 is an unsupported encoding: {}", (Object)e.getMessage());
                return input;
            }
        }
    };
    private static final String EXPAND_PARAMS = "&expand=renderedFields,transitions";
    private static final String FIELD_META_TYPES = "projects.issuetypes";
    private static final String FIELD_META_TYPES_FIELDS = "projects.issuetypes.fields";
    private static final String FIELD_TRANSITIONS = "transitions";
    private static final Set<String> ISSUE_FIELDS = ImmutableSet.of((Object)"assignee", (Object)"description", (Object)"issuetype", (Object)"priority", (Object)"project", (Object)"status", (Object[])new String[]{"summary", "transitions"});
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final long ISSUE_CREATION_SUPPORTED_BUILD_NUMBER = 710L;
    private static final String ISSUE_KEY_JQL_FORMAT = "issuekey+in+(%s)+ORDER+BY+issuekey";
    private static final String JSON_PATH_BUILD_NUMBER = "buildNumber";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String PARAM_SERVER_ID = "serverId";
    private static final String PARAM_ICON_TYPE = "iconType";
    private static final String REST_CREATE_ISSUE_BULK_PATH = "/rest/api/2/issue/bulk";
    private static final String REST_CREATE_ISSUE_PATH = "/rest/api/2/issue";
    private static final String REST_CREATEMETA_PATH = "/rest/api/2/issue/createmeta?";
    private static final String REST_JQL_PATH = "/rest/api/2/search?jql=";
    private static final String REST_SERVER_INFO_PATH = "/rest/api/2/serverInfo";
    private static final Set<String> SUMMARY_FIELDS = ImmutableSet.of((Object)"summary");
    private static final String VALIDATE_QUERY_FALSE = "&validateQuery=false";
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraService.class);
    private ApplicationLinkService applicationLinkService;
    private AutoCompleteDataProviderRegistry autoCompleteRegistry;
    private JiraConfig config;
    private EntityLinkService entityLinkService;
    private LinkableEntityResolver entityResolver;
    private I18nResolver i18nResolver;
    private JiraKeyScanner keyScanner;

    @Override
    @Nonnull
    public String createIssues(@Nonnull ApplicationId id, @Nonnull String jsonCreateIssueRequest) {
        JSONArray issuesJson;
        JSONObject issueJson;
        ApplicationLink jiraLink;
        block19: {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)jsonCreateIssueRequest, (Object)"jsonCreateIssueRequest")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank json request required");
            jiraLink = this.getJiraLink(id);
            issueJson = null;
            issuesJson = null;
            try {
                JSONObject rootObjectJson = new JSONObject(jsonCreateIssueRequest);
                Preconditions.checkArgument((boolean)rootObjectJson.has("issues"), (Object)"Missing key 'issues'");
                if (rootObjectJson.get("issues") instanceof JSONArray) {
                    issuesJson = rootObjectJson.getJSONArray("issues");
                    break block19;
                }
                if (rootObjectJson.get("issues") instanceof JSONObject) {
                    issueJson = rootObjectJson.getJSONObject("issues");
                    break block19;
                }
                throw new IllegalArgumentException("Invalid JSON input");
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Invalid JSON input");
            }
        }
        JSONArray issues = new JSONArray();
        JSONArray errors = new JSONArray();
        if (issuesJson != null) {
            Either<String, JiraErrors> bulkCreateResult = this.createIssues(id, issuesJson);
            if (bulkCreateResult.isLeft()) {
                return (String)bulkCreateResult.left().get();
            }
            int responseStatusCode = ((JiraErrors)bulkCreateResult.right().get()).getResponseCode();
            if (responseStatusCode != 404 && responseStatusCode != 405) {
                throw this.newCommunicationException(jiraLink);
            }
            try {
                for (int elementNumber = 0; elementNumber < issuesJson.length(); ++elementNumber) {
                    JSONObject loopingIssueJson = issuesJson.getJSONObject(elementNumber);
                    Either<String, JiraErrors> createResult = this.createIssue(id, loopingIssueJson);
                    if (createResult.isRight()) {
                        JSONObject error = new JSONObject();
                        error.put("elementErrors", this.getErrorJson((JiraErrors)createResult.right().get()));
                        error.put("failedElement", loopingIssueJson);
                        error.put("failedElementNumber", elementNumber);
                        errors.put(error);
                        continue;
                    }
                    JSONObject singleIssueCreateResult = new JSONObject((String)createResult.left().get());
                    JSONObject issue = new JSONObject();
                    issue.put("elementNumber", elementNumber);
                    issue.put("issue", singleIssueCreateResult);
                    issues.put(issue);
                }
            }
            catch (JSONException e) {
                throw this.newCommunicationException(jiraLink);
            }
        }
        Either<String, JiraErrors> createResult = this.createIssue(id, issueJson);
        if (createResult.isLeft()) {
            try {
                JSONObject issue = new JSONObject();
                issue.put("issue", new JSONObject((String)createResult.left().get()));
                issue.put("elementNumber", 0);
                issues.put(issue);
            }
            catch (JSONException e) {
                throw this.newCommunicationException(jiraLink);
            }
        }
        try {
            JSONObject errorJson = new JSONObject();
            errorJson.put("elementErrors", this.getErrorJson((JiraErrors)createResult.right().get()));
            errorJson.put("failedElement", issueJson);
            errorJson.put("failedElementNumber", 0);
            errors.put(errorJson);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Exception while rendering errors");
        }
        JSONObject result = new JSONObject();
        try {
            if (errors.length() > 0) {
                result.put("errors", errors);
            }
            result.put("issues", issues);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Exception while rendering errors");
        }
        return result.toString();
    }

    @Override
    public URI findIssue(@Nonnull String issueKey, String firstApplicationId) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)issueKey, (Object)"issueKey")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank issue key is required");
        List<ApplicationLink> jiraLinks = this.getJiraLinks(null);
        if (jiraLinks.isEmpty()) {
            return null;
        }
        if (jiraLinks.size() == 1) {
            return URI.create(this.buildIssueUrl(jiraLinks.get(0), issueKey));
        }
        ArrayList communicationExceptions = Lists.newArrayList();
        for (ApplicationLink jiraLink : jiraLinks) {
            if (firstApplicationId != null) {
                if (!jiraLink.getId().get().equals(firstApplicationId)) continue;
                firstApplicationId = null;
            }
            ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
            try {
                try {
                    Either<String, JiraErrors> issueResult = this.retrieveIssuesFromJira(Sets.newHashSet((Object[])new String[]{issueKey}), SUMMARY_FIELDS, false, jiraLink, requestFactory);
                    if (!this.foundIssue(issueResult)) continue;
                    return URI.create(this.buildIssueUrl(jiraLink, issueKey));
                }
                catch (CredentialsRequiredException e) {
                    throw this.newAuthenticationRequiredException(jiraLink, requestFactory);
                }
            }
            catch (JiraAuthenticationRequiredException e) {
                return e.getAuthenticationUri(URI.create(this.buildJumpUrl(issueKey, jiraLink)));
            }
            catch (JiraCommunicationException e) {
                communicationExceptions.add(this.newCommunicationException(jiraLink));
            }
            catch (ResponseException e) {
                log.warn("Problem communicating with JIRA: {}", (Object)e.getMessage());
                communicationExceptions.add(this.newCommunicationException(jiraLink, e.getMessage()));
            }
            catch (JSONException e) {
                log.warn("Problem parsing JSON response from JIRA: {}", (Object)e.getMessage());
                communicationExceptions.add(this.newCommunicationException(jiraLink, e.getMessage()));
            }
        }
        if (!communicationExceptions.isEmpty()) {
            throw this.newCommunicationException(communicationExceptions);
        }
        return null;
    }

    @Override
    @Nonnull
    public Collection<AutoCompleteItem> getAutoCompleteItems(final @Nonnull RestAutoCompleteContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context");
        ApplicationId id = new ApplicationId(context.getServerId());
        return this.communicateWithJira(id, new JiraRequestFunction<Collection<AutoCompleteItem>>(){

            @Override
            public Collection<AutoCompleteItem> apply(ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
                try {
                    return DefaultJiraService.this.getAutoCompleteItems(context, jiraLink, requestFactory);
                }
                catch (JSONException e) {
                    return Collections.emptyList();
                }
            }
        });
    }

    @Override
    @Nonnull
    public String getIssuesAsJson(@Nonnull JiraIssuesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        List<ApplicationLink> jiraLinks = this.getJiraLinks(request.getEntityKey());
        if (jiraLinks.isEmpty()) {
            log.debug("No application link with JIRA found");
            return EMPTY_LIST_JSON;
        }
        Set<Object> issueKeys = Sets.newLinkedHashSet((Iterable)Iterables.limit(request.getIssueKeys(), (int)this.config.getMaxIssues()));
        int minimum = request.hasMinimum() ? request.getMinimum() : issueKeys.size();
        ArrayList communicationExceptions = Lists.newArrayList();
        ArrayList authenticationExceptions = Lists.newArrayList();
        JSONArray response = new JSONArray();
        for (ApplicationLink jiraLink : jiraLinks) {
            ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
            try {
                boolean canTransition = jiraLink.createImpersonatingAuthenticatedRequestFactory() != null;
                Either<String, JiraErrors> responseResult = this.retrieveIssuesFromJira(issueKeys, request.getFields(), canTransition, jiraLink, requestFactory);
                if (responseResult.isRight()) {
                    Set<String> invalidKeys = this.extractInvalidKeys(((JiraErrors)responseResult.right().get()).errorMessages);
                    issueKeys.removeAll(invalidKeys);
                    if (issueKeys.size() > 0) {
                        responseResult = this.retrieveIssuesFromJira(issueKeys, request.getFields(), canTransition, jiraLink, requestFactory);
                        if (responseResult.isRight()) {
                            log.warn("The constructed JQL could not be parsed: {}", responseResult.right().get());
                        } else {
                            this.addToJsonArray(response, (String)responseResult.left().get(), jiraLink.getId(), canTransition);
                        }
                    }
                    issueKeys = invalidKeys;
                } else {
                    this.addToJsonArray(response, (String)responseResult.left().get(), jiraLink.getId(), canTransition);
                }
                if (response.length() < minimum) continue;
                break;
            }
            catch (CredentialsRequiredException e) {
                authenticationExceptions.add(this.newAuthenticationRequiredException(jiraLink, requestFactory));
            }
            catch (JiraCommunicationException e) {
                communicationExceptions.add(this.newCommunicationException(jiraLink));
            }
            catch (ResponseException e) {
                log.warn("Problem communicating with JIRA: {}", (Object)e.getMessage());
                communicationExceptions.add(this.newCommunicationException(jiraLink, e.getMessage()));
            }
        }
        if (response.length() == 0) {
            if (!authenticationExceptions.isEmpty()) {
                throw this.newAuthenticationException(authenticationExceptions);
            }
            if (!communicationExceptions.isEmpty()) {
                throw this.newCommunicationException(communicationExceptions);
            }
            log.debug("None of the requested issues were found on any linked JIRA server: {}", (Object)issueKeys);
        }
        return response.toString();
    }

    @Override
    @Nonnull
    public String getIssueTransitionsAsJson(final @Nonnull String issueKey, @Nonnull ApplicationId applicationId) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)issueKey, (Object)"issueKey")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank issue key is required");
        Preconditions.checkNotNull((Object)applicationId, (Object)"applicationId");
        return this.communicateWithJira(applicationId, new JiraRequestFunction<String>(){

            @Override
            public String apply(ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
                Either<String, JiraErrors> jsonOrErrors = DefaultJiraService.this.getTransitions(issueKey, jiraLink, requestFactory);
                if (jsonOrErrors.isRight()) {
                    log.warn("Available transitions could not be retrieved: {}", jsonOrErrors.right().get());
                    return "";
                }
                return (String)jsonOrErrors.left().get();
            }
        });
    }

    @Override
    @Nonnull
    public Map<String, String> getIssueUrls(@Nonnull JiraIssueUrlsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        List<ApplicationLink> jiraLinks = this.getJiraLinks(request.getEntityKey());
        if (jiraLinks.isEmpty()) {
            log.debug("No application link with JIRA found");
            return Collections.emptyMap();
        }
        Set<String> issueKeys = request.getIssueKeys();
        HashMap urls = Maps.newHashMapWithExpectedSize((int)issueKeys.size());
        if (jiraLinks.size() == 1) {
            ApplicationLink jira = jiraLinks.get(0);
            for (String issueKey : issueKeys) {
                urls.put(issueKey, this.buildIssueUrl(jira, issueKey));
            }
        } else {
            for (String issueKey : issueKeys) {
                urls.put(issueKey, this.buildJumpUrl(issueKey, null));
            }
        }
        return urls;
    }

    @Override
    @Nonnull
    public String getIssueTypeMetaAsJson(@Nonnull ApplicationId applicationId, final @Nonnull String project, final @Nonnull String issueType) {
        return this.communicateWithJira(applicationId, new JiraRequestFunction<String>(){

            @Override
            public String apply(ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
                ApplicationLinkRequest appLinkRequest = requestFactory.createRequest(Request.MethodType.GET, DefaultJiraService.this.getCreateMetaRestUrl(project, issueType));
                DefaultJiraService.this.config.configure(appLinkRequest);
                Either result = (Either)appLinkRequest.execute((ApplicationLinkResponseHandler)new JiraResponseHandler(requestFactory, jiraLink, null));
                if (result.isRight()) {
                    return ((JiraErrors)result.right().get()).toString();
                }
                try {
                    JsonNode node = OBJECT_MAPPER.readTree((String)result.left().get());
                    JsonNode filteredNode = node.path("projects").path(0).path("issuetypes").path(0);
                    if (filteredNode.isMissingNode()) {
                        return DefaultJiraService.EMPTY_JSON_OBJECT;
                    }
                    return filteredNode.toString();
                }
                catch (IOException e) {
                    log.error("Result retrieved from JiraResponseHandler, shouldn't contain error: {}", (Object)e.getMessage());
                    return DefaultJiraService.EMPTY_JSON_OBJECT;
                }
            }
        });
    }

    @Override
    @Nonnull
    public String getProjectsAsJson(@Nonnull ApplicationId applicationId) {
        Preconditions.checkNotNull((Object)applicationId, (Object)"applicationId");
        return this.communicateWithJira(applicationId, new JiraRequestFunction<String>(){

            @Override
            public String apply(ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
                ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, "/rest/api/2/issue/createmeta?projects.issuetypes");
                DefaultJiraService.this.config.configure(request);
                Either jsonOrErrors = (Either)request.execute((ApplicationLinkResponseHandler)new JiraResponseHandler(requestFactory, jiraLink, "projects"));
                if (jsonOrErrors.isRight()) {
                    return ((JiraErrors)jsonOrErrors.right().get()).toString();
                }
                return (String)jsonOrErrors.left().get();
            }
        });
    }

    @Override
    @Nonnull
    public String getServersAsJson() {
        List<ApplicationLink> appLinks = this.getJiraLinks(null);
        JSONArray serverArray = new JSONArray();
        if (appLinks != null) {
            for (ApplicationLink link : appLinks) {
                try {
                    JSONObject server = new JSONObject().put("id", link.getId().toString()).put("name", link.getName()).put("displayUrl", link.getDisplayUrl().toString()).put("rpcUrl", link.getRpcUrl().toString()).put("authenticated", this.isAuthenticated(link)).put("selected", link.isPrimary());
                    serverArray.put(server);
                }
                catch (JSONException e) {
                    log.error("Unexpected exception while rendering JSON object: {}", (Object)e.getMessage());
                }
            }
        }
        return serverArray.toString();
    }

    @Override
    @Nonnull
    public Set<JiraFeature> getSupportedFeatures(ApplicationId id) {
        Preconditions.checkNotNull((Object)id, (Object)"applicationId");
        return this.communicateWithJira(id, new JiraRequestFunction<Set<JiraFeature>>(){

            @Override
            public Set<JiraFeature> apply(ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
                ApplicationLinkRequest appLinkRequest = requestFactory.createRequest(Request.MethodType.GET, DefaultJiraService.REST_SERVER_INFO_PATH);
                DefaultJiraService.this.config.configure(appLinkRequest);
                JsonNode serverInfo = (JsonNode)appLinkRequest.execute((ApplicationLinkResponseHandler)new ServerInfoResponseHandler(jiraLink));
                if (serverInfo != null && serverInfo.path(DefaultJiraService.JSON_PATH_BUILD_NUMBER).getLongValue() >= 710L) {
                    return ImmutableSet.of((Object)((Object)JiraFeature.CREATE_ISSUE), (Object)((Object)JiraFeature.TRANSITION_ISSUE));
                }
                return ImmutableSet.of((Object)((Object)JiraFeature.TRANSITION_ISSUE));
            }
        });
    }

    @Override
    public boolean isLinked() {
        Iterable links = this.applicationLinkService.getApplicationLinks(JiraApplicationType.class);
        return links != null && !Iterables.isEmpty((Iterable)links);
    }

    @Override
    public void streamIcon(final @Nonnull IconRequest request, final @Nonnull HttpServletResponse response) {
        Preconditions.checkNotNull((Object)request.getServerId(), (Object)"applicationId");
        Preconditions.checkNotNull((Object)request.getIconType(), (Object)PARAM_ICON_TYPE);
        ApplicationId applicationId = new ApplicationId(request.getServerId());
        this.communicateWithJira(applicationId, new JiraRequestFunction<String>(){

            @Override
            public String apply(ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
                try {
                    ApplicationLinkRequest appLinkRequest = requestFactory.createRequest(Request.MethodType.GET, JiraIconPathUtils.getIconPath(request));
                    DefaultJiraService.this.config.configure(appLinkRequest);
                    appLinkRequest.execute((ApplicationLinkResponseHandler)new JiraImageResponseHandler(requestFactory, jiraLink, response));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Could not build JIRA icon path: {}", (Object)e.getMessage());
                }
                return null;
            }
        });
    }

    @Override
    @Nonnull
    public String transitionIssue(final @Nonnull String issueKey, final Set<String> fields, final @Nonnull ApplicationId applicationId, final @Nonnull String jsonTransitionRequest) {
        Preconditions.checkNotNull((Object)applicationId, (Object)"applicationId");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)issueKey, (Object)"issueKey")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank issue key is required");
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)jsonTransitionRequest, (Object)"jsonTransitionRequest")).trim().isEmpty() ? 1 : 0) != 0, (Object)"Non-blank JSON describing the transition to apply is required");
        log.debug("Attempting to transition {} with JSON: {}", (Object)issueKey, (Object)jsonTransitionRequest);
        return this.communicateWithJira(applicationId, new JiraRequestFunction<String>(){

            @Override
            public String apply(ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
                Either<String, JiraErrors> jsonOrErrors = DefaultJiraService.this.transitionIssueInJira(issueKey, jsonTransitionRequest, jiraLink, requestFactory);
                if (jsonOrErrors.isRight()) {
                    log.error("{} could not be transitioned: {}", (Object)issueKey, jsonOrErrors.right().get());
                    throw DefaultJiraService.this.newValidationException((JiraErrors)jsonOrErrors.right().get());
                }
                log.debug("Transition response for {}: {}", (Object)issueKey, jsonOrErrors.left().get());
                jsonOrErrors = DefaultJiraService.this.retrieveIssuesFromJira(Sets.newHashSet((Object[])new String[]{issueKey}), fields, true, jiraLink, requestFactory);
                if (jsonOrErrors.isRight()) {
                    log.error("Details for {} could not be retrieved after transitioning: {}", (Object)issueKey, jsonOrErrors.right().get());
                    throw DefaultJiraService.this.newValidationException((JiraErrors)jsonOrErrors.right().get());
                }
                try {
                    JSONArray issues = new JSONArray((String)jsonOrErrors.left().get());
                    if (issues.length() == 1) {
                        return DefaultJiraService.this.populateJsonIssue(issues.getJSONObject(0), applicationId, true).toString();
                    }
                }
                catch (JSONException e) {
                    log.error("Issue JSON could not be parsed. JSON due to {}:\n{}", (Object)e.getMessage(), jsonOrErrors.left().get());
                }
                return "";
            }
        });
    }

    public void setApplicationLinkService(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    public void setAutoCompleteRegistry(AutoCompleteDataProviderRegistry autoCompleteRegistry) {
        this.autoCompleteRegistry = autoCompleteRegistry;
    }

    public void setEntityLinkService(EntityLinkService entityLinkService) {
        this.entityLinkService = entityLinkService;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public void setJiraConfig(JiraConfig config) {
        this.config = config;
    }

    public void setJiraKeyScanner(JiraKeyScanner keyScanner) {
        this.keyScanner = keyScanner;
    }

    public void setLinkableEntityResolver(LinkableEntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Either<String, JiraErrors> retrieveIssuesFromJira(Set<String> issueKeys, Set<String> fields, boolean canTransition, ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
        UtilTimerStack.push((String)("Requesting details for " + issueKeys.size() + " issues from JIRA server: " + jiraLink.getName()));
        try {
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, this.formatJqlRequestUrl(issueKeys, fields, canTransition));
            this.config.configure(request);
            Either either = (Either)request.execute((ApplicationLinkResponseHandler)new JiraResponseHandler(requestFactory, jiraLink, "issues"));
            return either;
        }
        finally {
            UtilTimerStack.push((String)("Requesting details for " + issueKeys.size() + " issues from JIRA server: " + jiraLink.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Either<String, JiraErrors> transitionIssueInJira(String issueKey, String jsonTransitionRequest, ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
        UtilTimerStack.push((String)("Transitioning issue " + issueKey + " on JIRA server: " + jiraLink.getName()));
        try {
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.POST, this.formatTransitionRequestUrl(issueKey));
            this.config.configure(request);
            request.setHeader(HEADER_CONTENT_TYPE, "application/json");
            request.setRequestBody(jsonTransitionRequest);
            Either either = (Either)request.execute((ApplicationLinkResponseHandler)new JiraResponseHandler(requestFactory, jiraLink, null));
            return either;
        }
        finally {
            UtilTimerStack.pop((String)("Transitioning issue " + issueKey + " on JIRA server: " + jiraLink.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<AutoCompleteItem> getAutoCompleteItems(RestAutoCompleteContext context, ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException, JSONException {
        UtilTimerStack.push((String)("Get auto complete data for project " + context.getProjectKey() + " with issue type " + context.getIssueType() + " on JIRA server: " + jiraLink.getName()));
        try {
            AutoCompleteDataProvider autoCompleteDataProvider = this.autoCompleteRegistry.getProvider(context.getRestType());
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, autoCompleteDataProvider.getUrl(context));
            this.config.configure(request);
            Collection<AutoCompleteItem> collection = autoCompleteDataProvider.parseData(request.execute());
            return collection;
        }
        finally {
            UtilTimerStack.pop((String)("Get auto complete data for project " + context.getProjectKey() + " with issue type " + context.getIssueType() + " on JIRA server: " + jiraLink.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Either<String, JiraErrors> getTransitions(String issueKey, ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
        UtilTimerStack.push((String)("Requesting transitions for issue " + issueKey + " on JIRA server: " + jiraLink.getName()));
        try {
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, this.formatTransitionRequestUrl(issueKey, "transitions.fields"));
            this.config.configure(request);
            Either either = (Either)request.execute((ApplicationLinkResponseHandler)new JiraResponseHandler(requestFactory, jiraLink, FIELD_TRANSITIONS));
            return either;
        }
        finally {
            UtilTimerStack.pop((String)("Requesting transitions for issue " + issueKey + " on JIRA server: " + jiraLink.getName()));
        }
    }

    private void addToJsonArray(JSONArray aggregateArray, String additionalJson, ApplicationId applicationId, boolean canTransition) {
        try {
            JSONArray additionalArray = new JSONArray(additionalJson);
            for (int i = 0; i < additionalArray.length(); ++i) {
                aggregateArray.put(this.populateJsonIssue(additionalArray.getJSONObject(i), applicationId, canTransition));
            }
        }
        catch (JSONException e) {
            log.error("Invalid JSON returned due to {}:\n{}", (Object)e.getMessage(), (Object)additionalJson);
        }
    }

    private String buildIssueUrl(ApplicationId applicationId, String issueKey) {
        ApplicationLink applicationLink = this.getJiraLink(applicationId);
        if (applicationLink == null) {
            throw new RuntimeException("Application link " + applicationId.toString() + " not found");
        }
        return this.buildIssueUrl(applicationLink, issueKey);
    }

    private String buildIssueUrl(ApplicationLink applicationLink, String issueKey) {
        return applicationLink.getDisplayUrl() + "/browse/" + issueKey;
    }

    private String buildJumpUrl(String issueKey, ApplicationLink nextLink) {
        StringBuilder builder = new StringBuilder(this.config.getBaseUrl()).append("/plugins/servlet/jira-integration/issues/").append((String)ENCODE.apply((Object)issueKey));
        if (nextLink != null) {
            builder.append("?").append("nextApplicationId").append("=").append(nextLink.getId());
        }
        return builder.toString();
    }

    private <T> T communicateWithJira(ApplicationId applicationId, JiraRequestFunction<T> makeRequest) {
        ApplicationLink jiraLink = this.getJiraLink(applicationId);
        if (jiraLink == null) {
            throw new NoSuchElementException("Application link " + applicationId.toString() + " not found");
        }
        ApplicationLinkRequestFactory requestFactory = jiraLink.createImpersonatingAuthenticatedRequestFactory();
        if (requestFactory == null && this.config.isBasicAuthenticationAllowed()) {
            requestFactory = jiraLink.createAuthenticatedRequestFactory(BasicAuthenticationProvider.class);
        }
        try {
            return makeRequest.apply(jiraLink, requestFactory);
        }
        catch (CredentialsRequiredException e) {
            throw this.newAuthenticationRequiredException(jiraLink, requestFactory);
        }
        catch (ResponseException e) {
            log.warn("Problem communicating with JIRA: {}", (Object)e.getMessage());
            throw this.newCommunicationException(jiraLink);
        }
    }

    @Nonnull
    private Either<String, JiraErrors> createBulkIssues(@Nonnull ApplicationId id, @Nonnull JSONArray inputJson) {
        final JSONObject bulkRequestJson = new JSONObject();
        try {
            bulkRequestJson.put("issueUpdates", inputJson);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Exception while procssing JSONObject");
        }
        return this.communicateWithJira(id, new JiraRequestFunction<Either<String, JiraErrors>>(){

            @Override
            public Either<String, JiraErrors> apply(final ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
                ApplicationLinkRequest applicationLinkRequest = (ApplicationLinkRequest)((ApplicationLinkRequest)requestFactory.createRequest(Request.MethodType.POST, DefaultJiraService.REST_CREATE_ISSUE_BULK_PATH).setHeader(DefaultJiraService.HEADER_CONTENT_TYPE, "application/json")).setRequestBody(bulkRequestJson.toString());
                DefaultJiraService.this.config.configure(applicationLinkRequest);
                return (Either)applicationLinkRequest.execute((ApplicationLinkResponseHandler)new JiraResponseHandler(requestFactory, jiraLink, null){

                    @Override
                    Either<String, JiraErrors> filter(Response response, String responseString) throws IOException {
                        try {
                            JiraErrors errors = DefaultJiraService.this.getErrorFromBulkCreation(response, responseString, jiraLink);
                            if (errors.hasErrors()) {
                                return Either.right((Object)errors);
                            }
                        }
                        catch (JSONException e) {
                            throw DefaultJiraService.this.newCommunicationException(jiraLink);
                        }
                        return Either.left((Object)responseString);
                    }
                });
            }
        });
    }

    @Nonnull
    private Either<String, JiraErrors> createIssue(@Nonnull ApplicationId id, final @Nonnull JSONObject inputJson) {
        return this.communicateWithJira(id, new JiraRequestFunction<Either<String, JiraErrors>>(){

            @Override
            public Either<String, JiraErrors> apply(ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) throws CredentialsRequiredException, ResponseException {
                ApplicationLinkRequest applicationLinkRequest = (ApplicationLinkRequest)((ApplicationLinkRequest)requestFactory.createRequest(Request.MethodType.POST, DefaultJiraService.REST_CREATE_ISSUE_PATH).setHeader(DefaultJiraService.HEADER_CONTENT_TYPE, "application/json")).setRequestBody(inputJson.toString());
                DefaultJiraService.this.config.configure(applicationLinkRequest);
                return (Either)applicationLinkRequest.execute((ApplicationLinkResponseHandler)new JiraResponseHandler(requestFactory, jiraLink, null));
            }
        });
    }

    @Nonnull
    private Either<String, JiraErrors> createIssues(@Nonnull ApplicationId id, @Nonnull JSONArray inputJson) {
        ArrayList issuesJson = Lists.newArrayList();
        ArrayList errorsJson = Lists.newArrayList();
        int bulkCount = inputJson.length();
        ArrayList bulkIssues = Lists.newArrayListWithCapacity((int)bulkCount);
        for (int i = 0; i < bulkCount; ++i) {
            try {
                bulkIssues.add(inputJson.getJSONObject(i));
                continue;
            }
            catch (JSONException e) {
                throw new IllegalStateException("Exception while processing JSONObject");
            }
        }
        int currentStartIndex = 0;
        for (List partition : Lists.partition((List)bulkIssues, (int)this.config.getMaxBulkIssues())) {
            JSONArray bulkJson = new JSONArray(partition);
            Either<String, JiraErrors> bulkCreateResult = this.createBulkIssues(id, bulkJson);
            if (bulkCreateResult.isRight()) {
                return bulkCreateResult;
            }
            try {
                JSONObject responseJson = new JSONObject((String)bulkCreateResult.left().get());
                JSONArray issuesNode = responseJson.getJSONArray("issues");
                for (int issueIndex = 0; issueIndex < issuesNode.length(); ++issueIndex) {
                    JSONObject issue = new JSONObject();
                    JSONObject issueNode = issuesNode.getJSONObject(issueIndex);
                    issue.put("issue", issueNode);
                    issue.put("elementNumber", issueIndex + currentStartIndex);
                    issuesJson.add(issue);
                }
                JSONArray errorsNode = responseJson.getJSONArray("errors");
                for (int errorIndex = 0; errorIndex < errorsNode.length(); ++errorIndex) {
                    JSONObject errorNode = errorsNode.getJSONObject(errorIndex);
                    int failedElementNumber = errorNode.getInt("failedElementNumber") + currentStartIndex;
                    JSONObject error = new JSONObject();
                    error.put("elementErrors", errorNode.get("elementErrors"));
                    error.put("failedElementNumber", failedElementNumber);
                    error.put("failedElement", inputJson.get(failedElementNumber));
                    errorsJson.add(error);
                }
                currentStartIndex += partition.size();
            }
            catch (JSONException e) {
                throw new IllegalStateException("Exception while processing JSONObject");
            }
        }
        JSONObject wrapperJson = new JSONObject();
        try {
            wrapperJson.put("issues", issuesJson);
            if (!errorsJson.isEmpty()) {
                wrapperJson.put("errors", errorsJson);
            }
            return Either.left((Object)wrapperJson.toString());
        }
        catch (JSONException e) {
            throw new IllegalStateException("Exception while processing JSONObject");
        }
    }

    private List<String> encodeAll(Iterable<String> inputs) {
        return Lists.newArrayList((Iterable)Iterables.transform(inputs, ENCODE));
    }

    private Set<String> extractInvalidKeys(List<String> errorMessages) {
        LinkedHashSet invalidKeys = Sets.newLinkedHashSet();
        for (String errorMessage : errorMessages) {
            for (String jiraKey : this.keyScanner.findAll(errorMessage)) {
                invalidKeys.add(jiraKey);
            }
        }
        return invalidKeys;
    }

    private String formatJqlRequestUrl(Set<String> issueKeys, Set<String> fields, boolean canTransition) {
        List<String> fieldList = this.encodeAll((Iterable)Objects.firstNonNull(fields, ISSUE_FIELDS));
        if (!canTransition && fieldList.contains(FIELD_TRANSITIONS)) {
            fieldList.remove(FIELD_TRANSITIONS);
        }
        return REST_JQL_PATH + String.format(ISSUE_KEY_JQL_FORMAT, StringUtils.join(this.encodeAll(issueKeys), (String)",")) + "&fields=" + StringUtils.join(fieldList, (String)",") + EXPAND_PARAMS + VALIDATE_QUERY_FALSE;
    }

    private String formatTransitionRequestUrl(String issueKey) {
        return this.formatTransitionRequestUrl(issueKey, null);
    }

    private String formatTransitionRequestUrl(String issueKey, String expand) {
        StringBuilder builder = new StringBuilder("/rest/api/2/issue/").append((String)ENCODE.apply((Object)issueKey)).append("/transitions");
        if (expand != null) {
            builder.append("?expand=").append(expand);
        }
        return builder.toString();
    }

    private boolean foundIssue(Either<String, JiraErrors> issueResult) throws JSONException {
        return issueResult.isLeft() && new JSONArray((String)issueResult.left().get()).length() > 0;
    }

    private String getCreateMetaRestUrl(String project, String issueType) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)REST_CREATEMETA_PATH);
        uriBuilder.queryParam("expand", new Object[]{FIELD_META_TYPES_FIELDS});
        if (StringUtils.isNumeric((String)project)) {
            uriBuilder.queryParam("projectIds", new Object[]{project});
        } else {
            uriBuilder.queryParam("projectKeys", new Object[]{project});
        }
        if (StringUtils.isNumeric((String)issueType)) {
            uriBuilder.queryParam("issuetypeIds", new Object[]{issueType});
        } else {
            uriBuilder.queryParam("issuetypeNames", new Object[]{issueType});
        }
        return uriBuilder.build(new Object[0]).toString();
    }

    private ApplicationLink getJiraLink(ApplicationId id) {
        try {
            return this.applicationLinkService.getApplicationLink(id);
        }
        catch (TypeNotInstalledException e) {
            log.error("The type of application referred to by " + id + " is no longer installed on this server: {}", (Object)e.getMessage());
            throw new TypeNotPresentException(e.getType(), e);
        }
    }

    private List<ApplicationLink> getJiraLinks(String entityKey) {
        Object entityObject;
        ArrayList jiraLinks = Lists.newArrayList();
        if (this.entityResolver != null && StringUtils.isNotBlank((String)entityKey) && (entityObject = this.entityResolver.resolve(entityKey)) != null) {
            Iterable entityLinks = this.entityLinkService.getEntityLinks(entityObject, JiraProjectEntityType.class);
            for (EntityLink entityLink : entityLinks) {
                ApplicationLink link = entityLink.getApplicationLink();
                if (jiraLinks.contains(link)) continue;
                jiraLinks.add(link);
            }
        }
        for (ApplicationLink link : this.applicationLinkService.getApplicationLinks(JiraApplicationType.class)) {
            if (jiraLinks.contains(link)) continue;
            jiraLinks.add(link);
        }
        return jiraLinks;
    }

    private JiraErrors getErrorFromBulkCreation(Response response, String responseString, ApplicationLink jiraLink) throws JSONException {
        JiraErrors errors = new JiraErrors();
        if (response.getStatusCode() == 404 || response.getStatusCode() == 405) {
            errors.setResponseCode(response.getStatusCode());
            String error = "Bulk issue creation is not supported on (" + jiraLink.getName() + ")";
            errors.addError(error);
            log.warn(error);
            return errors;
        }
        JSONObject responseJson = new JSONObject(responseString);
        if (!responseJson.has("issues")) {
            if (responseJson.has("errors")) {
                JSONObject errorsNode = responseJson.getJSONObject("errors");
                Iterator errorKeys = errorsNode.keys();
                while (errorKeys.hasNext()) {
                    String key = (String)errorKeys.next();
                    errors.addError(key, errorsNode.getString(key));
                }
            }
            if (responseJson.has("errorMessages")) {
                JSONArray errorMessagesNode = responseJson.getJSONArray("errorMessages");
                for (int errorMessageIndex = 0; errorMessageIndex < errorMessagesNode.length(); ++errorMessageIndex) {
                    errors.addError(errorMessagesNode.getString(errorMessageIndex));
                }
            }
        }
        return errors;
    }

    private JSONObject getErrorJson(JiraErrors errors) {
        JSONObject error = new JSONObject();
        try {
            error.put("errorMessages", errors.errorMessages);
            error.put("errors", errors.errors);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Exception while rendering Error object");
        }
        return error;
    }

    private boolean isAuthenticated(ApplicationLink link) {
        try {
            ApplicationLinkRequest applicationLinkRequest = link.createAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, link.getRpcUrl().toString());
        }
        catch (CredentialsRequiredException ignored) {
            return false;
        }
        return true;
    }

    private JiraException newAuthenticationException(List<JiraAuthenticationRequiredException> exceptions) {
        if (exceptions.size() == 1) {
            return exceptions.get(0);
        }
        return new JiraMultipleAuthenticationException(this.i18nResolver.getText("multiple.authentication.problems"), exceptions);
    }

    private JiraAuthenticationRequiredException newAuthenticationRequiredException(ApplicationLink jiraLink, ApplicationLinkRequestFactory requestFactory) {
        return new JiraAuthenticationRequiredException(this.i18nResolver.getText("authentication.required"), jiraLink.getName(), (AuthorisationURIGenerator)requestFactory);
    }

    private JiraCommunicationException newCommunicationException(ApplicationLink jiraLink) {
        return this.newCommunicationException(jiraLink, null);
    }

    private JiraCommunicationException newCommunicationException(ApplicationLink jiraLink, String cause) {
        return new JiraCommunicationException(StringUtils.isEmpty((String)cause) ? this.i18nResolver.getText("communication.cause.generic") : cause, jiraLink.getName(), jiraLink.getDisplayUrl());
    }

    private JiraException newCommunicationException(List<JiraCommunicationException> exceptions) {
        if (exceptions.size() == 1) {
            return exceptions.get(0);
        }
        return new JiraMultipleCommunicationException(this.i18nResolver.getText("multiple.communication.problems"), exceptions);
    }

    private JiraValidationException newValidationException(JiraErrors errors) {
        return new JiraValidationException(errors);
    }

    private JSONObject populateJsonIssue(JSONObject issue, ApplicationId applicationId, boolean canTransition) throws JSONException {
        issue.put("applicationLinkId", applicationId);
        issue.put("url", this.buildIssueUrl(applicationId, issue.getString("key")));
        issue.put("canTransition", canTransition);
        return issue;
    }

    private class ServerInfoResponseHandler
    implements ApplicationLinkResponseHandler<JsonNode> {
        private final ApplicationLink jiraLink;

        private ServerInfoResponseHandler(ApplicationLink jiraLink) {
            this.jiraLink = jiraLink;
        }

        public JsonNode credentialsRequired(Response response) {
            throw DefaultJiraService.this.newCommunicationException(this.jiraLink);
        }

        public JsonNode handle(Response response) throws ResponseException {
            try {
                return OBJECT_MAPPER.readTree(response.getResponseBodyAsStream());
            }
            catch (IOException e) {
                log.warn("Could not parse JIRA server's information: {}", (Object)e.getMessage());
                return null;
            }
        }
    }

    private class JiraImageResponseHandler
    implements ApplicationLinkResponseHandler<Either<String, JiraErrors>> {
        private final ApplicationLink jiraLink;
        private final ApplicationLinkRequestFactory requestFactory;
        private final HttpServletResponse httpResponse;

        private JiraImageResponseHandler(ApplicationLinkRequestFactory requestFactory, ApplicationLink jiraLink, HttpServletResponse httpResponse) {
            this.jiraLink = jiraLink;
            this.requestFactory = requestFactory;
            this.httpResponse = httpResponse;
        }

        public Either<String, JiraErrors> credentialsRequired(Response response) {
            throw DefaultJiraService.this.newCommunicationException(this.jiraLink);
        }

        public Either<String, JiraErrors> handle(Response response) {
            try {
                if (response.getStatusCode() == 204) {
                    throw DefaultJiraService.this.newCommunicationException(this.jiraLink);
                }
                InputStream inputStream = response.getResponseBodyAsStream();
                this.httpResponse.setContentType(response.getHeader(DefaultJiraService.HEADER_CONTENT_TYPE));
                this.httpResponse.setHeader(DefaultJiraService.HEADER_CACHE_CONTROL, response.getHeader(DefaultJiraService.HEADER_CACHE_CONTROL));
                ServletOutputStream outputStream = this.httpResponse.getOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                return Either.left((Object)"");
            }
            catch (Exception e) {
                log.warn("Could not get image from JIRA: {}", (Object)e.getMessage());
                log.debug("Could not get image from JIRA", (Throwable)e);
                throw DefaultJiraService.this.newCommunicationException(this.jiraLink);
            }
        }
    }

    class JiraResponseHandler
    implements ApplicationLinkResponseHandler<Either<String, JiraErrors>> {
        private final ApplicationLink jiraLink;
        private final String property;
        private final ApplicationLinkRequestFactory requestFactory;

        private JiraResponseHandler(ApplicationLinkRequestFactory requestFactory, ApplicationLink jiraLink, String property) {
            this.jiraLink = jiraLink;
            this.property = property;
            this.requestFactory = requestFactory;
        }

        public Either<String, JiraErrors> credentialsRequired(Response response) {
            throw DefaultJiraService.this.newAuthenticationRequiredException(this.jiraLink, this.requestFactory);
        }

        public Either<String, JiraErrors> handle(Response response) {
            try {
                InputStream responseStream = response.getResponseBodyAsStream();
                if (response.getStatusCode() == 204) {
                    log.debug("JIRA says: 204");
                    return Either.left((Object)"");
                }
                String responseString = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
                log.debug("JIRA says: " + response.getStatusCode() + ": " + responseString);
                return this.filter(response, responseString);
            }
            catch (IOException e) {
                log.warn("Problem communicating with JIRA: {}", (Object)e.getMessage());
                throw DefaultJiraService.this.newCommunicationException(this.jiraLink);
            }
            catch (ResponseException e) {
                log.warn("Problem communicating with JIRA: {}", (Object)e.getMessage());
                throw DefaultJiraService.this.newCommunicationException(this.jiraLink);
            }
        }

        Either<String, JiraErrors> filter(Response response, String responseString) throws IOException {
            Map o = (Map)OBJECT_MAPPER.reader(Map.class).readValue(responseString);
            JiraErrors errors = new JiraErrors();
            errors.setResponseCode(response.getStatusCode());
            if (o.containsKey("errorMessages")) {
                errors.addAllErrors((List)o.get("errorMessages"));
            }
            if (o.containsKey("errors")) {
                errors.addAllErrors((Map)o.get("errors"));
            }
            if (errors.hasErrors()) {
                return Either.right((Object)errors);
            }
            StringWriter writer = new StringWriter();
            OBJECT_MAPPER.writeValue((Writer)writer, (Object)(this.property == null ? o : o.get(this.property)));
            return Either.left((Object)writer.toString());
        }
    }

    private static interface JiraRequestFunction<T> {
        public T apply(ApplicationLink var1, ApplicationLinkRequestFactory var2) throws CredentialsRequiredException, ResponseException;
    }
}

