/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.outgoing;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.jml.MsnProtocol;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.util.DigestUtils;
import net.sf.jml.util.NumberUtils;

public class OutgoingQRY
extends MsnOutgoingMessage {
    private static final String PRODUCT_ID = "msmsgs@msnmsgr.com";
    private static final String PRODUCT_KEY = "Q1P7W2E4J9R8U3S5";
    private static final String MSNP11_PRODUCT_ID = "PROD0090YUAUV{2B";
    private static final String MSNP11_PRODUCT_KEY = "YMM8C_H7KCQ2S_KL";
    private static final long MSNP11_MAGIC_NUM = 242854337L;

    public OutgoingQRY(MsnProtocol msnProtocol) {
        super(msnProtocol);
        this.setCommand("QRY");
        this.addParam(this.getProductId());
    }

    protected boolean isSupportChunkData() {
        return true;
    }

    public String getProductId() {
        if (this.protocol.before(MsnProtocol.MSNP11)) {
            return PRODUCT_ID;
        }
        return MSNP11_PRODUCT_ID;
    }

    public void setDigestNum(String string) {
        this.setChunkData(this.calc(string));
    }

    private String calc(String string) {
        if (this.protocol.before(MsnProtocol.MSNP11)) {
            return DigestUtils.md5(string + PRODUCT_KEY);
        }
        byte[] byArray = DigestUtils.md5((string + MSNP11_PRODUCT_KEY).getBytes());
        int[] nArray = this.getMd5Ints(byArray);
        int[] nArray2 = this.getChlInts(string + MSNP11_PRODUCT_ID);
        long l = this.getKey(nArray, nArray2);
        return this.getChallenge(l, byArray);
    }

    private int[] getMd5Ints(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        int[] nArray = new int[4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byteBuffer.getInt() & Integer.MAX_VALUE;
        }
        return nArray;
    }

    private int[] getChlInts(String string) {
        byte[] byArray = string.getBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.ceil((double)byArray.length / 8.0) * 8).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray);
        while (byteBuffer.hasRemaining()) {
            byteBuffer.put((byte)48);
        }
        byteBuffer.flip();
        int[] nArray = new int[byteBuffer.remaining() / 4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        return nArray;
    }

    private long getKey(int[] nArray, int[] nArray2) {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < nArray2.length; i += 2) {
            long l3 = (long)nArray2[i] * 242854337L % Integer.MAX_VALUE + l;
            l3 = (l3 * (long)nArray[0] + (long)nArray[1]) % Integer.MAX_VALUE;
            l = ((long)nArray2[i + 1] + l3) % Integer.MAX_VALUE;
            l = ((long)nArray[2] * l + (long)nArray[3]) % Integer.MAX_VALUE;
            l2 = l2 + l + l3;
        }
        l = (l + (long)nArray[1]) % Integer.MAX_VALUE;
        l2 = (l2 + (long)nArray[3]) % Integer.MAX_VALUE;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt((int)l);
        byteBuffer.putInt((int)l2);
        byteBuffer.flip();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer.getLong();
    }

    private String getChallenge(long l, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        String string = NumberUtils.toHexValue(byteBuffer.getLong() ^ l);
        String string2 = NumberUtils.toHexValue(byteBuffer.getLong() ^ l);
        return string + string2;
    }
}

