AJS.toInit(function ($)
{
    var searchField = $("#gadget-search-query");
    
    AJS.Gadget({
        baseUrl: contextPath,
        useOauth: "/rest/gadget/1.0/currentUser",
        view: {
            enableReload: true,
            onResizeAdjustHeight: true,
            template: function(args) {
                var gadget = this;
                var bodyHeight;
                // Allows you to do things like mystring.getHostname();
                String.prototype.getHostname = function() {
                    var re = new RegExp('^(?:f|ht)tp(?:s)?\://([^/]+)', 'im');
                    return this.match(re)[0].toString();
                };
                var hostname = contextPath.getHostname();
                var searchI18N = gadget.getMsg("gadget.quicknav.search");

                var focusSearch = function() {
                    if (searchField.val() === searchI18N) {
                        searchField.val("").addClass("focused");
                    }
                };
                var blurSearch = function() {
                    if (searchField.val() === "") {
                        searchField.removeClass("focused").val(searchI18N);
                    }
                };
                var keydownSearch = function(e) {
                    if (e.which == 13) {
                        var lastEntry = AJS.$(".aui-dropdown .last a");
                        if (lastEntry.length > 0) {
                            top.window.location = lastEntry.attr("href");
                        }
                    }
                    return true;
                };
                var returnToBaseHeight = function() {
                    gadgets.window.adjustHeight(bodyHeight);
                };
                var ajsDropDownOptions = {
                    selectionHandler: function (e, selected) {
                        if (selected) {
                            if (selected.get(0).nodeName.toLowerCase() !== "a") {
                                top.window.location = selected.find("a").attr("href");
                            }
                            else {
                                top.window.location = selected.attr("href");
                            }
                            e.preventDefault();
                        }
                    },
                    escapeHandler: function () {
                        this.hide("escape");
                        returnToBaseHeight();
                        return false;
                    },
                    hideHandler: returnToBaseHeight
                };
                var options = {
                    ajsDropDownOptions: ajsDropDownOptions,
                    dropdownPlacement: function (dropDown) {
                        $("form .quick-nav-drop-down").append(dropDown);
                    }
                };

                var onShow = function() {
                    $("a", this.$).each(function() {
                        var link = $(this).attr("href");
                        $(this).attr("target", "_parent").attr("href", hostname + link);
                    });
                    $("img", this.$).each(function() {
                        var link = $(this).attr("src");
                        $(this).attr("src", hostname + link);
                    });
                    $("div.aui-shadow").remove();
                    $(".dropdown-shim").remove();

                    var newHeight = bodyHeight;

                    // drop-down has top 3px in CSS
                    newHeight += 3;

                    // drop-down height
                    newHeight += this.$.height();

                    // top & bottom padding
                    newHeight += parseInt(this.$.css("padding-bottom"), 10) + parseInt(this.$.css("padding-top"),10);

                    gadgets.window.adjustHeight(newHeight);
                };

                gadget.getView().append($("#gadget-search").remove());
                $("#gadget-search").show();
                $("#quickSearchPlaceholder").attr("value", searchI18N);

                searchField.attr("value", searchI18N);
                searchField.focus(focusSearch);
                searchField.blur(blurSearch);
                searchField.keydown(keydownSearch);
                searchField.quicksearch("/rest/quicknav/1/search", onShow, options);
                $("#inline-dialog-shadow").remove();
                $("#inline-dialog-shim").remove();

                bodyHeight = $(".gadget").height();
                // add height of the padlock button if it is visible
                if ($(".footer button.oauth").length == 1)
                {
                    bodyHeight += $(".footer").height();
                }

                $(document).click(returnToBaseHeight);
                // Use a timeout to make resizing work more reliable
                // (Should be using an "args" method instead)
                window.setTimeout(function() {returnToBaseHeight();}, 150);
            }
        }
    })
});