/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.gadgets.metadata;

import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.browser.beans.MacroBody;
import com.atlassian.confluence.macro.browser.beans.MacroCategory;
import com.atlassian.confluence.macro.browser.beans.MacroFormDetails;
import com.atlassian.confluence.macro.browser.beans.MacroIcon;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.macro.browser.beans.MacroParameter;
import com.atlassian.confluence.macro.browser.beans.MacroParameterType;
import com.atlassian.confluence.macro.browser.beans.MacroSummary;
import com.atlassian.confluence.plugins.gadgets.events.GadgetMacroMetadataBuildEvent;
import com.atlassian.confluence.plugins.gadgets.metadata.GadgetMacroMetadata;
import com.atlassian.confluence.plugins.gadgets.metadata.GadgetMacroMetadataBuilder;
import com.atlassian.confluence.plugins.gadgets.metadata.GadgetMacroParameter;
import com.atlassian.confluence.plugins.gadgets.requestcontext.RequestContextBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Iterables;
import com.atlassian.gadgets.GadgetParsingException;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetSpecProvider;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpec;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpecStore;
import com.atlassian.gadgets.directory.spi.SubscribedGadgetFeed;
import com.atlassian.gadgets.directory.spi.SubscribedGadgetFeedStore;
import com.atlassian.gadgets.feed.GadgetFeedReader;
import com.atlassian.gadgets.feed.GadgetFeedReaderFactory;
import com.atlassian.gadgets.spec.DataType;
import com.atlassian.gadgets.spec.GadgetSpec;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.gadgets.spec.UserPrefSpec;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GadgetsMacroMetadataProvider {
    private static final Logger log = LoggerFactory.getLogger(GadgetsMacroMetadataProvider.class);
    private final GadgetSpecProvider gadgetSpecProvider;
    private final ExternalGadgetSpecStore gadgetStore;
    private final SubscribedGadgetFeedStore feedStore;
    private final GadgetFeedReaderFactory gadgetFeedReaderFactory;
    private final GadgetSpecFactory gadgetSpecFactory;
    private final RequestContextBuilder requestContextBuilder;
    private final I18nResolver resolver;
    private final EventPublisher eventPublisher;
    private static final String GADGET_MACRO_NAME = "gadget";
    private static final String DUMMY_PLUGIN_KEY = "gadgets";
    private static final String GADGET_PREFIX = "gadget-";
    private static final String IS_CONFIGURED = "isConfigured";

    GadgetsMacroMetadataProvider(GadgetSpecProvider gadgetSpecProvider, ExternalGadgetSpecStore gadgetStore, SubscribedGadgetFeedStore feedStore, GadgetFeedReaderFactory gadgetFeedReaderFactory, GadgetSpecFactory gadgetSpecFactory, RequestContextBuilder requestContextBuilder, I18nResolver resolver, EventPublisher eventPublisher) {
        this.gadgetSpecProvider = gadgetSpecProvider;
        this.gadgetStore = gadgetStore;
        this.feedStore = feedStore;
        this.gadgetFeedReaderFactory = gadgetFeedReaderFactory;
        this.gadgetSpecFactory = gadgetSpecFactory;
        this.requestContextBuilder = requestContextBuilder;
        this.resolver = resolver;
        this.eventPublisher = eventPublisher;
    }

    Collection<MacroMetadata> getMacroMetadata(Set<URI> uris) {
        this.eventPublisher.publish((Object)new GadgetMacroMetadataBuildEvent(uris.size()));
        Set<GadgetSpec> specs = this.getGadgetSpecs(uris);
        return this.convertToMacroMetadata(specs);
    }

    private Collection<MacroMetadata> convertToMacroMetadata(Set<GadgetSpec> specs) {
        HashSet data = Sets.newHashSet();
        for (GadgetSpec spec : specs) {
            String location;
            MacroParameter urlParam = new MacroParameter(DUMMY_PLUGIN_KEY, GADGET_MACRO_NAME, "url", MacroParameterType.STRING, true, false, spec.getUrl().toString(), true);
            MacroParameter width = new MacroParameter(DUMMY_PLUGIN_KEY, GADGET_MACRO_NAME, "width", MacroParameterType.INT, false, false, "450", false);
            MacroParameter border = new MacroParameter(DUMMY_PLUGIN_KEY, GADGET_MACRO_NAME, "border", MacroParameterType.BOOLEAN, false, false, "true", false);
            MacroParameter author = new MacroParameter(DUMMY_PLUGIN_KEY, GADGET_MACRO_NAME, "author", MacroParameterType.STRING, false, false, spec.getAuthor(), false);
            MacroParameter gadgetPreferences = new MacroParameter(DUMMY_PLUGIN_KEY, GADGET_MACRO_NAME, "preferences", MacroParameterType.STRING, false, false, "", true);
            ArrayList macroParams = Lists.newArrayList();
            boolean hasNonHiddenPrefs = false;
            boolean needsConfig = false;
            for (UserPrefSpec userPrefSpec : spec.getUserPrefs()) {
                if (userPrefSpec.getDataType() != DataType.HIDDEN) {
                    hasNonHiddenPrefs = true;
                    macroParams.add(new GadgetMacroParameter(userPrefSpec));
                    continue;
                }
                if (!userPrefSpec.getName().equals(IS_CONFIGURED)) continue;
                needsConfig = true;
            }
            macroParams.add(urlParam);
            macroParams.add(width);
            macroParams.add(border);
            macroParams.add(author);
            macroParams.add(gadgetPreferences);
            MacroBody body = new MacroBody(DUMMY_PLUGIN_KEY, GADGET_MACRO_NAME, true);
            body.setBodyType(Macro.BodyType.NONE.toString());
            MacroFormDetails details = MacroFormDetails.builder().macroName(GADGET_MACRO_NAME).parameters((List)macroParams).body(body).build();
            HashSet categories = Sets.newHashSet((Object[])new String[]{MacroCategory.EXTERNAL_CONTENT.getName()});
            String title = spec.getDirectoryTitle();
            if (StringUtils.isBlank((String)title)) {
                title = spec.getTitle();
            }
            MacroIcon macroIcon = null;
            URI thumbnail = spec.getThumbnail();
            if (thumbnail != null && !(location = thumbnail.toString()).equals("")) {
                macroIcon = new MacroIcon(location, !thumbnail.isAbsolute(), 40, 80);
            }
            StringBuilder extendedDescription = new StringBuilder();
            if (StringUtils.isNotBlank((String)spec.getDescription())) {
                extendedDescription.append(spec.getDescription());
            }
            extendedDescription.append(this.resolver.getText("gadgets.configure.params.below"));
            if (!hasNonHiddenPrefs) {
                extendedDescription.append(this.resolver.getText("gadgets.configure.params.extra"));
            }
            GadgetMacroMetadataBuilder gadgetMacroMetadataBuilder = GadgetMacroMetadata.builder();
            gadgetMacroMetadataBuilder.setNonHiddenUserPrefs(hasNonHiddenPrefs).setNeedsConfig(needsConfig).setAlternativeDescription(extendedDescription.toString()).setMacroName(GADGET_MACRO_NAME).setPluginKey(DUMMY_PLUGIN_KEY).setTitle(title).setIcon(macroIcon).setDescription(spec.getDescription()).setAliases(Collections.emptySet()).setCategories((Set)categories).setBodyDeprecated(false).setHidden(false).setFormDetails(details).setAlternateId(GADGET_PREFIX + DigestUtils.md5Hex((String)spec.getUrl().toString()));
            data.add(gadgetMacroMetadataBuilder.build());
        }
        return data;
    }

    private Set<GadgetSpec> getGadgetSpecs(Set<URI> uris) {
        HashSet specs = Sets.newHashSet();
        GadgetRequestContext requestContext = this.requestContextBuilder.buildRequestContext(false);
        for (URI uri : uris) {
            log.trace("Fetching gadget spec for gadget {} at URI {}", (Object)uri.getPath(), (Object)uri);
            try {
                specs.add(this.gadgetSpecFactory.getGadgetSpec(uri, requestContext));
            }
            catch (GadgetParsingException e) {
                String message = "Unable to parse gadget spec [ " + uri + " ]";
                if (log.isDebugEnabled()) {
                    log.debug(message, (Throwable)e);
                    continue;
                }
                log.warn(message + ": " + e.getMessage());
            }
        }
        return specs;
    }

    Set<URI> getGadgetUris() {
        return ImmutableSet.builder().addAll(this.getUrisFromGadgetSpecProvider()).addAll(this.getUrisFromGadgetStore()).addAll(this.getUrisFromFeedStore()).build();
    }

    private Set<URI> getUrisFromFeedStore() {
        log.debug("Fetching gadget URIs from subscribed gadget feed store");
        HashSet uris = Sets.newHashSet();
        for (SubscribedGadgetFeed feed : this.feedStore.getAllFeeds()) {
            try {
                GadgetFeedReader reader = this.gadgetFeedReaderFactory.getFeedReader(feed.getUri());
                com.google.common.collect.Iterables.addAll((Collection)uris, (Iterable)reader.entries());
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Error reading gadget feed from {}", (Object)feed.getUri(), (Object)e);
                    continue;
                }
                log.info("Error reading gadget feed from {}: {}", (Object)feed.getUri(), (Object)e.getMessage());
            }
        }
        log.debug("Fetched {} gadget URIs from subscribed gadget feed store", (Object)uris.size());
        return uris;
    }

    private Set<URI> getUrisFromGadgetStore() {
        log.debug("Fetching gadget URIs from external gadget spec store");
        HashSet uris = Sets.newHashSet();
        for (ExternalGadgetSpec externalGadgetSpec : this.gadgetStore.entries()) {
            uris.add(externalGadgetSpec.getSpecUri());
        }
        log.debug("Fetched {} gadget URIs from external gadget spec store", (Object)uris.size());
        return uris;
    }

    private Set<URI> getUrisFromGadgetSpecProvider() {
        log.debug("Fetching gadget URIs from gadget spec provider");
        HashSet uris = Sets.newHashSet((Iterable)this.gadgetSpecProvider.entries());
        log.debug("Fetched {} gadget URIs from gadget spec provider", (Object)uris.size());
        return uris;
    }

    static Collection<MacroSummary> getSummaries(Collection<MacroMetadata> macroMetadata) {
        ArrayList summaries = Lists.newArrayList();
        for (MacroMetadata metadata : macroMetadata) {
            summaries.add(metadata.extractMacroSummary());
        }
        return summaries;
    }

    static MacroMetadata getByMacroNameAndId(final String macroName, final String alternateId, Collection<MacroMetadata> macroMetadata) {
        return (MacroMetadata)Iterables.findFirst(macroMetadata, (Predicate)new Predicate<MacroMetadata>(){

            public boolean apply(MacroMetadata input) {
                return macroName.equals(input.getMacroName()) && GadgetsMacroMetadataProvider.hasMatchingId(alternateId, input);
            }
        }).getOrNull();
    }

    private static boolean hasMatchingId(String alternateId, MacroMetadata macroMetadata) {
        return StringUtils.isEmpty((String)alternateId) || alternateId.equals(macroMetadata.getAlternateId());
    }
}

