/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist2.util;

import com.atlassian.confluence.extra.dynamictasklist2.util.Base32;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;

public final class TaskListUtil {
    private static boolean ADG_ENABLED = Long.parseLong(GeneralUtil.getBuildNumber()) >= 4000L;

    public static String sanitizeTaskName(String name) {
        StringBuffer sb = new StringBuffer(name.length());
        char[] chars = name.trim().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '|' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String desanitizeTaskName(String name) {
        StringBuffer sb = new StringBuffer(name.length());
        char[] chars = name.trim().toCharArray();
        boolean escaped = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '|' && escaped) {
                sb.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (escaped) {
                    sb.append(c);
                }
                escaped = !escaped;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int incrementOccuranceInPageContext(String listName, PageContext pageContext) {
        String encodedListName;
        try {
            encodedListName = Base32.encode(StringUtils.defaultString((String)listName).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String occuranceParam = "dynamictasklist.occurance." + encodedListName;
        int occurance = 1;
        if (pageContext.getParam((Object)occuranceParam) != null) {
            occurance = (Integer)pageContext.getParam((Object)occuranceParam) + 1;
        }
        pageContext.addParam((Object)occuranceParam, (Object)new Integer(occurance));
        return occurance;
    }

    public static String getTaskListName(MacroDefinition macroDefinition) {
        String result = (String)macroDefinition.getParameters().get("title");
        if (result == null) {
            result = macroDefinition.getDefaultParameterValue();
        }
        return StringUtils.defaultString((String)result);
    }

    public static boolean isAdgEnabled() {
        return ADG_ENABLED;
    }
}

