/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist2;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.NastyUtilitiesWhichWillBeMadeRedundant;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.PlainTextMacroBody;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.dynamictasklist2.LegacyTextDataFormatUpgrader;
import com.atlassian.confluence.extra.dynamictasklist2.LegacyXmlDataFormatInContentPropertyUpgrader;
import com.atlassian.confluence.extra.dynamictasklist2.model.TaskList;
import com.atlassian.confluence.extra.dynamictasklist2.model.TaskListSerializer;
import com.atlassian.confluence.extra.dynamictasklist2.util.TaskListUtil;
import com.atlassian.confluence.macro.xhtml.MacroMigration;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;

public class WikiMarkupTaskListMacroMigration
implements MacroMigration {
    private final LegacyXmlDataFormatInContentPropertyUpgrader legacyXmlDataFormatInContentPropertyUpgrader;
    private final LegacyTextDataFormatUpgrader legacyTextDataFormatUpgrader;
    private final TaskListSerializer taskListSerializer;
    private static final int DUMMY_OCCURRENCE = 1;

    public WikiMarkupTaskListMacroMigration(LegacyXmlDataFormatInContentPropertyUpgrader legacyXmlDataFormatInContentPropertyUpgrader, TaskListSerializer taskListSerializer, LegacyTextDataFormatUpgrader legacyTextDataFormatUpgrader) {
        this.legacyXmlDataFormatInContentPropertyUpgrader = legacyXmlDataFormatInContentPropertyUpgrader;
        this.legacyTextDataFormatUpgrader = legacyTextDataFormatUpgrader;
        this.taskListSerializer = taskListSerializer;
    }

    public MacroDefinition migrate(MacroDefinition macroDefinition, ConversionContext conversionContext) {
        PageContext pageContext = NastyUtilitiesWhichWillBeMadeRedundant.extractPageContext((ConversionContext)conversionContext);
        if (pageContext == null) {
            return macroDefinition;
        }
        ContentEntityObject content = pageContext.getEntity();
        if (content == null) {
            return macroDefinition;
        }
        TaskList upgradedTaskList = null;
        String listName = TaskListUtil.getTaskListName(macroDefinition);
        if (this.legacyXmlDataFormatInContentPropertyUpgrader.hasXmlDataFormattedListWithName(content, listName)) {
            upgradedTaskList = this.legacyXmlDataFormatInContentPropertyUpgrader.upgradeAndGet(content, listName, 1);
        } else if (this.legacyTextDataFormatUpgrader.hasLegacyTextDataFormattedTaskList(macroDefinition.getBodyText())) {
            upgradedTaskList = this.legacyTextDataFormatUpgrader.upgradeAndGet(content, listName, 1, macroDefinition.getBodyText());
        }
        MacroDefinition result = macroDefinition;
        if (upgradedTaskList != null) {
            result.setName("tasklist");
            result.setBody((MacroBody)new PlainTextMacroBody(this.taskListSerializer.serialize(upgradedTaskList)));
        }
        return result;
    }
}

