/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist2;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.extra.dynamictasklist2.TaskListConverter;
import com.atlassian.confluence.extra.dynamictasklist2.model.LegacyTask;
import com.atlassian.confluence.extra.dynamictasklist2.model.LegacyTaskList;
import com.atlassian.confluence.extra.dynamictasklist2.model.Task;
import com.atlassian.confluence.extra.dynamictasklist2.model.TaskList;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class LegacyXmlDataFormatInContentPropertyUpgrader {
    private static final Logger log = LoggerFactory.getLogger(LegacyXmlDataFormatInContentPropertyUpgrader.class);
    private final ContentPropertyManager contentPropertyManager;
    private final XStream xStream;

    public LegacyXmlDataFormatInContentPropertyUpgrader(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
        this.xStream = new XStream();
    }

    public boolean hasXmlDataFormattedListWithName(ContentEntityObject contentObject, String listName) {
        String key = this.createKey(listName);
        String textProperty = this.contentPropertyManager.getTextProperty(contentObject, key);
        return textProperty != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskList upgradeAndGet(ContentEntityObject contentObject, String listName, int occurance) {
        TaskList list;
        ClassLoader callersLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String listAsXml = this.contentPropertyManager.getTextProperty(contentObject, this.createKey(listName));
            if (listAsXml == null) {
                TaskList taskList = new TaskList(listName, occurance);
                return taskList;
            }
            listAsXml = this.replaceLegacyClassNames(listAsXml);
            LegacyTaskList oldList = null;
            try {
                oldList = (LegacyTaskList)this.xStream.fromXML(listAsXml);
            }
            catch (ConversionException ex) {
                if (log.isInfoEnabled()) {
                    log.info("Attempting to convert old task list model");
                }
                oldList = this.convertXmlTaskList(listAsXml);
            }
            catch (ClassCastException e) {
                log.error("could not cast result to TaskList", (Throwable)e);
            }
            finally {
                list = oldList == null ? new TaskList(listName, occurance) : this.convertDataModel(oldList, occurance);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(callersLoader);
        }
        return list;
    }

    private String replaceLegacyClassNames(String listAsXml) {
        listAsXml = listAsXml.replaceAll("\\<(\\/?)com\\.atlassian\\.confluence\\.extra\\.dynamictasklist\\.model\\.Task((List)?)\\>", "<$1com.atlassian.confluence.extra.dynamictasklist2.model.LegacyTask$2>");
        return listAsXml;
    }

    private LegacyTaskList convertXmlTaskList(String listAsXml) {
        try {
            TaskListConverter converter = new TaskListConverter();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            saxParserFactory.setNamespaceAware(false);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(listAsXml)), (DefaultHandler)converter);
            return converter.getTaskList();
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    private TaskList convertDataModel(LegacyTaskList oldList, int occurance) {
        TaskList newList = new TaskList(oldList.getNiceName(), occurance);
        for (LegacyTask oldTask : oldList.getTasks()) {
            Task newTask = new Task(oldTask.getName(), newList);
            if (oldTask.isCompleted()) {
                newTask.setAssignee(oldTask.getCompleter());
                newTask.setCompleted(oldTask.isCompleted());
            }
            newList.addTask(newTask);
        }
        newList.setSourceMacro("dynamictasklist");
        return newList;
    }

    private String createKey(String listName) {
        String listNameTrimmed = StringUtils.defaultString((String)StringUtils.trim((String)listName)).replaceAll("\\s", "_");
        if (!StringUtils.isEmpty((String)listNameTrimmed)) {
            int listLength = listNameTrimmed.length() - 1;
            int subtringMax = Math.min(listLength, 100);
            listName = listNameTrimmed.substring(0, subtringMax);
        }
        return "atlassian.dynamictasklist:" + listName;
    }
}

