/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist2;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.extra.dynamictasklist2.model.Task;
import com.atlassian.confluence.extra.dynamictasklist2.model.TaskList;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class LegacyTextDataFormatUpgrader {
    private final ContentPropertyManager contentPropertyManager;

    public LegacyTextDataFormatUpgrader(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public boolean hasLegacyTextDataFormattedTaskList(String content) {
        return content != null && content.trim().length() > 0 && !content.contains("|");
    }

    public TaskList upgradeAndGet(ContentEntityObject contentObject, String listName, int occurance, String body) {
        TaskList taskList = new TaskList(listName, occurance);
        StringTokenizer stringTokenizer = new StringTokenizer(body, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String entityKey;
            String completer;
            String name = StringUtils.defaultString((String)stringTokenizer.nextToken()).trim();
            Task task = new Task(name, taskList);
            task.setPriority(Task.Priority.MEDIUM);
            if (contentObject != null && StringUtils.isNotEmpty((String)(completer = this.contentPropertyManager.getStringProperty(contentObject, entityKey = this.createTaskKey(listName, task.getName()))))) {
                task.setCompleted(true);
                task.setAssignee(completer);
            }
            taskList.addTask(task);
        }
        taskList.setSourceMacro("tasklist");
        return taskList;
    }

    private String createTaskKey(String listName, String taskName) {
        return "tasklist." + StringUtils.defaultString((String)listName).hashCode() + "." + StringUtils.defaultString((String)taskName).hashCode();
    }
}

