/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist2;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import java.util.Date;

public class DateRenderer {
    private final UserAccessor userAccessor;
    private final FormatSettingsManager formatSettingsManager;

    public DateRenderer(UserAccessor userAccessor, FormatSettingsManager formatSettingsManager) {
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
    }

    public String render(long time, boolean showTime) {
        if (time == 0L) {
            return "N/A";
        }
        User user = AuthenticatedUserThreadLocal.getUser();
        DateFormatter formatter = this.userAccessor.getConfluenceUserPreferences(user).getDateFormatter(this.formatSettingsManager);
        if (showTime) {
            return formatter.formatDateTime(new Date(time));
        }
        return formatter.format(new Date(time));
    }
}

